/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UncompressedFileTask
extends ApkTask {
    private static final String TAG = "Matrix.UncompressedFileTask";
    private File inputFile;
    private Set<String> filterSuffix;
    private Map<String, Long> uncompressSizeMap;
    private Map<String, Long> compressSizeMap;

    public UncompressedFileTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 8;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getApkPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.UncompressedFileTask---APK-FILE-PATH can not be null!");
        }
        this.inputFile = new File(inputPath);
        if (!FileUtil.isLegalFile(this.inputFile)) {
            throw new TaskInitException("Matrix.UncompressedFileTask---APK-FILE-PATH '" + inputPath + "' is illegal!");
        }
        this.filterSuffix = new HashSet<String>();
        if (this.params.containsKey("--suffix") && !Util.isNullOrNil((String)this.params.get("--suffix"))) {
            String[] suffix;
            for (String suffixStr : suffix = ((String)this.params.get("--suffix")).split(",")) {
                this.filterSuffix.add(suffixStr.trim());
            }
        }
        this.uncompressSizeMap = new HashMap<String, Long>();
        this.compressSizeMap = new HashMap<String, Long>();
    }

    private String getSuffix(String name) {
        int index = name.indexOf(46);
        if (index >= 0 && index < name.length() - 1) {
            return name.substring(index + 1);
        }
        return "";
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.type, "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            JsonArray jsonArray = new JsonArray();
            Map<String, Pair<Long, Long>> entrySizeMap = this.config.getEntrySizeMap();
            if (!entrySizeMap.isEmpty()) {
                for (Map.Entry entry : entrySizeMap.entrySet()) {
                    String suffix = this.getSuffix((String)entry.getKey());
                    Pair size = (Pair)entry.getValue();
                    if (this.filterSuffix.isEmpty() || this.filterSuffix.contains(suffix)) {
                        if (!this.uncompressSizeMap.containsKey(suffix)) {
                            this.uncompressSizeMap.put(suffix, (Long)size.getFirst());
                        } else {
                            this.uncompressSizeMap.put(suffix, this.uncompressSizeMap.get(suffix) + (Long)size.getFirst());
                        }
                        if (!this.compressSizeMap.containsKey(suffix)) {
                            this.compressSizeMap.put(suffix, (Long)size.getSecond());
                            continue;
                        }
                        this.compressSizeMap.put(suffix, this.compressSizeMap.get(suffix) + (Long)size.getSecond());
                        continue;
                    }
                    Log.d(TAG, "file: %s, filter by suffix.", entry.getKey());
                }
            }
            for (String string : this.uncompressSizeMap.keySet()) {
                if (!this.uncompressSizeMap.get(string).equals(this.compressSizeMap.get(string))) continue;
                JsonObject fileItem = new JsonObject();
                fileItem.addProperty("suffix", string);
                fileItem.addProperty("total-size", this.uncompressSizeMap.get(string));
                jsonArray.add(fileItem);
            }
            ((TaskJsonResult)taskResult).add("files", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

