/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.google.gson.JsonArray;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnStrippedSoCheckTask
extends ApkTask {
    private static final String TAG = "Matrix.UnStrippedSoCheckTask";
    private File libDir;
    private String toolnmPath;

    public UnStrippedSoCheckTask(JobConfig jobConfig, Map<String, String> params) {
        super(jobConfig, params);
        this.type = 14;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        this.toolnmPath = (String)this.params.get("--toolnm");
        if (Util.isNullOrNil(this.toolnmPath)) {
            throw new TaskInitException("Matrix.UnStrippedSoCheckTask---The path of tool 'nm' is not given!");
        }
        Pattern envPattern = Pattern.compile("(\\$[a-zA-Z_-]+)");
        Matcher matcher = envPattern.matcher(this.toolnmPath);
        while (matcher.find()) {
            if (Util.isNullOrNil(matcher.group())) continue;
            String env = System.getenv(matcher.group().substring(1));
            Log.d(TAG, "%s -> %s", matcher.group().substring(1), env);
            if (Util.isNullOrNil(env)) continue;
            this.toolnmPath = this.toolnmPath.replace(matcher.group(), env);
        }
        Log.i(TAG, "toolnm pah is %s", this.toolnmPath);
        if (!FileUtil.isLegalFile(this.toolnmPath)) {
            throw new TaskInitException("Matrix.UnStrippedSoCheckTask---Can not find the tool 'nm'!");
        }
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.UnStrippedSoCheckTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", inputPath);
        this.libDir = new File(inputPath, "lib");
    }

    private boolean isSoStripped(File libFile) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.toolnmPath, libFile.getAbsolutePath());
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String line = reader.readLine();
        boolean result = false;
        if (!Util.isNullOrNil(line)) {
            Log.d(TAG, "%s", line);
            String[] columns = line.split(":");
            if (columns.length == 3 && columns[2].trim().equalsIgnoreCase("no symbols")) {
                result = true;
            }
        }
        reader.close();
        process.waitFor();
        return result;
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            ArrayList<File> libFiles = new ArrayList<File>();
            JsonArray jsonArray = new JsonArray();
            if (this.libDir.exists() && this.libDir.isDirectory()) {
                File[] dirs;
                for (File dir : dirs = this.libDir.listFiles()) {
                    File[] libs;
                    if (!dir.isDirectory()) continue;
                    for (File libFile : libs = dir.listFiles()) {
                        if (!libFile.isFile() || !libFile.getName().endsWith(".so")) continue;
                        libFiles.add(libFile);
                    }
                }
            }
            for (File libFile : libFiles) {
                if (this.isSoStripped(libFile)) continue;
                Log.i(TAG, "lib: %s is not stripped", libFile.getName());
                jsonArray.add(libFile.getName());
            }
            ((TaskJsonResult)taskResult).add("unstripped-lib", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

