/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.CountClassTask;
import com.tencent.matrix.apk.model.task.CountRTask;
import com.tencent.matrix.apk.model.task.DuplicateFileTask;
import com.tencent.matrix.apk.model.task.FindNonAlphaPngTask;
import com.tencent.matrix.apk.model.task.ManifestAnalyzeTask;
import com.tencent.matrix.apk.model.task.MethodCountTask;
import com.tencent.matrix.apk.model.task.MultiLibCheckTask;
import com.tencent.matrix.apk.model.task.MultiSTLCheckTask;
import com.tencent.matrix.apk.model.task.ResProguardCheckTask;
import com.tencent.matrix.apk.model.task.ShowFileSizeTask;
import com.tencent.matrix.apk.model.task.UnStrippedSoCheckTask;
import com.tencent.matrix.apk.model.task.UncompressedFileTask;
import com.tencent.matrix.apk.model.task.UnusedAssetsTask;
import com.tencent.matrix.apk.model.task.UnusedResourcesTask;
import com.tencent.matrix.apk.model.task.UnzipTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TaskFactory {
    public static final int TASK_TYPE_UNZIP = 1;
    public static final int TASK_TYPE_MANIFEST = 2;
    public static final int TASK_TYPE_SHOW_FILE_SIZE = 3;
    public static final int TASK_TYPE_COUNT_METHOD = 4;
    public static final int TASK_TYPE_CHECK_RESGUARD = 5;
    public static final int TASK_TYPE_FIND_NON_ALPHA_PNG = 6;
    public static final int TASK_TYPE_CHECK_MULTILIB = 7;
    public static final int TASK_TYPE_UNCOMPRESSED_FILE = 8;
    public static final int TASK_TYPE_COUNT_R_CLASS = 9;
    public static final int TASK_TYPE_DUPLICATE_FILE = 10;
    public static final int TASK_TYPE_CHECK_MULTISTL = 11;
    public static final int TASK_TYPE_UNUSED_RESOURCES = 12;
    public static final int TASK_TYPE_UNUSED_ASSETS = 13;
    public static final int TASK_TYPE_UNSTRIPPED_SO = 14;
    public static final int TASK_TYPE_COUNT_CLASS = 15;
    public static final List<String> TaskDescription = Collections.unmodifiableList(Arrays.asList("Useless Task for default task type.", "Unzip the apk file to dest path.", "Read package info from the AndroidManifest.xml.", "Show files whose size exceed limit size in order.", "Count methods in dex file, output results group by class name or package name.", "Check if the apk handled by resguard.", "Find out the non-alpha png-format files whose size exceed limit size in desc order.", "Check if there are more than one library dir in the 'lib'.", "Show uncompressed file types.", "Count the R class.", "Find out the duplicated files.", "Check if there are more than one shared library statically linked the STL.", "Find out the unused resources.", "Find out the unused assets.", "Find out the unstripped shared library files.", "Count classes in dex file, output results group by package name."));
    public static final List<String> TaskOptionName = Collections.unmodifiableList(Arrays.asList("", "", "-manifest", "-fileSize", "-countMethod", "-checkResProguard", "-findNonAlphaPng", "-checkMultiLibrary", "-uncompressedFile", "-countR", "-duplicatedFile", "-checkMultiSTL", "-unusedResources", "-unusedAssets", "-unstrippedSo", "-countClass"));

    public static ApkTask factory(int taskType, JobConfig config, Map<String, String> params) {
        ApkTask task = null;
        switch (taskType) {
            case 1: {
                task = new UnzipTask(config, params);
                break;
            }
            case 2: {
                task = new ManifestAnalyzeTask(config, params);
                break;
            }
            case 3: {
                task = new ShowFileSizeTask(config, params);
                break;
            }
            case 4: {
                task = new MethodCountTask(config, params);
                break;
            }
            case 5: {
                task = new ResProguardCheckTask(config, params);
                break;
            }
            case 6: {
                task = new FindNonAlphaPngTask(config, params);
                break;
            }
            case 7: {
                task = new MultiLibCheckTask(config, params);
                break;
            }
            case 8: {
                task = new UncompressedFileTask(config, params);
                break;
            }
            case 9: {
                task = new CountRTask(config, params);
                break;
            }
            case 10: {
                task = new DuplicateFileTask(config, params);
                break;
            }
            case 11: {
                task = new MultiSTLCheckTask(config, params);
                break;
            }
            case 12: {
                task = new UnusedResourcesTask(config, params);
                break;
            }
            case 13: {
                task = new UnusedAssetsTask(config, params);
                break;
            }
            case 14: {
                task = new UnStrippedSoCheckTask(config, params);
                break;
            }
            case 15: {
                task = new CountClassTask(config, params);
                break;
            }
        }
        return task;
    }
}

