/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShowFileSizeTask
extends ApkTask {
    private static final String TAG = "Matrix.ShowFileSizeTask";
    private File inputFile;
    private String order = "desc";
    private long downLimit;
    private Set<String> filterSuffix;
    private List<Pair<String, Long>> entryList;

    public ShowFileSizeTask(JobConfig jobConfig, Map<String, String> params) {
        super(jobConfig, params);
        this.type = 3;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.ShowFileSizeTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", inputPath);
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.ShowFileSizeTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.ShowFileSizeTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        if (this.params.containsKey("--min")) {
            try {
                this.downLimit = Long.parseLong((String)this.params.get("--min"));
            }
            catch (NumberFormatException e) {
                Log.e(TAG, "DOWN-LIMIT-SIZE '" + (String)this.params.get("--min") + "' is not number format!", new Object[0]);
            }
        }
        if (this.params.containsKey("--order")) {
            if ("asc".equals(this.params.get("--order"))) {
                this.order = "asc";
            } else if ("desc".equals(this.params.get("--order"))) {
                this.order = "desc";
            } else {
                Log.e(TAG, "ORDER-BY '" + (String)this.params.get("--order") + "' is not correct!", new Object[0]);
            }
        }
        this.filterSuffix = new HashSet<String>();
        if (this.params.containsKey("--suffix") && !Util.isNullOrNil((String)this.params.get("--suffix"))) {
            String[] suffix;
            for (String suffixStr : suffix = ((String)this.params.get("--suffix")).split(",")) {
                this.filterSuffix.add(suffixStr.trim());
            }
        }
        this.entryList = new ArrayList<Pair<String, Long>>();
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            Map<String, Pair<Long, Long>> entrySizeMap = this.config.getEntrySizeMap();
            if (!entrySizeMap.isEmpty()) {
                for (Map.Entry<String, Pair<Long, Long>> entry : entrySizeMap.entrySet()) {
                    String suffix = this.getSuffix(entry.getKey());
                    Pair<Long, Long> size = entry.getValue();
                    if (size.getFirst() >= this.downLimit * 1024L) {
                        if (this.filterSuffix.isEmpty() || this.filterSuffix.contains(suffix)) {
                            this.entryList.add(Pair.of(entry.getKey(), size.getFirst()));
                            continue;
                        }
                        Log.d(TAG, "file: %s, filter by suffix.", entry.getKey());
                        continue;
                    }
                    Log.d(TAG, "file:%s, size:%d B, downlimit:%d KB", entry.getKey(), size.getFirst(), this.downLimit);
                }
            }
            Collections.sort(this.entryList, new Comparator<Pair<String, Long>>(){

                @Override
                public int compare(Pair<String, Long> entry1, Pair<String, Long> entry2) {
                    long file2Len;
                    long file1Len = entry1.getSecond();
                    if (file1Len < (file2Len = entry2.getSecond().longValue())) {
                        if (ShowFileSizeTask.this.order.equals("asc")) {
                            return -1;
                        }
                        return 1;
                    }
                    if (file1Len > file2Len) {
                        if (ShowFileSizeTask.this.order.equals("desc")) {
                            return -1;
                        }
                        return 1;
                    }
                    return 0;
                }
            });
            JsonArray jsonArray = new JsonArray();
            for (Pair<String, Long> sortFile : this.entryList) {
                JsonObject fileItem = new JsonObject();
                fileItem.addProperty("entry-name", sortFile.getFirst());
                fileItem.addProperty("entry-size", sortFile.getSecond());
                jsonArray.add(fileItem);
            }
            ((TaskJsonResult)taskResult).add("files", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }

    private String getSuffix(String name) {
        int index = name.indexOf(46);
        if (index >= 0 && index < name.length() - 1) {
            return name.substring(index + 1);
        }
        return "";
    }
}

