/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

public class ResProguardCheckTask
extends ApkTask {
    private static final String TAG = "Matrix.ResProguardCheckTask";
    private File inputFile;
    private Pattern fileNamePattern;

    public ResProguardCheckTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 5;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.ResProguardCheckTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", inputPath);
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.ResProguardCheckTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.ResProguardCheckTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        this.fileNamePattern = Pattern.compile("[a-z_0-9]{1,3}");
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        File resDir = new File(this.inputFile, "r");
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            if (resDir.exists() && resDir.isDirectory()) {
                Log.i(TAG, "find resource directory " + resDir.getAbsolutePath(), new Object[0]);
                ((TaskJsonResult)taskResult).add("hasResProguard", true);
            } else {
                resDir = new File(this.inputFile, "res");
                if (resDir.exists() && resDir.isDirectory()) {
                    File[] dirs = resDir.listFiles();
                    boolean hasProguard = true;
                    for (File dir : dirs) {
                        if (!dir.isDirectory() || this.fileNamePattern.matcher(dir.getName()).matches()) continue;
                        hasProguard = false;
                        Log.i(TAG, "directory " + dir.getName() + " has a non-proguard name!", new Object[0]);
                        break;
                    }
                    ((TaskJsonResult)taskResult).add("hasResProguard", hasProguard);
                } else {
                    throw new TaskExecuteException("Matrix.ResProguardCheckTask---No resource directory found!");
                }
            }
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

