/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.google.gson.JsonArray;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.util.Map;

public class MultiLibCheckTask
extends ApkTask {
    private static final String TAG = "Matrix.MultiLibCheckTask";
    private File libDir;

    public MultiLibCheckTask(JobConfig jobConfig, Map<String, String> params) {
        super(jobConfig, params);
        this.type = 7;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.MultiLibCheckTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", inputPath);
        this.libDir = new File(inputPath, "lib");
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            JsonArray jsonArray = new JsonArray();
            if (this.libDir.exists() && this.libDir.isDirectory()) {
                File[] dirs;
                for (File dir : dirs = this.libDir.listFiles()) {
                    if (!dir.isDirectory()) continue;
                    jsonArray.add(dir.getName());
                }
            }
            ((TaskJsonResult)taskResult).add("lib-dirs", jsonArray);
            if (jsonArray.size() > 1) {
                ((TaskJsonResult)taskResult).add("multi-lib", true);
            } else {
                ((TaskJsonResult)taskResult).add("multi-lib", false);
            }
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

