/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexData;
import com.android.dexdeps.MethodRef;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ApkUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MethodCountTask
extends ApkTask {
    private static final String TAG = "Matrix.MethodCountTask";
    private File inputFile;
    private String group = "package";
    private final List<String> dexFileNameList;
    private final List<RandomAccessFile> dexFileList;
    private final Map<String, Integer> classInternalMethod;
    private final Map<String, Integer> classExternalMethod;
    private final Map<String, Integer> pkgInternalRefMethod;
    private final Map<String, Integer> pkgExternalMethod;

    public MethodCountTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 4;
        this.dexFileNameList = new ArrayList<String>();
        this.dexFileList = new ArrayList<RandomAccessFile>();
        this.classInternalMethod = new HashMap<String, Integer>();
        this.classExternalMethod = new HashMap<String, Integer>();
        this.pkgInternalRefMethod = new HashMap<String, Integer>();
        this.pkgExternalMethod = new HashMap<String, Integer>();
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.MethodCountTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "input path:%s", inputPath);
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.MethodCountTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.MethodCountTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        File[] files = this.inputFile.listFiles();
        try {
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    this.dexFileNameList.add(file.getName());
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.dexFileList.add(randomAccessFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TaskInitException(e.getMessage(), e);
        }
        if (this.params.containsKey("--group")) {
            if ("package".equals(this.params.get("--group"))) {
                this.group = "package";
            } else if ("class".equals(this.params.get("--group"))) {
                this.group = "class";
            } else {
                Log.e(TAG, "GROUP-BY '" + (String)this.params.get("--group") + "' is not correct!", new Object[0]);
            }
        }
    }

    private void countDex(RandomAccessFile dexFile) throws IOException {
        this.classInternalMethod.clear();
        this.classExternalMethod.clear();
        this.pkgInternalRefMethod.clear();
        this.pkgExternalMethod.clear();
        DexData dexData = new DexData(dexFile);
        dexData.load();
        MethodRef[] methodRefs = dexData.getMethodRefs();
        ClassRef[] externalClassRefs = dexData.getExternalReferences();
        Map<String, String> proguardClassMap = this.config.getProguardClassMap();
        String className = null;
        for (ClassRef classRef : externalClassRefs) {
            className = ApkUtil.getNormalClassName(classRef.getName());
            if (proguardClassMap.containsKey(className)) {
                className = proguardClassMap.get(className);
            }
            if (className.indexOf(46) == -1) continue;
            this.classExternalMethod.put(className, 0);
        }
        for (MethodRef methodRef : methodRefs) {
            className = ApkUtil.getNormalClassName(methodRef.getDeclClassName());
            if (proguardClassMap.containsKey(className)) {
                className = proguardClassMap.get(className);
            }
            if (Util.isNullOrNil(className) || className.indexOf(46) == -1) continue;
            if (this.classExternalMethod.containsKey(className)) {
                this.classExternalMethod.put(className, this.classExternalMethod.get(className) + 1);
                continue;
            }
            if (this.classInternalMethod.containsKey(className)) {
                this.classInternalMethod.put(className, this.classInternalMethod.get(className) + 1);
                continue;
            }
            this.classInternalMethod.put(className, 1);
        }
        Iterator<String> iterator = this.classExternalMethod.keySet().iterator();
        while (iterator.hasNext()) {
            if (this.classExternalMethod.get(iterator.next()) != 0) continue;
            iterator.remove();
        }
    }

    private List<String> sortKeyByValue(final Map<String, Integer> map) {
        LinkedList<String> list = new LinkedList<String>();
        list.addAll(map.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String class1, String class2) {
                if ((Integer)map.get(class1) > (Integer)map.get(class2)) {
                    return -1;
                }
                if ((Integer)map.get(class1) < (Integer)map.get(class2)) {
                    return 1;
                }
                return 0;
            }
        });
        return list;
    }

    private int sumOfValue(Map<String, Integer> map) {
        Iterator<Integer> iterator = map.values().iterator();
        int sum = 0;
        while (iterator.hasNext()) {
            sum += iterator.next().intValue();
        }
        return sum;
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < this.dexFileList.size(); ++i) {
                JsonObject pkgObj;
                Object packages;
                List<String> sortList;
                String packageName;
                JsonObject classObj;
                Iterator<Map.Entry<String, Integer>> classes;
                RandomAccessFile dexFile = this.dexFileList.get(i);
                this.countDex(dexFile);
                dexFile.close();
                int totalInternalMethods = this.sumOfValue(this.classInternalMethod);
                int totalExternalMethods = this.sumOfValue(this.classExternalMethod);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("dex-file", this.dexFileNameList.get(i));
                if ("class".equals(this.group)) {
                    List<String> sortList2 = this.sortKeyByValue(this.classInternalMethod);
                    classes = new JsonArray();
                    for (String string : sortList2) {
                        classObj = new JsonObject();
                        classObj.addProperty("name", string);
                        classObj.addProperty("methods", this.classInternalMethod.get(string));
                        ((JsonArray)((Object)classes)).add(classObj);
                    }
                    jsonObject.add("internal-classes", (JsonElement)((Object)classes));
                } else if ("package".equals(this.group)) {
                    for (Map.Entry<String, Integer> entry : this.classInternalMethod.entrySet()) {
                        packageName = ApkUtil.getPackageName((String)entry.getKey());
                        if (Util.isNullOrNil(packageName)) continue;
                        if (!this.pkgInternalRefMethod.containsKey(packageName)) {
                            this.pkgInternalRefMethod.put(packageName, (Integer)entry.getValue());
                            continue;
                        }
                        this.pkgInternalRefMethod.put(packageName, this.pkgInternalRefMethod.get(packageName) + (Integer)entry.getValue());
                    }
                    sortList = this.sortKeyByValue(this.pkgInternalRefMethod);
                    packages = new JsonArray();
                    for (String pkgName : sortList) {
                        pkgObj = new JsonObject();
                        pkgObj.addProperty("name", pkgName);
                        pkgObj.addProperty("methods", this.pkgInternalRefMethod.get(pkgName));
                        ((JsonArray)packages).add(pkgObj);
                    }
                    jsonObject.add("internal-packages", (JsonElement)packages);
                }
                jsonObject.addProperty("total-internal-classes", this.classInternalMethod.size());
                jsonObject.addProperty("total-internal-methods", totalInternalMethods);
                if ("class".equals(this.group)) {
                    List<String> sortList2 = this.sortKeyByValue(this.classExternalMethod);
                    classes = new JsonArray();
                    for (String string : sortList2) {
                        classObj = new JsonObject();
                        classObj.addProperty("name", string);
                        classObj.addProperty("methods", this.classExternalMethod.get(string));
                        ((JsonArray)((Object)classes)).add(classObj);
                    }
                    jsonObject.add("external-classes", (JsonElement)((Object)classes));
                } else if ("package".equals(this.group)) {
                    packageName = "";
                    for (Map.Entry<String, Integer> entry : this.classExternalMethod.entrySet()) {
                        packageName = ApkUtil.getPackageName(entry.getKey());
                        if (Util.isNullOrNil(packageName)) continue;
                        if (!this.pkgExternalMethod.containsKey(packageName)) {
                            this.pkgExternalMethod.put(packageName, entry.getValue());
                            continue;
                        }
                        this.pkgExternalMethod.put(packageName, this.pkgExternalMethod.get(packageName) + entry.getValue());
                    }
                    sortList = this.sortKeyByValue(this.pkgExternalMethod);
                    packages = new JsonArray();
                    for (String pkgName : sortList) {
                        pkgObj = new JsonObject();
                        pkgObj.addProperty("name", pkgName);
                        pkgObj.addProperty("methods", this.pkgExternalMethod.get(pkgName));
                        ((JsonArray)packages).add(pkgObj);
                    }
                    jsonObject.add("external-packages", (JsonElement)packages);
                }
                jsonObject.addProperty("total-external-classes", this.classExternalMethod.size());
                jsonObject.addProperty("total-external-methods", totalExternalMethods);
                jsonArray.add(jsonObject);
            }
            ((TaskJsonResult)taskResult).add("dex-files", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

