/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ManifestParser;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.util.Map;

public class ManifestAnalyzeTask
extends ApkTask {
    private static final String TAG = "Matrix.ManifestAnalyzeTask";
    private File inputFile;
    private File arscFile;

    public ManifestAnalyzeTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 2;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.ManifestAnalyzeTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "inputPath:%s", inputPath);
        this.inputFile = new File(inputPath, "AndroidManifest.xml");
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.ManifestAnalyzeTask---Manifest file '" + inputPath + File.separator + "AndroidManifest.xml" + "' is not exist!");
        }
        this.arscFile = new File(inputPath, "resources.arsc");
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            ManifestParser manifestParser = null;
            manifestParser = !FileUtil.isLegalFile(this.arscFile) ? new ManifestParser(this.inputFile) : new ManifestParser(this.inputFile, this.arscFile);
            TaskResult taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            if (taskResult == null) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            JsonObject jsonObject = manifestParser.parse();
            Log.d(TAG, jsonObject.toString(), new Object[0]);
            ((TaskJsonResult)taskResult).add("manifest", jsonObject);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

