/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class FindNonAlphaPngTask
extends ApkTask {
    private static final String TAG = "Matrix.FindNonAlphaPngTask";
    private File inputFile;
    private List<Pair<String, Long>> nonAlphaPngList;
    private long downLimitSize;
    private Map<String, Pair<Long, Long>> entrySizeMap;
    private Map<String, String> entryNameMap;

    public FindNonAlphaPngTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 6;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.FindNonAlphaPngTask---APK-UNZIP-PATH can not be null!");
        }
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.FindNonAlphaPngTask---APK-UNZIP-PATH '" + inputPath + "'is not exists!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.FindNonAlphaPngTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        if (this.params.containsKey("--min")) {
            try {
                this.downLimitSize = Long.parseLong((String)this.params.get("--min"));
            }
            catch (NumberFormatException e) {
                Log.e(TAG, "DOWN-LIMIT-SIZE '" + (String)this.params.get("--min") + "' is not number format!", new Object[0]);
            }
        }
        this.nonAlphaPngList = new ArrayList<Pair<String, Long>>();
        this.entrySizeMap = this.config.getEntrySizeMap();
        this.entryNameMap = this.config.getEntryNameMap();
    }

    private void findNonAlphaPng(File file) throws IOException {
        if (file != null) {
            BufferedImage bufferedImage;
            if (file.isDirectory()) {
                File[] files;
                for (File tempFile : files = file.listFiles()) {
                    this.findNonAlphaPng(tempFile);
                }
            } else if (file.isFile() && file.getName().endsWith(".png") && !file.getName().endsWith(".9.png") && (bufferedImage = ImageIO.read(file)) != null && bufferedImage.getColorModel() != null && !bufferedImage.getColorModel().hasAlpha()) {
                String filename = file.getAbsolutePath().substring(this.inputFile.getAbsolutePath().length() + 1);
                if (this.entryNameMap.containsKey(filename)) {
                    filename = this.entryNameMap.get(filename);
                }
                long size = file.length();
                if (this.entrySizeMap.containsKey(filename)) {
                    size = this.entrySizeMap.get(filename).getFirst();
                }
                if (size >= this.downLimitSize * 1024L) {
                    this.nonAlphaPngList.add(Pair.of(filename, file.length()));
                }
            }
        }
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        File resDir = new File(this.inputFile, "r");
        TaskResult taskResult = null;
        try {
            taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            long startTime = System.currentTimeMillis();
            if (resDir.exists() && resDir.isDirectory()) {
                this.findNonAlphaPng(resDir);
            } else {
                resDir = new File(this.inputFile, "res");
                if (resDir.exists() && resDir.isDirectory()) {
                    this.findNonAlphaPng(resDir);
                }
            }
            Collections.sort(this.nonAlphaPngList, new Comparator<Pair<String, Long>>(){

                @Override
                public int compare(Pair<String, Long> entry1, Pair<String, Long> entry2) {
                    long file2Len;
                    long file1Len = entry1.getSecond();
                    if (file1Len < (file2Len = entry2.getSecond().longValue())) {
                        return 1;
                    }
                    if (file1Len > file2Len) {
                        return -1;
                    }
                    return 0;
                }
            });
            JsonArray jsonArray = new JsonArray();
            for (Pair<String, Long> entry : this.nonAlphaPngList) {
                if (Util.isNullOrNil(entry.getFirst())) continue;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("entry-name", entry.getFirst());
                jsonObject.addProperty("entry-size", entry.getSecond());
                jsonArray.add(jsonObject);
            }
            ((TaskJsonResult)taskResult).add("files", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

