/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DuplicateFileTask
extends ApkTask {
    private static final String TAG = "Matrix.DuplicateFileTask";
    private File inputFile;
    private Map<String, List<String>> md5Map;
    private List<Pair<String, Long>> fileSizeList;
    private Map<String, Pair<Long, Long>> entrySizeMap;
    private Map<String, String> entryNameMap;

    public DuplicateFileTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 10;
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.DuplicateFileTask---APK-UNZIP-PATH can not be null!");
        }
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.DuplicateFileTask---APK-UNZIP-PATH '" + inputPath + "'is not exists!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.DuplicateFileTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        this.md5Map = new HashMap<String, List<String>>();
        this.fileSizeList = new ArrayList<Pair<String, Long>>();
        this.entrySizeMap = this.config.getEntrySizeMap();
        this.entryNameMap = this.config.getEntryNameMap();
    }

    private void computeMD5(File file) throws NoSuchAlgorithmException, IOException {
        if (file != null) {
            if (file.isDirectory()) {
                File[] files;
                for (File resFile : files = file.listFiles()) {
                    this.computeMD5(resFile);
                }
            } else {
                MessageDigest msgDigest = MessageDigest.getInstance("MD5");
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[512];
                int readSize = 0;
                long totalRead = 0L;
                while ((readSize = inputStream.read(buffer)) > 0) {
                    msgDigest.update(buffer, 0, readSize);
                    totalRead += (long)readSize;
                }
                inputStream.close();
                if (totalRead > 0L) {
                    String md5 = Util.byteArrayToHex(msgDigest.digest());
                    String filename = file.getAbsolutePath().substring(this.inputFile.getAbsolutePath().length() + 1);
                    if (this.entryNameMap.containsKey(filename)) {
                        filename = this.entryNameMap.get(filename);
                    }
                    if (!this.md5Map.containsKey(md5)) {
                        this.md5Map.put(md5, new ArrayList());
                        if (this.entrySizeMap.containsKey(filename)) {
                            this.fileSizeList.add(Pair.of(md5, this.entrySizeMap.get(filename).getFirst()));
                        } else {
                            this.fileSizeList.add(Pair.of(md5, totalRead));
                        }
                    }
                    this.md5Map.get(md5).add(filename);
                }
            }
        }
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        TaskResult taskResult = null;
        try {
            taskResult = TaskResultFactory.factory(this.getType(), "json", this.config);
            long startTime = System.currentTimeMillis();
            JsonArray jsonArray = new JsonArray();
            this.computeMD5(this.inputFile);
            Collections.sort(this.fileSizeList, new Comparator<Pair<String, Long>>(){

                @Override
                public int compare(Pair<String, Long> entry1, Pair<String, Long> entry2) {
                    long file2Len;
                    long file1Len = entry1.getSecond();
                    if (file1Len < (file2Len = entry2.getSecond().longValue())) {
                        return 1;
                    }
                    if (file1Len > file2Len) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (Pair<String, Long> entry : this.fileSizeList) {
                if (this.md5Map.get(entry.getFirst()).size() <= 1) continue;
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("md5", entry.getFirst());
                jsonObject.addProperty("size", entry.getSecond());
                JsonArray jsonFiles = new JsonArray();
                for (String filename : this.md5Map.get(entry.getFirst())) {
                    jsonFiles.add(filename);
                }
                jsonObject.add("files", jsonFiles);
                jsonArray.add(jsonObject);
            }
            ((TaskJsonResult)taskResult).add("files", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
        return taskResult;
    }
}

