/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexData;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ApkUtil;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountRTask
extends ApkTask {
    private static final String TAG = "Matrix.CountRTask";
    private File inputFile;
    private final List<String> dexFileNameList;
    private final List<RandomAccessFile> dexFileList;
    private final Map<String, Integer> classesMap;

    public CountRTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 9;
        this.dexFileNameList = new ArrayList<String>();
        this.dexFileList = new ArrayList<RandomAccessFile>();
        this.classesMap = new HashMap<String, Integer>();
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.CountRTask---APK-UNZIP-PATH can not be null!");
        }
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.CountRTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.CountRTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        File[] files = this.inputFile.listFiles();
        try {
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    this.dexFileNameList.add(file.getName());
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.dexFileList.add(randomAccessFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TaskInitException(e.getMessage(), e);
        }
    }

    private String getOuterClassName(String className) {
        int index;
        if (!Util.isNullOrNil(className) && (index = className.indexOf(36)) >= 0) {
            className = className.substring(0, index);
        }
        return className;
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.type, "json", this.config);
            long startTime = System.currentTimeMillis();
            Map<String, String> classProguardMap = this.config.getProguardClassMap();
            for (RandomAccessFile dexFile : this.dexFileList) {
                ClassRef[] defClassRefs;
                DexData dexData = new DexData(dexFile);
                dexData.load();
                dexFile.close();
                for (ClassRef classRef : defClassRefs = dexData.getInternalReferences()) {
                    String pureClassName;
                    String className = ApkUtil.getNormalClassName(classRef.getName());
                    if (classProguardMap.containsKey(className)) {
                        className = classProguardMap.get(className);
                    }
                    if (!(pureClassName = this.getOuterClassName(className)).endsWith(".R") && !"R".equals(pureClassName)) continue;
                    if (!this.classesMap.containsKey(pureClassName)) {
                        this.classesMap.put(pureClassName, classRef.getFieldArray().length);
                        continue;
                    }
                    this.classesMap.put(pureClassName, this.classesMap.get(pureClassName) + classRef.getFieldArray().length);
                }
            }
            JsonArray jsonArray = new JsonArray();
            long totalSize = 0L;
            Map<String, String> proguardClassMap = this.config.getProguardClassMap();
            for (Map.Entry entry : this.classesMap.entrySet()) {
                JsonObject jsonObject = new JsonObject();
                if (proguardClassMap.containsKey(entry.getKey())) {
                    jsonObject.addProperty("name", proguardClassMap.get(entry.getKey()));
                } else {
                    jsonObject.addProperty("name", (String)entry.getKey());
                }
                jsonObject.addProperty("field-count", (Number)entry.getValue());
                totalSize += (long)((Integer)entry.getValue()).intValue();
                jsonArray.add(jsonObject);
            }
            ((TaskJsonResult)taskResult).add("R-count", jsonArray.size());
            ((TaskJsonResult)taskResult).add("Field-counts", totalSize);
            ((TaskJsonResult)taskResult).add("R-classes", jsonArray);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }
}

