/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexData;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.util.ApkUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CountClassTask
extends ApkTask {
    private static final String TAG = "Matrix.CountClassTask";
    private File inputFile;
    private String group = "package";
    private final List<String> dexFileNameList;
    private final List<RandomAccessFile> dexFileList;

    public CountClassTask(JobConfig config, Map<String, String> params) {
        super(config, params);
        this.type = 15;
        this.dexFileNameList = new ArrayList<String>();
        this.dexFileList = new ArrayList<RandomAccessFile>();
    }

    @Override
    public void init() throws TaskInitException {
        super.init();
        String inputPath = this.config.getUnzipPath();
        if (Util.isNullOrNil(inputPath)) {
            throw new TaskInitException("Matrix.CountClassTask---APK-UNZIP-PATH can not be null!");
        }
        Log.i(TAG, "input path:%s", inputPath);
        this.inputFile = new File(inputPath);
        if (!this.inputFile.exists()) {
            throw new TaskInitException("Matrix.CountClassTask---APK-UNZIP-PATH '" + inputPath + "' is not exist!");
        }
        if (!this.inputFile.isDirectory()) {
            throw new TaskInitException("Matrix.CountClassTask---APK-UNZIP-PATH '" + inputPath + "' is not directory!");
        }
        File[] files = this.inputFile.listFiles();
        try {
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    this.dexFileNameList.add(file.getName());
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.dexFileList.add(randomAccessFile);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TaskInitException(e.getMessage(), e);
        }
        if (this.params.containsKey("--group")) {
            if ("package".equals(this.params.get("--group"))) {
                this.group = "package";
            } else {
                Log.e(TAG, "GROUP-BY '" + (String)this.params.get("--group") + "' is not correct!", new Object[0]);
            }
        }
    }

    @Override
    public TaskResult call() throws TaskExecuteException {
        try {
            TaskResult taskResult = TaskResultFactory.factory(this.type, "json", this.config);
            long startTime = System.currentTimeMillis();
            Map<String, String> classProguardMap = this.config.getProguardClassMap();
            JsonArray dexFiles = new JsonArray();
            for (int i = 0; i < this.dexFileList.size(); ++i) {
                RandomAccessFile dexFile = this.dexFileList.get(i);
                DexData dexData = new DexData(dexFile);
                dexData.load();
                dexFile.close();
                ClassRef[] defClassRefs = dexData.getInternalReferences();
                HashSet<String> classNameSet = new HashSet<String>();
                for (ClassRef classRef : defClassRefs) {
                    String className = ApkUtil.getNormalClassName(classRef.getName());
                    if (classProguardMap.containsKey(className)) {
                        className = classProguardMap.get(className);
                    }
                    if (className.indexOf(46) == -1) continue;
                    classNameSet.add(className);
                }
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("dex-file", this.dexFileNameList.get(i));
                Log.d(TAG, "dex %s, classes %s", this.dexFileNameList.get(i), ((Object)classNameSet).toString());
                HashMap packageClass = new HashMap();
                if ("package".equals(this.group)) {
                    String packageName = "";
                    for (String clazzName : classNameSet) {
                        packageName = ApkUtil.getPackageName(clazzName);
                        if (Util.isNullOrNil(packageName)) continue;
                        if (!packageClass.containsKey(packageName)) {
                            packageClass.put(packageName, new HashSet());
                        }
                        ((Set)packageClass.get(packageName)).add(clazzName);
                    }
                    JsonArray jsonArray = new JsonArray();
                    for (Map.Entry pkg : packageClass.entrySet()) {
                        JsonObject pkgObj = new JsonObject();
                        pkgObj.addProperty("package", (String)pkg.getKey());
                        JsonArray classArray = new JsonArray();
                        for (String clazz : (Set)pkg.getValue()) {
                            classArray.add(clazz);
                        }
                        pkgObj.add("classes", classArray);
                        jsonArray.add(pkgObj);
                    }
                    jsonObject.add("packages", jsonArray);
                }
                dexFiles.add(jsonObject);
            }
            ((TaskJsonResult)taskResult).add("dex-files", dexFiles);
            taskResult.setStartTime(startTime);
            taskResult.setEndTime(System.currentTimeMillis());
            return taskResult;
        }
        catch (Exception e) {
            throw new TaskExecuteException(e.getMessage(), e);
        }
    }

    @Override
    public int getType() {
        return super.getType();
    }
}

