/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.task;

import com.tencent.matrix.apk.model.exception.TaskExecuteException;
import com.tencent.matrix.apk.model.exception.TaskInitException;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class ApkTask
implements Callable<TaskResult> {
    private static final String TAG = "Matrix.ApkTask";
    protected int type;
    protected JobConfig config;
    protected Map<String, String> params;
    protected List<ApkTaskProgressListener> progressListeners;

    public ApkTask(JobConfig config, Map<String, String> params) {
        this.params = params;
        this.config = config;
        this.progressListeners = new LinkedList<ApkTaskProgressListener>();
    }

    public int getType() {
        return this.type;
    }

    public void init() throws TaskInitException {
        if (this.config == null) {
            throw new TaskInitException("Matrix.ApkTask---jobConfig can not be null!");
        }
        if (this.params == null) {
            throw new TaskInitException("Matrix.ApkTask---params can not be null!");
        }
    }

    public void addProgressListener(ApkTaskProgressListener listener) {
        if (listener != null) {
            this.progressListeners.add(listener);
        }
    }

    public void removeProgressListener(ApkTaskProgressListener listener) {
        if (listener != null) {
            this.progressListeners.remove(listener);
        }
    }

    protected void notifyProgress(int progress, String message) {
        for (ApkTaskProgressListener listener : this.progressListeners) {
            listener.getProgress(progress, message);
        }
    }

    @Override
    public abstract TaskResult call() throws TaskExecuteException;

    public static interface ApkTaskProgressListener {
        public void getProgress(int var1, String var2);
    }
}

