/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.result.TaskHtmlResult;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.task.TaskFactory;
import com.tencent.matrix.javalib.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;

public final class TaskResultFactory {
    private static final String TAG = "Matrix.TaskResultFactory";
    public static final String TASK_RESULT_TYPE_JSON = "json";
    public static final String TASK_RESULT_TYPE_HTML = "html";
    private static Map<String, Class<? extends TaskHtmlResult>> customHtmlResultMap = new HashMap<String, Class<? extends TaskHtmlResult>>();
    private static Map<String, Class<? extends TaskJsonResult>> customJsonResultMap = new HashMap<String, Class<? extends TaskJsonResult>>();

    public static TaskResult factory(int taskType, String resultType, JobConfig config) throws ParserConfigurationException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor<TaskResult> constructor;
        Class<TaskResult> class1;
        TaskResult result = null;
        JsonObject taskConfig = null;
        JsonArray taskConfigs = config.getOutputConfig();
        if (taskConfigs != null) {
            for (JsonElement element : taskConfigs) {
                JsonObject obj = element.getAsJsonObject();
                if (!obj.get("name").getAsString().equals(TaskFactory.TaskOptionName.get(taskType))) continue;
                taskConfig = obj;
                break;
            }
        }
        if (TASK_RESULT_TYPE_JSON.equals(resultType)) {
            result = new TaskJsonResult(taskType, taskConfig);
        } else if (TASK_RESULT_TYPE_HTML.equals(resultType)) {
            result = new TaskHtmlResult(taskType, taskConfig);
        } else if (customHtmlResultMap.containsKey(resultType)) {
            class1 = customHtmlResultMap.get(resultType);
            constructor = class1.getDeclaredConstructor(Integer.TYPE, JsonObject.class);
            result = constructor.newInstance(taskType, taskConfig);
        } else if (customJsonResultMap.containsKey(resultType)) {
            class1 = customJsonResultMap.get(resultType);
            constructor = class1.getDeclaredConstructor(Integer.TYPE, JsonObject.class);
            result = (TaskJsonResult)constructor.newInstance(taskType, taskConfig);
        } else {
            result = new TaskHtmlResult(taskType, taskConfig);
        }
        return result;
    }

    public static TaskResult transferTaskResult(int taskType, TaskResult source, String destResultType, JobConfig config) {
        TaskResult result = null;
        try {
            if (source instanceof TaskJsonResult) {
                if (customHtmlResultMap.containsKey(destResultType) || destResultType.equals(TASK_RESULT_TYPE_HTML)) {
                    result = TaskResultFactory.factory(taskType, destResultType, config);
                    TaskResultFactory.transferJsonToHtml((TaskJsonResult)source, (TaskHtmlResult)result);
                } else if (customJsonResultMap.containsKey(destResultType)) {
                    result = TaskResultFactory.factory(taskType, destResultType, config);
                    TaskResultFactory.formatJson((TaskJsonResult)source, (TaskJsonResult)result);
                } else {
                    result = source;
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException e) {
            Log.e(TAG, "transfer task result failed! " + e.getMessage(), new Object[0]);
            result = null;
        }
        return result;
    }

    private static void transferJsonToHtml(TaskJsonResult source, TaskHtmlResult dest) throws ParserConfigurationException {
        JsonObject jsonObject = (JsonObject)new JsonParser().parse(source.toString());
        dest.format(jsonObject);
    }

    private static void formatJson(TaskJsonResult source, TaskJsonResult dest) {
        dest.format(source.jsonObject);
    }

    public static void addCustomTaskHtmlResult(Map<String, Class<? extends TaskHtmlResult>> customTaskHtmlResult) {
        customHtmlResultMap.putAll(customTaskHtmlResult);
    }

    public static void addCustomTaskJsonResult(Map<String, Class<? extends TaskJsonResult>> customTaskJsonResult) {
        customJsonResultMap.putAll(customTaskJsonResult);
    }

    public static boolean isJsonResult(String resultType) {
        if (resultType.equals(TASK_RESULT_TYPE_JSON)) {
            return true;
        }
        return customJsonResultMap.containsKey(resultType);
    }

    public static boolean isHtmlResult(String resultType) {
        if (resultType.equals(TASK_RESULT_TYPE_HTML)) {
            return true;
        }
        return customHtmlResultMap.containsKey(resultType);
    }
}

