/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class TaskResult {
    private final SimpleDateFormat dateFormat;
    protected String startTime;
    protected String endTime;
    public final int taskType;

    public TaskResult(int taskType) {
        this.taskType = taskType;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    }

    public void setStartTime(long startTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(startTime);
        this.startTime = this.dateFormat.format(calendar.getTime());
    }

    public void setEndTime(long endTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(endTime);
        this.endTime = this.dateFormat.format(calendar.getTime());
    }

    public abstract Object getResult();
}

