/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.task.TaskFactory;
import com.tencent.matrix.javalib.util.Util;
import javax.xml.parsers.ParserConfigurationException;

public class TaskJsonResult
extends TaskResult {
    protected final JsonObject jsonObject;
    protected final JsonObject config;

    public TaskJsonResult(int taskType, JsonObject config) throws ParserConfigurationException {
        super(taskType);
        this.config = config;
        this.jsonObject = new JsonObject();
        this.jsonObject.addProperty("taskType", taskType);
        this.jsonObject.addProperty("taskDescription", TaskFactory.TaskDescription.get(taskType));
    }

    public void add(String name, String value) {
        if (!Util.isNullOrNil(name)) {
            this.jsonObject.addProperty(name, value);
        }
    }

    public void add(String name, boolean value) {
        if (!Util.isNullOrNil(name)) {
            this.jsonObject.addProperty(name, value);
        }
    }

    public void add(String name, Number value) {
        if (!Util.isNullOrNil(name)) {
            this.jsonObject.addProperty(name, value);
        }
    }

    public void add(String name, JsonElement jsonElement) {
        if (!Util.isNullOrNil(name)) {
            this.jsonObject.add(name, jsonElement);
        }
    }

    @Override
    public void setStartTime(long startTime) {
        super.setStartTime(startTime);
        this.jsonObject.addProperty("start-time", this.startTime);
    }

    @Override
    public void setEndTime(long endTime) {
        super.setEndTime(endTime);
        this.jsonObject.addProperty("end-time", this.endTime);
    }

    public void format(JsonObject jsonObject) {
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public JsonObject getResult() {
        return this.jsonObject;
    }
}

