/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.result.TaskResult;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TaskHtmlResult
extends TaskResult {
    private static final String TAG = "Matrix.TaskHtmlResult";
    protected final Document document;
    protected JsonObject config;

    public TaskHtmlResult(int taskType, JsonObject config) throws ParserConfigurationException {
        super(taskType);
        this.config = config;
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = documentBuilder.newDocument();
    }

    private void add(Element root) {
        this.document.appendChild(root);
    }

    public void format(JsonObject jsonObject) throws ParserConfigurationException {
        this.add(this.toElement(this.document, jsonObject));
    }

    private Element toElement(Document document, JsonElement jsonElement) throws ParserConfigurationException {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            Element value = document.createElement("span");
            value.setTextContent(jsonElement.getAsString());
            return value;
        }
        if (jsonElement.isJsonObject()) {
            Element table = document.createElement("table");
            table.setAttribute("border", "1");
            table.setAttribute("width", "100%");
            for (Map.Entry<String, JsonElement> entry : ((JsonObject)jsonElement).entrySet()) {
                Element value;
                Element name;
                Element tr;
                JsonElement jsonValue = entry.getValue();
                if (jsonValue.isJsonPrimitive()) {
                    tr = document.createElement("tr");
                    name = document.createElement("td");
                    name.setAttribute("valign", "top");
                    name.setAttribute("width", "30%");
                    name.setTextContent(entry.getKey());
                    value = document.createElement("td");
                    value.setTextContent(jsonValue.getAsString());
                    tr.appendChild(name);
                    tr.appendChild(value);
                    table.appendChild(tr);
                    continue;
                }
                if (jsonValue.isJsonObject()) {
                    tr = document.createElement("tr");
                    name = document.createElement("td");
                    name.setAttribute("valign", "top");
                    name.setAttribute("width", "30%");
                    name.setTextContent(entry.getKey());
                    value = document.createElement("td");
                    value.appendChild(this.toElement(document, jsonValue));
                    tr.appendChild(name);
                    tr.appendChild(value);
                    table.appendChild(tr);
                    continue;
                }
                if (!jsonValue.isJsonArray()) continue;
                tr = document.createElement("tr");
                name = document.createElement("td");
                name.setAttribute("valign", "top");
                name.setAttribute("width", "30%");
                name.setTextContent(entry.getKey());
                value = document.createElement("td");
                JsonArray array = (JsonArray)jsonValue;
                Element ul = document.createElement("ul");
                ul.setAttribute("style", "list-style-type:none");
                value.appendChild(ul);
                for (int i = 0; i < array.size(); ++i) {
                    Element li = document.createElement("li");
                    li.appendChild(this.toElement(document, array.get(i)));
                    ul.appendChild(li);
                }
                tr.appendChild(name);
                tr.appendChild(value);
                table.appendChild(tr);
            }
            return table;
        }
        return null;
    }

    public String toString() {
        return this.document.toString();
    }

    @Override
    public Document getResult() {
        return this.document;
    }
}

