/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.result.JobResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultComparator;
import com.tencent.matrix.javalib.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class JobJsonResult
extends JobResult {
    private static final String TAG = "JobJsonResult";
    private final File outputFile;
    private int elementCount;

    public JobJsonResult(String format, String outputPath) {
        this.format = format;
        this.outputFile = new File(outputPath + "." + "json");
        this.resultList = new ArrayList();
    }

    private void writeJsonArrayStart() throws IOException {
        try (PrintWriter printWriter = null;){
            if (this.outputFile.exists() && !this.outputFile.delete()) {
                Log.e(TAG, "file " + this.outputFile.getName() + " is already exists and delete it failed!", new Object[0]);
                return;
            }
            if (!this.outputFile.createNewFile()) {
                Log.e(TAG, "create output file " + this.outputFile.getName() + " failed!", new Object[0]);
                return;
            }
            printWriter = new PrintWriter(this.outputFile, "UTF-8");
            printWriter.append("[");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJsonElement(JsonElement jsonElement) {
        if (jsonElement != null) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                try (OutputStreamWriter writer = null;){
                    writer = new FileWriter(this.outputFile, true);
                    if (this.elementCount > 0) {
                        writer.append(",\n" + gson.toJson(jsonElement));
                    } else {
                        writer.append(gson.toJson(jsonElement));
                    }
                    ++this.elementCount;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeJsonArrayEnd() {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(this.outputFile, true);
            writer.append("]");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void output() {
        try {
            this.writeJsonArrayStart();
            if (!this.resultList.isEmpty()) {
                Collections.sort(this.resultList, new TaskResultComparator());
                for (TaskResult taskResult : this.resultList) {
                    if (taskResult.getResult() == null || !(taskResult.getResult() instanceof JsonObject)) continue;
                    this.writeJsonElement((JsonObject)taskResult.getResult());
                }
            }
            this.writeJsonArrayEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

