/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.result;

import com.tencent.matrix.apk.model.result.JobResult;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultComparator;
import com.tencent.matrix.javalib.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class JobHtmlResult
extends JobResult {
    private static final String TAG = "JobHtmlResult";
    private final File outputFile;

    public JobHtmlResult(String format, String outputPath) {
        this.format = format;
        this.outputFile = new File(outputPath + "." + "html");
        this.resultList = new ArrayList();
    }

    private void writeHtmlStart() throws IOException {
        try (PrintWriter printWriter = null;){
            if (this.outputFile.exists() && !this.outputFile.delete()) {
                Log.e(TAG, "file " + this.outputFile.getName() + " is already exists and delete it failed!", new Object[0]);
                return;
            }
            if (!this.outputFile.createNewFile()) {
                Log.e(TAG, "create output file " + this.outputFile.getName() + " failed!", new Object[0]);
                return;
            }
            printWriter = new PrintWriter(this.outputFile, "UTF-8");
            printWriter.append("<html>");
            printWriter.append("<body>");
        }
    }

    private void writeDocument(DOMSource domSource) throws Exception {
        Transformer transformer = null;
        transformer = TransformerFactory.newInstance().newTransformer();
        if (this.outputFile.isFile() && this.outputFile.exists()) {
            FileWriter writer = new FileWriter(this.outputFile, true);
            writer.append("<br/>");
            StreamResult result = new StreamResult(this.outputFile);
            result.setWriter(writer);
            transformer.transform(domSource, result);
        }
    }

    private void writeHtmlEnd() throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(this.outputFile, true);
            writer.append("</body>");
            writer.append("</html>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void output() {
        try {
            this.writeHtmlStart();
            if (!this.resultList.isEmpty()) {
                Collections.sort(this.resultList, new TaskResultComparator());
                for (TaskResult taskResult : this.resultList) {
                    if (taskResult.getResult() == null || !(taskResult.getResult() instanceof Document)) continue;
                    this.writeDocument(new DOMSource((Document)taskResult.getResult()));
                }
            }
            this.writeHtmlEnd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

