/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.output;

import com.android.utils.Pair;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.result.TaskJsonResult;
import com.tencent.matrix.javalib.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;

public class MMTaskJsonResult
extends TaskJsonResult {
    public MMTaskJsonResult(int type, JsonObject config) throws ParserConfigurationException {
        super(type, config);
    }

    @Override
    public void format(JsonObject jsonObject) {
        MMTaskJsonResult.formatJson(jsonObject, this.jsonObject, this.config);
    }

    public static void formatJson(JsonObject jsonObjectInput, JsonObject jsonObjectOutput, JsonObject config) {
        int taskType = jsonObjectInput.get("taskType").getAsInt();
        switch (taskType) {
            case 1: {
                MMTaskJsonResult.formatUnzipTask(jsonObjectInput);
                break;
            }
            case 2: {
                MMTaskJsonResult.formatManifestAnalyzeTask(jsonObjectInput);
                break;
            }
            case 4: {
                MMTaskJsonResult.formatMethodCountTask(jsonObjectInput, config);
                break;
            }
            case 9: {
                MMTaskJsonResult.formatCountR(jsonObjectInput);
                break;
            }
            case 15: {
                MMTaskJsonResult.formatCountClass(jsonObjectInput, config);
                break;
            }
        }
        if (jsonObjectOutput != null) {
            for (Map.Entry<String, JsonElement> entry : jsonObjectInput.entrySet()) {
                if (jsonObjectOutput.has(entry.getKey())) continue;
                jsonObjectOutput.add(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void formatCountR(JsonObject jsonObject) {
        JsonArray files = jsonObject.getAsJsonArray("R-classes");
        final HashMap<String, Integer> rMaps = new HashMap<String, Integer>();
        for (JsonElement file : files) {
            JsonObject object = (JsonObject)file;
            rMaps.put(object.get("name").getAsString(), object.get("field-count").getAsInt());
        }
        ArrayList keys = new ArrayList(rMaps.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                int pair2;
                int pair1 = (Integer)rMaps.get(left);
                if (pair1 > (pair2 = ((Integer)rMaps.get(right)).intValue())) {
                    return -1;
                }
                if (pair1 < pair2) {
                    return 1;
                }
                return 0;
            }
        });
        jsonObject.remove("R-classes");
        JsonArray groupArray = new JsonArray();
        for (String name : keys) {
            JsonObject groupObj = new JsonObject();
            groupObj.addProperty("name", name);
            groupObj.addProperty("field-count", (Number)rMaps.get(name));
            groupArray.add(groupObj);
        }
        jsonObject.add("R-classes", groupArray);
    }

    private static void formatUnzipTask(JsonObject jsonObject) {
        HashMap<String, Long> fileGroupMap = new HashMap<String, Long>();
        HashMap<String, JsonArray> fileListGroup = new HashMap<String, JsonArray>();
        long otherFilesSize = 0L;
        JsonArray otherFiles = new JsonArray();
        JsonArray files = jsonObject.getAsJsonArray("entries");
        for (Object file : files) {
            String string = ((JsonObject)file).get("entry-name").getAsString();
            if (Util.isNullOrNil(string)) continue;
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String suffix = string.substring(n, string.length());
                if (!fileGroupMap.containsKey(suffix)) {
                    fileGroupMap.put(suffix, ((JsonObject)file).get("entry-size").getAsLong());
                    JsonArray fileList = new JsonArray();
                    fileList.add((JsonElement)file);
                    fileListGroup.put(suffix, fileList);
                    continue;
                }
                fileGroupMap.put(suffix, (Long)fileGroupMap.get(suffix) + ((JsonObject)file).get("entry-size").getAsLong());
                ((JsonArray)fileListGroup.get(suffix)).add((JsonElement)file);
                continue;
            }
            otherFilesSize += ((JsonObject)file).get("entry-size").getAsLong();
            otherFiles.add((JsonElement)file);
        }
        ArrayList fileGroupList = new ArrayList();
        for (Map.Entry entry : fileGroupMap.entrySet()) {
            fileGroupList.add(Pair.of(entry.getKey(), entry.getValue()));
        }
        Collections.sort(fileGroupList, new Comparator<Pair<String, Long>>(){

            @Override
            public int compare(Pair<String, Long> pair1, Pair<String, Long> pair2) {
                if (pair1.getSecond() > pair2.getSecond()) {
                    return -1;
                }
                if (pair1.getSecond() < pair2.getSecond()) {
                    return 1;
                }
                return 0;
            }
        });
        JsonArray items = new JsonArray();
        for (Pair pair : fileGroupList) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("suffix", (String)pair.getFirst());
            jsonObj.addProperty("total-size", (Number)pair.getSecond());
            jsonObj.add("files", (JsonElement)fileListGroup.get(pair.getFirst()));
            items.add(jsonObj);
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.addProperty("suffix", "others");
        jsonObject2.addProperty("total-size", otherFilesSize);
        jsonObject2.add("files", otherFiles);
        jsonObject.remove("entries");
        jsonObject.add("entries", items);
    }

    private static void formatManifestAnalyzeTask(JsonObject jsonObject) {
        JsonObject application;
        JsonArray applications;
        JsonArray sdks;
        JsonObject manifest = jsonObject.getAsJsonObject("manifest");
        HashMap<String, String> attribute = new HashMap<String, String>();
        if (manifest.has("package")) {
            attribute.put("package", manifest.get("package").getAsString());
        }
        if (manifest.has("android:versionCode")) {
            attribute.put("android:versionCode", manifest.get("android:versionCode").getAsString());
        }
        if (manifest.has("android:versionName")) {
            attribute.put("android:versionName", manifest.get("android:versionName").getAsString());
        }
        if (manifest.has("uses-sdk") && (sdks = manifest.getAsJsonArray("uses-sdk")).size() > 0) {
            JsonObject sdk = sdks.get(0).getAsJsonObject();
            if (sdk.has("android:minSdkVersion")) {
                attribute.put("android:minSdkVersion", sdk.get("android:minSdkVersion").getAsString());
            }
            if (sdk.has("android:targetSdkVersion")) {
                attribute.put("android:targetSdkVersion", sdk.get("android:targetSdkVersion").getAsString());
            }
        }
        if (manifest.has("application") && (applications = manifest.getAsJsonArray("application")).size() > 0 && (application = applications.get(0).getAsJsonObject()).has("meta-data")) {
            JsonArray metaDatas = application.getAsJsonArray("meta-data");
            for (JsonElement metaData : metaDatas) {
                JsonObject obj = metaData.getAsJsonObject();
                if (!obj.has("android:name") || !obj.has("android:value")) continue;
                String name = obj.get("android:name").getAsString();
                String value = obj.get("android:value").getAsString();
                if ("com.tencent.mm.BuildInfo.CLIENT_VERSION".equals(name)) {
                    attribute.put("CLIENT_VERSION", value);
                    continue;
                }
                if ("com.tencent.mm.BuildInfo.BUILD_TAG".equals(name)) {
                    attribute.put("BUILD_TAG", value);
                    continue;
                }
                if ("com.tencent.mm.BuildInfo.BUILD_SVNPATH".equals(name)) {
                    attribute.put("BUILD_SVNPATH", value);
                    continue;
                }
                if (!"com.tencent.mm.BuildInfo.BUILD_REV".equals(name)) continue;
                attribute.put("BUILD_REV", value);
            }
        }
        jsonObject.remove("manifest");
        JsonObject jsonObj = new JsonObject();
        for (String key : attribute.keySet()) {
            jsonObj.addProperty(key, (String)attribute.get(key));
        }
        jsonObject.add("manifest", jsonObj);
    }

    private static void formatMethodCountTask(JsonObject jsonObject, JsonObject config) {
        Object groupObj;
        JsonArray groups = null;
        if (config != null) {
            groups = config.getAsJsonArray("group");
        }
        HashMap<String, Integer> defMethodMap = new HashMap<String, Integer>();
        HashMap<String, Integer> refMethodMap = new HashMap<String, Integer>();
        JsonArray dexFiles = jsonObject.getAsJsonArray("dex-files");
        for (JsonElement entry : dexFiles) {
            Object group2;
            JsonObject dexFile = entry.getAsJsonObject();
            JsonArray defGroups = null;
            if (dexFile.has("internal-packages")) {
                defGroups = dexFile.getAsJsonArray("internal-packages");
            } else if (dexFile.has("internal-classes")) {
                defGroups = dexFile.getAsJsonArray("internal-classes");
            }
            if (defGroups != null) {
                for (Object group2 : defGroups) {
                    JsonObject groupObj2 = ((JsonElement)group2).getAsJsonObject();
                    String name = groupObj2.get("name").getAsString();
                    defMethodMap.put(name, groupObj2.get("methods").getAsInt());
                    if (refMethodMap.containsKey(name)) continue;
                    refMethodMap.put(name, 0);
                }
            }
            JsonArray refGroups = null;
            if (dexFile.has("external-packages")) {
                refGroups = dexFile.getAsJsonArray("external-packages");
            } else if (dexFile.has("external-classes")) {
                refGroups = dexFile.getAsJsonArray("external-classes");
            }
            if (refGroups == null) continue;
            group2 = refGroups.iterator();
            while (group2.hasNext()) {
                JsonElement group3 = (JsonElement)group2.next();
                groupObj = group3.getAsJsonObject();
                String name = ((JsonObject)groupObj).get("name").getAsString();
                if (!refMethodMap.containsKey(name)) {
                    refMethodMap.put(name, ((JsonObject)groupObj).get("methods").getAsInt());
                } else {
                    refMethodMap.put(name, (Integer)refMethodMap.get(name) + ((JsonObject)groupObj).get("methods").getAsInt());
                }
                if (defMethodMap.containsKey(name)) continue;
                defMethodMap.put(name, 0);
            }
        }
        final HashMap groupMap = new HashMap();
        if (groups != null) {
            int nextIndex;
            int index;
            String groupName;
            String groupValue;
            HashMap groupPattern = new HashMap();
            for (JsonElement group : groups) {
                Iterator obj = group.getAsJsonObject();
                groupPattern.put(((JsonObject)((Object)obj)).get("name").getAsString(), ((JsonObject)((Object)obj)).get("package").getAsString());
            }
            HashMap<String, Integer> groupDefMap = new HashMap<String, Integer>();
            HashMap<String, Integer> groupRefMap = new HashMap<String, Integer>();
            groupDefMap.put("[others]", 0);
            groupRefMap.put("[others]", 0);
            for (String pkg : defMethodMap.keySet()) {
                boolean other = true;
                for (String key : groupPattern.keySet()) {
                    groupValue = (String)groupPattern.get(key);
                    groupName = key;
                    index = groupValue.indexOf(36);
                    if (index >= 0) {
                        groupValue = groupValue.substring(0, index);
                    }
                    if (!pkg.startsWith(groupValue)) continue;
                    if (index >= 0) {
                        groupName = pkg.substring(index);
                        nextIndex = groupName.indexOf(46);
                        if (nextIndex >= 0) {
                            groupName = groupName.substring(0, nextIndex);
                        }
                        groupName = key.replace("$", groupName);
                    }
                    if (!groupDefMap.containsKey(groupName)) {
                        groupDefMap.put(groupName, (Integer)defMethodMap.get(pkg));
                    } else {
                        groupDefMap.put(groupName, (Integer)groupDefMap.get(groupName) + (Integer)defMethodMap.get(pkg));
                    }
                    other = false;
                }
                if (!other) continue;
                groupDefMap.put("[others]", (Integer)groupDefMap.get("[others]") + (Integer)defMethodMap.get(pkg));
            }
            for (String pkg : refMethodMap.keySet()) {
                boolean other = true;
                for (String key : groupPattern.keySet()) {
                    groupValue = (String)groupPattern.get(key);
                    groupName = key;
                    index = groupValue.indexOf(36);
                    if (index >= 0) {
                        groupValue = groupValue.substring(0, index);
                    }
                    if (!pkg.startsWith(groupValue)) continue;
                    if (index >= 0) {
                        groupName = pkg.substring(index);
                        nextIndex = groupName.indexOf(46);
                        if (nextIndex >= 0) {
                            groupName = groupName.substring(0, nextIndex);
                        }
                        groupName = key.replace("$", groupName);
                    }
                    if (!groupRefMap.containsKey(groupName)) {
                        groupRefMap.put(groupName, (Integer)refMethodMap.get(pkg));
                    } else {
                        groupRefMap.put(groupName, (Integer)groupRefMap.get(groupName) + (Integer)refMethodMap.get(pkg));
                    }
                    other = false;
                }
                if (!other) continue;
                groupRefMap.put("[others]", (Integer)groupRefMap.get("[others]") + (Integer)refMethodMap.get(pkg));
            }
            for (String pkg : groupDefMap.keySet()) {
                groupMap.put(pkg, Pair.of(groupDefMap.get(pkg), groupRefMap.get(pkg)));
            }
        } else {
            for (String pkg : defMethodMap.keySet()) {
                groupMap.put(pkg, Pair.of(defMethodMap.get(pkg), refMethodMap.get(pkg)));
            }
        }
        ArrayList keys = new ArrayList(groupMap.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                int total2;
                Pair pair1 = (Pair)groupMap.get(left);
                Pair pair2 = (Pair)groupMap.get(right);
                int total1 = (Integer)pair1.getFirst() + (Integer)pair1.getSecond();
                if (total1 > (total2 = (Integer)pair2.getFirst() + (Integer)pair2.getSecond())) {
                    return -1;
                }
                if (total1 < total2) {
                    return 1;
                }
                return 0;
            }
        });
        jsonObject.remove("dex-files");
        long totalMethods = 0L;
        JsonArray groupArray = new JsonArray();
        for (String group : keys) {
            groupObj = new JsonObject();
            ((JsonObject)groupObj).addProperty("name", group);
            Pair pair = (Pair)groupMap.get(group);
            totalMethods += (long)((Integer)pair.getFirst() + (Integer)pair.getSecond());
            ((JsonObject)groupObj).addProperty("method-count", (Integer)pair.getFirst() + (Integer)pair.getSecond());
            groupArray.add((JsonElement)groupObj);
        }
        jsonObject.addProperty("total-methods", totalMethods);
        jsonObject.add("groups", groupArray);
    }

    private static void formatUnusedResourcesTask(JsonObject jsonObject) {
        JsonArray resources = jsonObject.getAsJsonArray("unused-resources");
        HashMap group = new HashMap();
        jsonObject.addProperty("total-count", resources.size());
        for (JsonElement jsonElement : resources) {
            String res = jsonElement.getAsString();
            String type = res.substring(0, res.indexOf(46, 2));
            if (!group.containsKey(type)) {
                group.put(type, new ArrayList());
            }
            ((List)group.get(type)).add(res);
        }
        jsonObject.remove("unused-resources");
        for (Map.Entry entry : group.entrySet()) {
            JsonArray list = new JsonArray();
            for (String res : (List)entry.getValue()) {
                list.add(res);
            }
            jsonObject.add((String)entry.getKey(), list);
        }
    }

    private static void formatCountClass(JsonObject jsonObject, JsonObject config) {
        JsonArray groups = null;
        if (config != null) {
            groups = config.getAsJsonArray("group");
        }
        JsonArray dexFiles = jsonObject.getAsJsonArray("dex-files");
        HashMap pkgMap = new HashMap();
        for (JsonElement entry : dexFiles) {
            Iterator dexFile = entry.getAsJsonObject();
            JsonArray pkgs = ((JsonObject)((Object)dexFile)).get("packages").getAsJsonArray();
            for (JsonElement pkg : pkgs) {
                JsonObject pkgObj = pkg.getAsJsonObject();
                String pkgName = pkgObj.get("package").getAsString();
                if (!pkgMap.containsKey(pkgName)) {
                    pkgMap.put(pkgName, new HashSet());
                }
                JsonArray classes = pkgObj.getAsJsonArray("classes");
                for (JsonElement clazz : classes) {
                    ((Set)pkgMap.get(pkgName)).add(clazz.getAsString());
                }
            }
        }
        final HashMap<String, Integer> groupDefMap = new HashMap<String, Integer>();
        if (groups != null) {
            HashMap groupPattern = new HashMap();
            for (JsonElement group : groups) {
                JsonObject obj = group.getAsJsonObject();
                groupPattern.put(obj.get("name").getAsString(), obj.get("package").getAsString());
            }
            groupDefMap.put("[others]", 0);
            for (String pkg : pkgMap.keySet()) {
                boolean other = true;
                for (String key : groupPattern.keySet()) {
                    String groupValue = (String)groupPattern.get(key);
                    String groupName = key;
                    int index = groupValue.indexOf(36);
                    if (index >= 0) {
                        groupValue = groupValue.substring(0, index);
                    }
                    if (!pkg.startsWith(groupValue)) continue;
                    if (index >= 0) {
                        groupName = pkg.substring(index);
                        int nextIndex = groupName.indexOf(46);
                        if (nextIndex >= 0) {
                            groupName = groupName.substring(0, nextIndex);
                        }
                        groupName = key.replace("$", groupName);
                    }
                    if (!groupDefMap.containsKey(groupName)) {
                        groupDefMap.put(groupName, ((Set)pkgMap.get(pkg)).size());
                    } else {
                        groupDefMap.put(groupName, (Integer)groupDefMap.get(groupName) + ((Set)pkgMap.get(pkg)).size());
                    }
                    other = false;
                }
                if (!other) continue;
                groupDefMap.put("[others]", (Integer)groupDefMap.get("[others]") + ((Set)pkgMap.get(pkg)).size());
            }
        } else {
            for (String pkg : pkgMap.keySet()) {
                groupDefMap.put(pkg, ((Set)pkgMap.get(pkg)).size());
            }
        }
        ArrayList keys = new ArrayList(groupDefMap.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                int total2;
                int total1 = (Integer)groupDefMap.get(left);
                if (total1 > (total2 = ((Integer)groupDefMap.get(right)).intValue())) {
                    return -1;
                }
                if (total1 < total2) {
                    return 1;
                }
                return 0;
            }
        });
        jsonObject.remove("dex-files");
        long totalClasses = 0L;
        JsonArray groupArray = new JsonArray();
        for (String group : keys) {
            JsonObject groupObj = new JsonObject();
            groupObj.addProperty("name", group);
            totalClasses += (long)((Integer)groupDefMap.get(group)).intValue();
            groupObj.addProperty("class-count", (Number)groupDefMap.get(group));
            groupArray.add(groupObj);
        }
        jsonObject.addProperty("total-classes", totalClasses);
        jsonObject.add("groups", groupArray);
    }
}

