/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.output;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tencent.matrix.apk.model.output.MMTaskJsonResult;
import com.tencent.matrix.apk.model.result.TaskHtmlResult;
import com.tencent.matrix.javalib.util.Util;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class MMTaskHtmlResult
extends TaskHtmlResult {
    private static final int MAX_SHOW_ITEMS = 10;
    private static final String FOLDER_STYLE = "color:white;font-size:20px;background-color:#C0C0C0";
    private static final String FOLDER_ONCLICK = "root = this.parentNode.parentNode; next = root.nextSibling; while (next != null) { if (next.hasAttribute('hidden')) { next.removeAttribute('hidden');} else { break; } next = next.nextSibling; } root.parentNode.removeChild(root)";

    public MMTaskHtmlResult(int type, JsonObject config) throws ParserConfigurationException {
        super(type, config);
    }

    @Override
    public void format(JsonObject jsonObject) throws ParserConfigurationException {
        MMTaskJsonResult.formatJson(jsonObject, null, this.config);
        int taskType = jsonObject.get("taskType").getAsInt();
        switch (taskType) {
            case 1: {
                Element element = this.formatUnzipTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            case 2: {
                Element element = this.formatManifestAnalyzeTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            case 3: {
                Element element = this.formatShowFileSizeTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            case 4: {
                Element element = this.formatMethodCountTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            case 6: {
                Element element = this.formatFindNonAlphaPngTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            case 8: {
                Element element = this.formatUncompressedFileTask(jsonObject);
                this.foldElement(element);
                this.document.appendChild(element);
                break;
            }
            default: {
                jsonObject.remove("taskType");
                jsonObject.remove("start-time");
                jsonObject.remove("end-time");
                super.format(jsonObject);
                this.foldElement((Element)this.document.getFirstChild());
            }
        }
    }

    private void foldElement(Element element) {
        if (element != null && element.getChildNodes().getLength() > 10) {
            for (int i = 10; i < element.getChildNodes().getLength(); ++i) {
                if (!(element.getChildNodes().item(i) instanceof Element)) continue;
                ((Element)element.getChildNodes().item(i)).setAttribute("hidden", "true");
            }
            Element span = this.document.createElement("span");
            span.setAttribute("style", FOLDER_STYLE);
            span.setAttribute("onClick", FOLDER_ONCLICK);
            span.setTextContent("...");
            Element folder = null;
            if (element.getTagName().equals("table")) {
                folder = this.document.createElement("tr");
                Element td = this.document.createElement("td");
                td.setAttribute("colspan", "100%");
                folder.appendChild(td);
                td.appendChild(span);
            } else if (element.getTagName().equals("ul")) {
                folder = this.document.createElement("li");
                Element parent = this.document.createElement("span");
                parent.appendChild(span);
                folder.appendChild(parent);
            }
            if (folder != null) {
                element.insertBefore(folder, element.getChildNodes().item(10));
            }
        }
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            if (!(element.getChildNodes().item(i) instanceof Element)) continue;
            this.foldElement((Element)element.getChildNodes().item(i));
        }
    }

    private Element formatUnzipTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        tr = this.document.createElement("tr");
        td1 = this.document.createElement("td");
        td1.setTextContent("total-size");
        td2 = this.document.createElement("td");
        td2.setTextContent(Util.formatByteUnit(jsonObject.get("total-size").getAsLong()));
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        JsonArray files = jsonObject.getAsJsonArray("entries");
        for (JsonElement file : files) {
            String suffix = ((JsonObject)file).get("suffix").getAsString();
            long size = ((JsonObject)file).get("total-size").getAsLong();
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(suffix);
            Element td22 = this.document.createElement("td");
            td22.setTextContent(Util.formatByteUnit(size));
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        return table;
    }

    private Element formatManifestAnalyzeTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        JsonObject manifest = jsonObject.getAsJsonObject("manifest");
        for (Map.Entry<String, JsonElement> entry : manifest.entrySet()) {
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(entry.getKey());
            Element td22 = this.document.createElement("td");
            td22.setTextContent(entry.getValue().getAsString());
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        return table;
    }

    private Element formatShowFileSizeTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        JsonArray files = jsonObject.getAsJsonArray("files");
        for (JsonElement file : files) {
            String filename = ((JsonObject)file).get("entry-name").getAsString();
            if (Util.isNullOrNil(filename)) continue;
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(filename);
            Element td22 = this.document.createElement("td");
            td22.setTextContent(Util.formatByteUnit(((JsonObject)file).get("entry-size").getAsLong()));
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        return table;
    }

    private Element formatMethodCountTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        JsonArray groups = jsonObject.getAsJsonArray("groups");
        for (JsonElement entry : groups) {
            JsonObject object = (JsonObject)entry;
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(object.get("name").getAsString());
            Element td22 = this.document.createElement("td");
            td22.setTextContent(object.get("method-count").getAsString());
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        Element tr3 = this.document.createElement("tr");
        Element td13 = this.document.createElement("td");
        td13.setTextContent("total-methods");
        Element td23 = this.document.createElement("td");
        td23.setTextContent(jsonObject.get("total-methods").getAsString() + " methods");
        tr3.appendChild(td13);
        tr3.appendChild(td23);
        table.appendChild(tr3);
        return table;
    }

    private Element formatFindNonAlphaPngTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        long totalSize = 0L;
        JsonArray files = jsonObject.getAsJsonArray("files");
        for (JsonElement file : files) {
            String filename = ((JsonObject)file).get("entry-name").getAsString();
            if (Util.isNullOrNil(filename)) continue;
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(filename);
            Element td22 = this.document.createElement("td");
            totalSize += ((JsonObject)file).get("entry-size").getAsLong();
            td22.setTextContent(Util.formatByteUnit(((JsonObject)file).get("entry-size").getAsLong()));
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        Element tr3 = this.document.createElement("tr");
        Element td13 = this.document.createElement("td");
        td13.setTextContent("total-size");
        Element td23 = this.document.createElement("td");
        td23.setTextContent(Util.formatByteUnit(totalSize));
        tr3.appendChild(td13);
        tr3.appendChild(td23);
        table.appendChild(tr3);
        return table;
    }

    private Element formatUncompressedFileTask(JsonObject jsonObject) {
        Element table = this.document.createElement("table");
        table.setAttribute("border", "1");
        table.setAttribute("width", "100%");
        if (jsonObject == null) {
            return table;
        }
        Element tr = this.document.createElement("tr");
        Element td1 = this.document.createElement("td");
        td1.setTextContent("taskDescription");
        Element td2 = this.document.createElement("td");
        td2.setTextContent(jsonObject.get("taskDescription").getAsString());
        tr.appendChild(td1);
        tr.appendChild(td2);
        table.appendChild(tr);
        JsonArray entries = jsonObject.getAsJsonArray("files");
        for (JsonElement jsonElement : entries) {
            JsonObject jsonObj = jsonElement.getAsJsonObject();
            Element tr2 = this.document.createElement("tr");
            Element td12 = this.document.createElement("td");
            td12.setTextContent(jsonObj.get("suffix").getAsString());
            Element td22 = this.document.createElement("td");
            td22.setTextContent(Util.formatByteUnit(jsonObj.get("total-size").getAsLong()));
            tr2.appendChild(td12);
            tr2.appendChild(td22);
            table.appendChild(tr2);
        }
        return table;
    }
}

