/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.apk.model.job;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tencent.matrix.apk.ApkChecker;
import com.tencent.matrix.apk.model.job.JobConfig;
import com.tencent.matrix.apk.model.output.MMTaskResultRegistry;
import com.tencent.matrix.apk.model.result.JobResult;
import com.tencent.matrix.apk.model.result.JobResultFactory;
import com.tencent.matrix.apk.model.result.TaskResult;
import com.tencent.matrix.apk.model.result.TaskResultFactory;
import com.tencent.matrix.apk.model.result.TaskResultRegistry;
import com.tencent.matrix.apk.model.task.ApkTask;
import com.tencent.matrix.apk.model.task.TaskFactory;
import com.tencent.matrix.javalib.util.FileUtil;
import com.tencent.matrix.javalib.util.Log;
import com.tencent.matrix.javalib.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;

public final class ApkJob {
    private static final String TAG = "Matrix.ApkJob";
    private String[] args;
    private JobConfig jobConfig;
    private ExecutorService executor;
    private static final int TIMEOUT_SECONDS = 600;
    private int timeoutSeconds = 600;
    private static final int THREAD_NUM = 1;
    private int threadNum = 1;
    private List<ApkTask> preTasks;
    private List<ApkTask> taskList;
    private List<JobResult> jobResults;

    public ApkJob(String[] args) {
        this(args, 0, 0);
    }

    public ApkJob(String[] args, int timeoutSeconds, int threadNum) {
        this.args = args;
        this.jobConfig = new JobConfig();
        if (timeoutSeconds > 0) {
            this.timeoutSeconds = timeoutSeconds;
        }
        if (threadNum > 0) {
            this.threadNum = threadNum;
        }
        this.executor = Executors.newFixedThreadPool(this.threadNum);
        this.preTasks = new ArrayList<ApkTask>();
        this.taskList = new ArrayList<ApkTask>();
        this.jobResults = new ArrayList<JobResult>();
    }

    private int parseParams(int start, String[] params, Map<String, String> result) {
        int end = params.length;
        String key = "";
        for (int i = start; i < params.length; ++i) {
            if (params[i].startsWith("-")) {
                if (!params[i].startsWith("--")) {
                    end = i;
                    break;
                }
                key = params[i];
                continue;
            }
            result.put(key, params[i]);
        }
        return end - start;
    }

    private String getApkRawName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        int index = name.indexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    private ApkTask createTask(String name, Map<String, String> params) {
        ApkTask task = null;
        if ("-manifest".equals(name)) {
            task = TaskFactory.factory(2, this.jobConfig, params);
        } else if ("-fileSize".equals(name)) {
            task = TaskFactory.factory(3, this.jobConfig, params);
        } else if ("-countMethod".equals(name)) {
            task = TaskFactory.factory(4, this.jobConfig, params);
        } else if ("-checkResProguard".equals(name)) {
            task = TaskFactory.factory(5, this.jobConfig, params);
        } else if ("-findNonAlphaPng".equals(name)) {
            task = TaskFactory.factory(6, this.jobConfig, params);
        } else if ("-checkMultiLibrary".equals(name)) {
            task = TaskFactory.factory(7, this.jobConfig, params);
        } else if ("-uncompressedFile".equals(name)) {
            task = TaskFactory.factory(8, this.jobConfig, params);
        } else if ("-countR".equals(name)) {
            task = TaskFactory.factory(9, this.jobConfig, params);
        } else if ("-duplicatedFile".equals(name)) {
            task = TaskFactory.factory(10, this.jobConfig, params);
        } else if ("-checkMultiSTL".equals(name)) {
            task = TaskFactory.factory(11, this.jobConfig, params);
        } else if ("-unusedResources".equals(name)) {
            task = TaskFactory.factory(12, this.jobConfig, params);
        } else if ("-unusedAssets".equals(name)) {
            task = TaskFactory.factory(13, this.jobConfig, params);
        } else if ("-unstrippedSo".equals(name)) {
            task = TaskFactory.factory(14, this.jobConfig, params);
        } else if ("-countClass".equals(name)) {
            task = TaskFactory.factory(15, this.jobConfig, params);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String configPath) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        StringBuilder jsonStr = new StringBuilder();
        File configFile = new File(configPath);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));){
            String line = bufferedReader.readLine();
            while (line != null) {
                if (!Util.isNullOrNil(line.trim())) {
                    jsonStr.append(line.trim());
                }
                line = bufferedReader.readLine();
            }
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonStr.toString());
            if (jsonElement.isJsonObject()) {
                JsonArray outputConfig;
                File file;
                JarFile jarFile;
                Manifest manifest;
                Attributes registry;
                File inputDir;
                JsonObject config = (JsonObject)jsonElement;
                String value = "";
                if (config.has("--input") && !Util.isNullOrNil(value = config.get("--input").getAsString())) {
                    this.jobConfig.setInputDir(value);
                }
                value = "";
                if (config.has("--apk")) {
                    value = config.get("--apk").getAsString();
                } else if (!Util.isNullOrNil(this.jobConfig.getInputDir()) && (inputDir = new File(this.jobConfig.getInputDir())).isDirectory() && inputDir.exists()) {
                    for (File file2 : inputDir.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".apk")) continue;
                        value = file2.getAbsolutePath();
                        break;
                    }
                }
                if (!FileUtil.isLegalFile(value)) {
                    ApkChecker.printError("Input apk path '" + value + "' is illegal!");
                } else {
                    this.jobConfig.setApkPath(value);
                }
                File apkFile = new File(this.jobConfig.getApkPath());
                value = config.has("--unzip") && !Util.isNullOrNil(config.get("--unzip").getAsString()) ? config.get("--unzip").getAsString() : apkFile.getParentFile().getAbsolutePath() + File.separator + this.getApkRawName(apkFile.getName()) + "_unzip";
                this.jobConfig.setUnzipPath(value);
                value = config.has("--format") && !Util.isNullOrNil(config.get("--format").getAsString()) ? config.get("--format").getAsString() : "html";
                String[] formats = value.split(",");
                ArrayList<String> formatList = new ArrayList<String>();
                for (String format : formats) {
                    if (Util.isNullOrNil(format)) continue;
                    formatList.add(format.trim());
                }
                Log.i(TAG, "format list " + ((Object)formatList).toString(), new Object[0]);
                this.jobConfig.setOutputFormatList(formatList);
                value = config.has("--output") && !Util.isNullOrNil(config.get("--output").getAsString()) ? config.get("--output").getAsString() : apkFile.getParentFile().getAbsolutePath() + File.separator + this.getApkRawName(apkFile.getName());
                this.jobConfig.setOutputPath(value);
                if (config.has("--formatJar") && !Util.isNullOrNil(config.get("--formatJar").getAsString()) && (registry = (manifest = (jarFile = new JarFile(file = new File(value = config.get("--formatJar").getAsString()))).getManifest()).getAttributes("TaskResult-Registry")) != null) {
                    String registryClassPath = registry.getValue("TaskResult-Registry-Class");
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURL()});
                    Class<?> registryClass = classLoader.loadClass(registryClassPath);
                    TaskResultRegistry taskResultRegistry = (TaskResultRegistry)registryClass.newInstance();
                    TaskResultFactory.addCustomTaskJsonResult(taskResultRegistry.getJsonResult());
                    TaskResultFactory.addCustomTaskHtmlResult(taskResultRegistry.getHtmlResult());
                }
                if (config.has("--formatConfig") && (outputConfig = config.get("--formatConfig").getAsJsonArray()) != null) {
                    this.jobConfig.setOutputConfig(outputConfig);
                }
                if (config.has("--log")) {
                    Log.setLogLevel(config.get("--log").getAsString());
                }
                if (config.has("--mappingTxt") && !Util.isNullOrNil(config.get("--mappingTxt").getAsString())) {
                    this.jobConfig.setMappingFilePath(config.get("--mappingTxt").getAsString());
                }
                if (config.has("--resMappingTxt") && !Util.isNullOrNil(config.get("--resMappingTxt").getAsString())) {
                    this.jobConfig.setResMappingFilePath(config.get("--resMappingTxt").getAsString());
                }
                JsonArray options = config.getAsJsonArray("options");
                for (JsonElement option : options) {
                    if (option.isJsonObject()) {
                        ApkTask task;
                        String inputDir2;
                        JsonObject jsonOption = (JsonObject)option;
                        String name = jsonOption.get("name").getAsString();
                        HashMap<String, String> params = new HashMap<String, String>();
                        for (Map.Entry entry : jsonOption.entrySet()) {
                            if (!((String)entry.getKey()).startsWith("--")) continue;
                            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                                params.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (!((String)entry.getKey()).equals("--ignoreResources") && !((String)entry.getKey()).equals("--ignoreAssets")) continue;
                            JsonArray ignoreList = ((JsonElement)entry.getValue()).getAsJsonArray();
                            StringBuilder ignoreStrBuilder = new StringBuilder();
                            for (JsonElement ignore : ignoreList) {
                                ignoreStrBuilder.append(ignore.getAsString());
                                ignoreStrBuilder.append(',');
                            }
                            ignoreStrBuilder.deleteCharAt(ignoreStrBuilder.length() - 1);
                            params.put((String)entry.getKey(), ignoreStrBuilder.toString());
                        }
                        if (name.equals("-unusedResources") && !params.containsKey("--rTxt") && !Util.isNullOrNil(inputDir2 = this.jobConfig.getInputDir())) {
                            String string = inputDir2 + "/" + "R.txt";
                            params.put("--rTxt", string);
                        }
                        if ((task = this.createTask(name, params)) == null) continue;
                        this.taskList.add(task);
                        continue;
                    }
                    ApkChecker.printError("Unknown option: " + option.toString());
                }
            } else {
                ApkChecker.printError("The content of config file is not in json format!");
            }
        }
    }

    private int parseGlobalParams() {
        int paramLen = 0;
        HashMap<String, String> globalParams = new HashMap<String, String>();
        paramLen = this.parseParams(0, this.args, globalParams);
        try {
            if (globalParams.containsKey("--config")) {
                String configPath = (String)globalParams.get("--config");
                if (!FileUtil.isLegalFile(configPath)) {
                    ApkChecker.printError("Input config file '" + configPath + "' is illegal!");
                } else if (!configPath.endsWith(".json")) {
                    ApkChecker.printError("Input config file must has a suffix '.json'!");
                } else {
                    this.readConfigFile(configPath);
                }
            } else {
                File file;
                JarFile jarFile;
                Manifest manifest;
                Attributes registry;
                File inputFile;
                String inputDir;
                String apkPath = "";
                String mappingFilePath = "";
                String resMappingFilePath = "";
                if (globalParams.containsKey("--input") && !Util.isNullOrNil(inputDir = (String)globalParams.get("--input")) && (inputFile = new File(inputDir)).isDirectory() && inputFile.exists()) {
                    this.jobConfig.setInputDir(inputFile.getAbsolutePath());
                    for (File file2 : inputFile.listFiles()) {
                        if (!file2.isFile() || !file2.getName().endsWith(".apk")) continue;
                        apkPath = file2.getAbsolutePath();
                        break;
                    }
                    mappingFilePath = inputDir + "/" + "mapping.txt";
                    resMappingFilePath = inputDir + "/" + "resguard-mapping.txt";
                }
                if (globalParams.containsKey("--apk") && !FileUtil.isLegalFile(apkPath = (String)globalParams.get("--apk"))) {
                    ApkChecker.printError("Input apk path '" + apkPath + "' is illegal!");
                }
                this.jobConfig.setApkPath(apkPath);
                File apkFile = new File(apkPath);
                if (globalParams.containsKey("--unzip")) {
                    this.jobConfig.setUnzipPath((String)globalParams.get("--unzip"));
                } else {
                    this.jobConfig.setUnzipPath(apkFile.getParentFile().getAbsolutePath() + File.separator + this.getApkRawName(apkFile.getName()) + "_unzip");
                }
                if (globalParams.containsKey("--mappingTxt")) {
                    mappingFilePath = (String)globalParams.get("--mappingTxt");
                }
                this.jobConfig.setMappingFilePath(mappingFilePath);
                if (globalParams.containsKey("--resMappingTxt")) {
                    resMappingFilePath = (String)globalParams.get("--resMappingTxt");
                }
                this.jobConfig.setResMappingFilePath(resMappingFilePath);
                String value = "";
                value = globalParams.containsKey("--format") && !Util.isNullOrNil((String)globalParams.get("--format")) ? (String)globalParams.get("--format") : "html";
                String[] formats = value.split(",");
                ArrayList<String> formatList = new ArrayList<String>();
                for (String format : formats) {
                    if (Util.isNullOrNil(format)) continue;
                    formatList.add(format.trim());
                }
                Log.i(TAG, "format list " + ((Object)formatList).toString(), new Object[0]);
                this.jobConfig.setOutputFormatList(formatList);
                if (globalParams.containsKey("--output")) {
                    this.jobConfig.setOutputPath((String)globalParams.get("--output"));
                } else {
                    this.jobConfig.setOutputPath(apkFile.getParentFile().getAbsolutePath() + File.separator + this.getApkRawName(apkFile.getName()));
                }
                if (globalParams.containsKey("--formatJar") && (registry = (manifest = (jarFile = new JarFile(file = new File((String)globalParams.get("--formatJar")))).getManifest()).getAttributes("TaskResult-Registry")) != null) {
                    String registryClassPath = registry.getValue("TaskResult-Registry-Class");
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURL()});
                    Class<?> registryClass = classLoader.loadClass(registryClassPath);
                    TaskResultRegistry resultRegistry = (TaskResultRegistry)registryClass.newInstance();
                    TaskResultFactory.addCustomTaskJsonResult(resultRegistry.getJsonResult());
                    TaskResultFactory.addCustomTaskHtmlResult(resultRegistry.getHtmlResult());
                }
                if (globalParams.containsKey("--formatConfig")) {
                    JsonElement jsonElement = new JsonParser().parse((String)globalParams.get("--formatConfig"));
                    this.jobConfig.setOutputConfig((JsonArray)jsonElement);
                }
                if (globalParams.containsKey("--log")) {
                    Log.setLogLevel((String)globalParams.get("--log"));
                }
            }
            MMTaskResultRegistry mmTaskResultRegistry = new MMTaskResultRegistry();
            TaskResultFactory.addCustomTaskHtmlResult(mmTaskResultRegistry.getHtmlResult());
            TaskResultFactory.addCustomTaskJsonResult(mmTaskResultRegistry.getJsonResult());
        }
        catch (Exception e) {
            ApkChecker.printError(e.getMessage());
        }
        return paramLen;
    }

    private boolean parseParams() {
        if (this.args != null && this.args.length >= 2) {
            int paramLen;
            for (int i = paramLen = this.parseGlobalParams(); i < this.args.length; ++i) {
                ApkTask task;
                String inputDir;
                if (!this.args[i].startsWith("-") || this.args[i].startsWith("--")) continue;
                HashMap<String, String> params = new HashMap<String, String>();
                paramLen = this.parseParams(i + 1, this.args, params);
                if (!params.containsKey("--rTxt") && !Util.isNullOrNil(inputDir = this.jobConfig.getInputDir())) {
                    params.put("--rTxt", inputDir + "/" + "R.txt");
                }
                if ((task = this.createTask(this.args[i], params)) != null) {
                    this.taskList.add(task);
                }
                i += paramLen;
            }
        } else {
            return false;
        }
        return true;
    }

    public void run() throws Exception {
        if (this.parseParams()) {
            ApkTask unzipTask = TaskFactory.factory(1, this.jobConfig, new HashMap<String, String>());
            this.preTasks.add(unzipTask);
            for (String format : this.jobConfig.getOutputFormatList()) {
                JobResult result = JobResultFactory.factory(format, this.jobConfig);
                if (result != null) {
                    this.jobResults.add(result);
                    continue;
                }
                Log.w(TAG, "Unknown output format name '%s' !", format);
            }
            this.execute();
        } else {
            ApkChecker.printHelp();
        }
    }

    private void execute() throws Exception {
        try {
            for (ApkTask preTask : this.preTasks) {
                preTask.init();
                TaskResult taskResult = preTask.call();
                if (taskResult == null) continue;
                TaskResult formatResult = null;
                for (JobResult jobResult : this.jobResults) {
                    formatResult = TaskResultFactory.transferTaskResult(taskResult.taskType, taskResult, jobResult.getFormat(), this.jobConfig);
                    if (formatResult == null) continue;
                    jobResult.addTaskResult(formatResult);
                }
            }
            for (ApkTask task : this.taskList) {
                task.init();
            }
            List futures = this.executor.invokeAll(this.taskList, this.timeoutSeconds, TimeUnit.SECONDS);
            for (Future future : futures) {
                TaskResult taskResult = (TaskResult)future.get();
                if (taskResult == null) continue;
                TaskResult formatResult = null;
                for (JobResult jobResult : this.jobResults) {
                    formatResult = TaskResultFactory.transferTaskResult(taskResult.taskType, taskResult, jobResult.getFormat(), this.jobConfig);
                    if (formatResult == null) continue;
                    jobResult.addTaskResult(formatResult);
                }
            }
            this.executor.shutdownNow();
            for (JobResult jobResult : this.jobResults) {
                jobResult.output();
            }
            Log.d(TAG, "parse apk end, try to delete tmp un zip files", new Object[0]);
            FileUtils.deleteDirectory(new File(this.jobConfig.getUnzipPath()));
        }
        catch (Exception e) {
            Log.e(TAG, "Task executor execute with error:" + e.getMessage(), new Object[0]);
            throw e;
        }
    }
}

