/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.regex.Pattern;

public final class FileUtils {
    private static final Joiner PATH_JOINER = Joiner.on(File.separatorChar);
    private static final Joiner COMMA_SEPARATED_JOINER = Joiner.on(", ");
    private static final Joiner UNIX_NEW_LINE_JOINER = Joiner.on('\n');
    public static final Function<File, String> GET_NAME = new Function<File, String>(){

        @Override
        public String apply(File file) {
            return file.getName();
        }
    };
    public static final Function<File, String> GET_PATH = new Function<File, String>(){

        @Override
        public String apply(File file) {
            return file.getPath();
        }
    };

    private FileUtils() {
    }

    public static Predicate<File> withExtension(final String extension) {
        Preconditions.checkArgument(extension.charAt(0) != '.', "Extension should not start with a dot.");
        return new Predicate<File>(){

            @Override
            public boolean apply(File input) {
                return Files.getFileExtension(input.getName()).equals(extension);
            }
        };
    }

    public static void deleteFolder(File folder) throws IOException {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            throw new IOException(String.format("Could not delete folder %s", folder));
        }
    }

    public static void emptyFolder(File folder) throws IOException {
        FileUtils.deleteFolder(folder);
        if (!folder.mkdirs()) {
            throw new IOException(String.format("Could not create empty folder %s", folder));
        }
    }

    public static void copy(File from, File toDir) throws IOException {
        File to = new File(toDir, from.getName());
        if (from.isDirectory()) {
            FileUtils.mkdirs(to);
            File[] children = from.listFiles();
            if (children != null) {
                for (File child : children) {
                    FileUtils.copy(child, to);
                }
            }
        } else if (from.isFile()) {
            Files.copy(from, to);
        }
    }

    public static void mkdirs(File folder) {
        if (!folder.mkdirs() && !folder.exists()) {
            throw new RuntimeException("Cannot create directory " + folder);
        }
    }

    public static void delete(File file) throws IOException {
        boolean result = file.delete();
        if (!result) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void deleteIfExists(File file) throws IOException {
        boolean result = file.delete();
        if (!result && file.exists()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void renameTo(File file, File to) throws IOException {
        boolean result = file.renameTo(to);
        if (!result) {
            throw new IOException("Failed to rename " + file.getAbsolutePath() + " to " + to);
        }
    }

    public static File join(File dir, String ... paths) {
        if (paths.length == 0) {
            return dir;
        }
        return new File(dir, PATH_JOINER.join(paths));
    }

    public static File join(File dir, Iterable<String> paths) {
        return new File(dir, PATH_JOINER.join(paths));
    }

    public static String join(String ... paths) {
        return PATH_JOINER.join(paths);
    }

    public static String join(Iterable<String> paths) {
        return PATH_JOINER.join(paths);
    }

    public static String loadFileWithUnixLineSeparators(File file) throws IOException {
        return UNIX_NEW_LINE_JOINER.join(Files.readLines(file, Charsets.UTF_8));
    }

    public static String relativePath(File file, File dir) {
        Preconditions.checkArgument(file.isFile() || file.isDirectory(), "%s is not a file nor a directory.", file.getPath());
        Preconditions.checkArgument(dir.isDirectory(), "%s is not a directory.", dir.getPath());
        return FileUtils.relativePossiblyNonExistingPath(file, dir);
    }

    public static String relativePossiblyNonExistingPath(File file, File dir) {
        String path = dir.toURI().relativize(file.toURI()).getPath();
        return FileUtils.toSystemDependentPath(path);
    }

    public static String toSystemDependentPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public static String toSystemIndependentPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String sha1(File file) throws IOException {
        return Hashing.sha1().hashBytes(Files.toByteArray(file)).toString();
    }

    public static FluentIterable<File> getAllFiles(File dir) {
        return Files.fileTreeTraverser().preOrderTraversal(dir).filter(Files.isFile());
    }

    public static String getNamesAsCommaSeparatedList(Iterable<File> files) {
        return COMMA_SEPARATED_JOINER.join(Iterables.transform(files, GET_NAME));
    }

    public static String getDirectoryNameForJar(File inputFile) {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString(inputFile.getAbsolutePath(), Charsets.UTF_16LE);
        String name = Files.getNameWithoutExtension(inputFile.getName());
        if (name.equals("classes") && inputFile.getAbsolutePath().contains("exploded-aar")) {
            File versionDir = inputFile.getParentFile().getParentFile();
            File artifactDir = versionDir.getParentFile();
            File groupDir = artifactDir.getParentFile();
            name = Joiner.on('-').join(groupDir.getName(), artifactDir.getName(), versionDir.getName());
        }
        name = name + "_" + hashCode.toString();
        return name;
    }

    public static void createFile(File file, String content) throws IOException {
        Preconditions.checkArgument(!file.exists(), "%s exists already.", file);
        Files.createParentDirs(file);
        Files.write(content, file, Charsets.UTF_8);
    }

    public static List<File> find(File base, Pattern pattern) {
        Preconditions.checkArgument(base.isDirectory(), "'base' must be a directory.");
        return Files.fileTreeTraverser().preOrderTraversal(base).filter(Predicates.compose(Predicates.contains(pattern), GET_PATH)).toList();
    }

    public static Optional<File> find(File base, String name) {
        Preconditions.checkArgument(base.isDirectory(), "'base' must be a directory.");
        return Files.fileTreeTraverser().preOrderTraversal(base).filter(Predicates.compose(Predicates.equalTo(name), GET_NAME)).last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readSegment(File file, long start, int length) throws Exception {
        byte[] data;
        Preconditions.checkArgument(start >= 0L, "start < 0");
        Preconditions.checkArgument(length >= 0, "length < 0");
        boolean threw = true;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            int r;
            raf.seek(start);
            data = new byte[length];
            for (int tot = 0; tot < length; tot += r) {
                r = raf.read(data, tot, length - tot);
                if (r >= 0) continue;
                throw new EOFException();
            }
            threw = false;
        }
        finally {
            Closeables.close(raf, threw);
        }
        return data;
    }
}

