/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import com.android.dexdeps.ClassRef;
import com.android.dexdeps.DexDataException;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class DexData {
    private RandomAccessFile mDexFile;
    private HeaderItem mHeaderItem;
    private String[] mStrings;
    private TypeIdItem[] mTypeIds;
    private ProtoIdItem[] mProtoIds;
    private FieldIdItem[] mFieldIds;
    private MethodIdItem[] mMethodIds;
    private ClassDefItem[] mClassDefs;
    private byte[] tmpBuf = new byte[4];
    private boolean isBigEndian = false;

    public DexData(RandomAccessFile raf) {
        this.mDexFile = raf;
    }

    public void load() throws IOException {
        this.parseHeaderItem();
        this.loadStrings();
        this.loadTypeIds();
        this.loadProtoIds();
        this.loadFieldIds();
        this.loadMethodIds();
        this.loadClassDefs();
        this.markInternalClasses();
    }

    private static boolean verifyMagic(byte[] magic) {
        return Arrays.equals(magic, HeaderItem.DEX_FILE_MAGIC_v035) || Arrays.equals(magic, HeaderItem.DEX_FILE_MAGIC_v037) || Arrays.equals(magic, HeaderItem.DEX_FILE_MAGIC_v038) || Arrays.equals(magic, HeaderItem.DEX_FILE_MAGIC_v039) || Arrays.equals(magic, HeaderItem.DEX_FILE_MAGIC_v040);
    }

    void parseHeaderItem() throws IOException {
        this.mHeaderItem = new HeaderItem();
        this.seek(0);
        byte[] magic = new byte[8];
        this.readBytes(magic);
        if (!DexData.verifyMagic(magic)) {
            System.err.println("Magic number is wrong -- are you sure this is a DEX file?");
            throw new DexDataException();
        }
        this.seek(40);
        this.mHeaderItem.endianTag = this.readInt();
        if (this.mHeaderItem.endianTag != 305419896) {
            if (this.mHeaderItem.endianTag == 2018915346) {
                this.isBigEndian = true;
            } else {
                System.err.println("Endian constant has unexpected value " + Integer.toHexString(this.mHeaderItem.endianTag));
                throw new DexDataException();
            }
        }
        this.seek(32);
        this.mHeaderItem.fileSize = this.readInt();
        this.mHeaderItem.headerSize = this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        this.readInt();
        this.mHeaderItem.stringIdsSize = this.readInt();
        this.mHeaderItem.stringIdsOff = this.readInt();
        this.mHeaderItem.typeIdsSize = this.readInt();
        this.mHeaderItem.typeIdsOff = this.readInt();
        this.mHeaderItem.protoIdsSize = this.readInt();
        this.mHeaderItem.protoIdsOff = this.readInt();
        this.mHeaderItem.fieldIdsSize = this.readInt();
        this.mHeaderItem.fieldIdsOff = this.readInt();
        this.mHeaderItem.methodIdsSize = this.readInt();
        this.mHeaderItem.methodIdsOff = this.readInt();
        this.mHeaderItem.classDefsSize = this.readInt();
        this.mHeaderItem.classDefsOff = this.readInt();
        this.readInt();
        this.readInt();
    }

    void loadStrings() throws IOException {
        int i;
        int count = this.mHeaderItem.stringIdsSize;
        int[] stringOffsets = new int[count];
        this.seek(this.mHeaderItem.stringIdsOff);
        for (i = 0; i < count; ++i) {
            stringOffsets[i] = this.readInt();
        }
        this.mStrings = new String[count];
        for (i = 0; i < count; ++i) {
            this.seek(stringOffsets[i]);
            this.mStrings[i] = this.readString();
        }
    }

    void loadTypeIds() throws IOException {
        int count = this.mHeaderItem.typeIdsSize;
        this.mTypeIds = new TypeIdItem[count];
        this.seek(this.mHeaderItem.typeIdsOff);
        for (int i = 0; i < count; ++i) {
            this.mTypeIds[i] = new TypeIdItem();
            this.mTypeIds[i].descriptorIdx = this.readInt();
        }
    }

    void loadProtoIds() throws IOException {
        int i;
        int count = this.mHeaderItem.protoIdsSize;
        this.mProtoIds = new ProtoIdItem[count];
        this.seek(this.mHeaderItem.protoIdsOff);
        for (i = 0; i < count; ++i) {
            this.mProtoIds[i] = new ProtoIdItem();
            this.mProtoIds[i].shortyIdx = this.readInt();
            this.mProtoIds[i].returnTypeIdx = this.readInt();
            this.mProtoIds[i].parametersOff = this.readInt();
        }
        for (i = 0; i < count; ++i) {
            ProtoIdItem protoId = this.mProtoIds[i];
            int offset = protoId.parametersOff;
            if (offset == 0) {
                protoId.types = new int[0];
                continue;
            }
            this.seek(offset);
            int size = this.readInt();
            protoId.types = new int[size];
            for (int j = 0; j < size; ++j) {
                protoId.types[j] = this.readShort() & 0xFFFF;
            }
        }
    }

    void loadFieldIds() throws IOException {
        int count = this.mHeaderItem.fieldIdsSize;
        this.mFieldIds = new FieldIdItem[count];
        this.seek(this.mHeaderItem.fieldIdsOff);
        for (int i = 0; i < count; ++i) {
            this.mFieldIds[i] = new FieldIdItem();
            this.mFieldIds[i].classIdx = this.readShort() & 0xFFFF;
            this.mFieldIds[i].typeIdx = this.readShort() & 0xFFFF;
            this.mFieldIds[i].nameIdx = this.readInt();
        }
    }

    void loadMethodIds() throws IOException {
        int count = this.mHeaderItem.methodIdsSize;
        this.mMethodIds = new MethodIdItem[count];
        this.seek(this.mHeaderItem.methodIdsOff);
        for (int i = 0; i < count; ++i) {
            this.mMethodIds[i] = new MethodIdItem();
            this.mMethodIds[i].classIdx = this.readShort() & 0xFFFF;
            this.mMethodIds[i].protoIdx = this.readShort() & 0xFFFF;
            this.mMethodIds[i].nameIdx = this.readInt();
        }
    }

    void loadClassDefs() throws IOException {
        int count = this.mHeaderItem.classDefsSize;
        this.mClassDefs = new ClassDefItem[count];
        this.seek(this.mHeaderItem.classDefsOff);
        for (int i = 0; i < count; ++i) {
            this.mClassDefs[i] = new ClassDefItem();
            this.mClassDefs[i].classIdx = this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
            this.readInt();
        }
    }

    void markInternalClasses() {
        int i;
        for (i = this.mClassDefs.length - 1; i >= 0; --i) {
            this.mTypeIds[this.mClassDefs[i].classIdx].internal = true;
        }
        for (i = 0; i < this.mTypeIds.length; ++i) {
            String className = this.mStrings[this.mTypeIds[i].descriptorIdx];
            if (className.length() == 1) {
                this.mTypeIds[i].internal = true;
                continue;
            }
            if (className.charAt(0) != '[') continue;
            this.mTypeIds[i].internal = true;
        }
    }

    private String classNameFromTypeIndex(int idx) {
        return this.mStrings[this.mTypeIds[idx].descriptorIdx];
    }

    private String[] argArrayFromProtoIndex(int idx) {
        ProtoIdItem protoId = this.mProtoIds[idx];
        String[] result = new String[protoId.types.length];
        for (int i = 0; i < protoId.types.length; ++i) {
            result[i] = this.mStrings[this.mTypeIds[protoId.types[i]].descriptorIdx];
        }
        return result;
    }

    private String returnTypeFromProtoIndex(int idx) {
        ProtoIdItem protoId = this.mProtoIds[idx];
        return this.mStrings[this.mTypeIds[protoId.returnTypeIdx].descriptorIdx];
    }

    public ClassRef[] getExternalReferences() {
        ClassRef[] sparseRefs = new ClassRef[this.mTypeIds.length];
        int count = 0;
        for (int i = 0; i < this.mTypeIds.length; ++i) {
            if (this.mTypeIds[i].internal) continue;
            sparseRefs[i] = new ClassRef(this.mStrings[this.mTypeIds[i].descriptorIdx]);
            ++count;
        }
        this.addExternalFieldReferences(sparseRefs);
        this.addExternalMethodReferences(sparseRefs);
        ClassRef[] classRefs = new ClassRef[count];
        int idx = 0;
        for (int i = 0; i < this.mTypeIds.length; ++i) {
            if (sparseRefs[i] == null) continue;
            classRefs[idx++] = sparseRefs[i];
        }
        assert (idx == count);
        return classRefs;
    }

    private void addExternalFieldReferences(ClassRef[] sparseRefs) {
        for (int i = 0; i < this.mFieldIds.length; ++i) {
            if (this.mTypeIds[this.mFieldIds[i].classIdx].internal) continue;
            FieldIdItem fieldId = this.mFieldIds[i];
            FieldRef newFieldRef = new FieldRef(this.classNameFromTypeIndex(fieldId.classIdx), this.classNameFromTypeIndex(fieldId.typeIdx), this.mStrings[fieldId.nameIdx]);
            sparseRefs[this.mFieldIds[i].classIdx].addField(newFieldRef);
        }
    }

    private void addExternalMethodReferences(ClassRef[] sparseRefs) {
        for (int i = 0; i < this.mMethodIds.length; ++i) {
            if (this.mTypeIds[this.mMethodIds[i].classIdx].internal) continue;
            MethodIdItem methodId = this.mMethodIds[i];
            MethodRef newMethodRef = new MethodRef(this.classNameFromTypeIndex(methodId.classIdx), this.argArrayFromProtoIndex(methodId.protoIdx), this.returnTypeFromProtoIndex(methodId.protoIdx), this.mStrings[methodId.nameIdx]);
            sparseRefs[this.mMethodIds[i].classIdx].addMethod(newMethodRef);
        }
    }

    public ClassRef[] getInternalReferences() {
        ClassRef[] sparseRefs = new ClassRef[this.mTypeIds.length];
        int count = 0;
        for (int i = 0; i < this.mTypeIds.length; ++i) {
            if (!this.mTypeIds[i].internal) continue;
            sparseRefs[i] = new ClassRef(this.mStrings[this.mTypeIds[i].descriptorIdx]);
            ++count;
        }
        this.addInternalFieldReferences(sparseRefs);
        this.addInternalMethodReferences(sparseRefs);
        ClassRef[] classRefs = new ClassRef[count];
        int idx = 0;
        for (int i = 0; i < this.mTypeIds.length; ++i) {
            if (sparseRefs[i] == null) continue;
            classRefs[idx++] = sparseRefs[i];
        }
        assert (idx == count);
        return classRefs;
    }

    private void addInternalFieldReferences(ClassRef[] sparseRefs) {
        for (int i = 0; i < this.mFieldIds.length; ++i) {
            if (!this.mTypeIds[this.mFieldIds[i].classIdx].internal) continue;
            FieldIdItem fieldId = this.mFieldIds[i];
            FieldRef newFieldRef = new FieldRef(this.classNameFromTypeIndex(fieldId.classIdx), this.classNameFromTypeIndex(fieldId.typeIdx), this.mStrings[fieldId.nameIdx]);
            sparseRefs[this.mFieldIds[i].classIdx].addField(newFieldRef);
        }
    }

    private void addInternalMethodReferences(ClassRef[] sparseRefs) {
        for (int i = 0; i < this.mMethodIds.length; ++i) {
            if (!this.mTypeIds[this.mMethodIds[i].classIdx].internal) continue;
            MethodIdItem methodId = this.mMethodIds[i];
            MethodRef newMethodRef = new MethodRef(this.classNameFromTypeIndex(methodId.classIdx), this.argArrayFromProtoIndex(methodId.protoIdx), this.returnTypeFromProtoIndex(methodId.protoIdx), this.mStrings[methodId.nameIdx]);
            sparseRefs[this.mMethodIds[i].classIdx].addMethod(newMethodRef);
        }
    }

    public MethodRef[] getMethodRefs() {
        MethodRef[] methodRefs = new MethodRef[this.mMethodIds.length];
        for (int i = 0; i < this.mMethodIds.length; ++i) {
            MethodIdItem methodId = this.mMethodIds[i];
            methodRefs[i] = new MethodRef(this.classNameFromTypeIndex(methodId.classIdx), this.argArrayFromProtoIndex(methodId.protoIdx), this.returnTypeFromProtoIndex(methodId.protoIdx), this.mStrings[methodId.nameIdx]);
        }
        return methodRefs;
    }

    public FieldRef[] getFieldRefs() {
        FieldRef[] fieldRefs = new FieldRef[this.mFieldIds.length];
        for (int i = 0; i < this.mFieldIds.length; ++i) {
            FieldIdItem fieldId = this.mFieldIds[i];
            fieldRefs[i] = new FieldRef(this.classNameFromTypeIndex(fieldId.classIdx), this.classNameFromTypeIndex(fieldId.typeIdx), this.mStrings[fieldId.nameIdx]);
        }
        return fieldRefs;
    }

    void seek(int position) throws IOException {
        this.mDexFile.seek(position);
    }

    void readBytes(byte[] buffer) throws IOException {
        this.mDexFile.readFully(buffer);
    }

    byte readByte() throws IOException {
        this.mDexFile.readFully(this.tmpBuf, 0, 1);
        return this.tmpBuf[0];
    }

    short readShort() throws IOException {
        this.mDexFile.readFully(this.tmpBuf, 0, 2);
        if (this.isBigEndian) {
            return (short)(this.tmpBuf[1] & 0xFF | (this.tmpBuf[0] & 0xFF) << 8);
        }
        return (short)(this.tmpBuf[0] & 0xFF | (this.tmpBuf[1] & 0xFF) << 8);
    }

    int readInt() throws IOException {
        this.mDexFile.readFully(this.tmpBuf, 0, 4);
        if (this.isBigEndian) {
            return this.tmpBuf[3] & 0xFF | (this.tmpBuf[2] & 0xFF) << 8 | (this.tmpBuf[1] & 0xFF) << 16 | (this.tmpBuf[0] & 0xFF) << 24;
        }
        return this.tmpBuf[0] & 0xFF | (this.tmpBuf[1] & 0xFF) << 8 | (this.tmpBuf[2] & 0xFF) << 16 | (this.tmpBuf[3] & 0xFF) << 24;
    }

    int readUnsignedLeb128() throws IOException {
        byte val;
        int result = 0;
        do {
            val = this.readByte();
            result = result << 7 | val & 0x7F;
        } while (val < 0);
        return result;
    }

    String readString() throws IOException {
        byte val;
        int idx;
        int utf16len = this.readUnsignedLeb128();
        byte[] inBuf = new byte[utf16len * 3];
        for (idx = 0; idx < inBuf.length && (val = this.readByte()) != 0; ++idx) {
            inBuf[idx] = val;
        }
        return new String(inBuf, 0, idx, "UTF-8");
    }

    static class ClassDefItem {
        public int classIdx;

        ClassDefItem() {
        }
    }

    static class MethodIdItem {
        public int classIdx;
        public int protoIdx;
        public int nameIdx;

        MethodIdItem() {
        }
    }

    static class FieldIdItem {
        public int classIdx;
        public int typeIdx;
        public int nameIdx;

        FieldIdItem() {
        }
    }

    static class ProtoIdItem {
        public int shortyIdx;
        public int returnTypeIdx;
        public int parametersOff;
        public int[] types;

        ProtoIdItem() {
        }
    }

    static class TypeIdItem {
        public int descriptorIdx;
        public boolean internal;

        TypeIdItem() {
        }
    }

    static class HeaderItem {
        public int fileSize;
        public int headerSize;
        public int endianTag;
        public int stringIdsSize;
        public int stringIdsOff;
        public int typeIdsSize;
        public int typeIdsOff;
        public int protoIdsSize;
        public int protoIdsOff;
        public int fieldIdsSize;
        public int fieldIdsOff;
        public int methodIdsSize;
        public int methodIdsOff;
        public int classDefsSize;
        public int classDefsOff;
        public static final byte[] DEX_FILE_MAGIC_v035 = "dex\n035\u0000".getBytes(StandardCharsets.US_ASCII);
        public static final byte[] DEX_FILE_MAGIC_v037 = "dex\n037\u0000".getBytes(StandardCharsets.US_ASCII);
        public static final byte[] DEX_FILE_MAGIC_v038 = "dex\n038\u0000".getBytes(StandardCharsets.US_ASCII);
        public static final byte[] DEX_FILE_MAGIC_v039 = "dex\n039\u0000".getBytes(StandardCharsets.US_ASCII);
        public static final byte[] DEX_FILE_MAGIC_v040 = "dex\n040\u0000".getBytes(StandardCharsets.US_ASCII);
        public static final int ENDIAN_CONSTANT = 305419896;
        public static final int REVERSE_ENDIAN_CONSTANT = 2018915346;

        HeaderItem() {
        }
    }
}

