/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.DirUtil;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.PathAlreadyExists;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDirectory
implements Directory {
    protected Set<String> mFiles;
    protected Set<String> mFilesRecursive;
    protected Map<String, AbstractDirectory> mDirs;

    @Override
    public Set<String> getFiles() {
        return this.getFiles(false);
    }

    @Override
    public Set<String> getFiles(boolean recursive) {
        if (this.mFiles == null) {
            this.loadFiles();
        }
        if (!recursive) {
            return this.mFiles;
        }
        if (this.mFilesRecursive == null) {
            this.mFilesRecursive = new LinkedHashSet<String>(this.mFiles);
            for (Map.Entry<String, AbstractDirectory> dir : this.getAbstractDirs().entrySet()) {
                for (String path : ((Directory)dir.getValue()).getFiles(true)) {
                    this.mFilesRecursive.add(dir.getKey() + '/' + path);
                }
            }
        }
        return this.mFilesRecursive;
    }

    @Override
    public boolean containsFile(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist e) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.containsFile(subpath.path);
        }
        return this.getFiles().contains(subpath.path);
    }

    @Override
    public boolean containsDir(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist e) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.containsDir(subpath.path);
        }
        return this.getAbstractDirs().containsKey(subpath.path);
    }

    @Override
    public Map<String, Directory> getDirs() throws UnsupportedOperationException {
        return this.getDirs(false);
    }

    @Override
    public Map<String, Directory> getDirs(boolean recursive) throws UnsupportedOperationException {
        return new LinkedHashMap<String, Directory>(this.getAbstractDirs(recursive));
    }

    @Override
    public InputStream getFileInput(String path) throws DirectoryException {
        SubPath subpath = this.getSubPath(path);
        if (subpath.dir != null) {
            return subpath.dir.getFileInput(subpath.path);
        }
        if (!this.getFiles().contains(subpath.path)) {
            throw new PathNotExist(path);
        }
        return this.getFileInputLocal(subpath.path);
    }

    @Override
    public OutputStream getFileOutput(String path) throws DirectoryException {
        Directory dir;
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            this.getFiles().add(parsed.subpath);
            return this.getFileOutputLocal(parsed.subpath);
        }
        try {
            dir = this.createDir(parsed.dir);
        }
        catch (PathAlreadyExists e) {
            dir = this.getAbstractDirs().get(parsed.dir);
        }
        return dir.getFileOutput(parsed.subpath);
    }

    @Override
    public Directory getDir(String path) throws PathNotExist {
        SubPath subpath = this.getSubPath(path);
        if (subpath.dir != null) {
            return subpath.dir.getDir(subpath.path);
        }
        if (!this.getAbstractDirs().containsKey(subpath.path)) {
            throw new PathNotExist(path);
        }
        return this.getAbstractDirs().get(subpath.path);
    }

    @Override
    public Directory createDir(String path) throws DirectoryException {
        AbstractDirectory dir;
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            if (this.getAbstractDirs().containsKey(parsed.subpath)) {
                throw new PathAlreadyExists(path);
            }
            AbstractDirectory dir2 = this.createDirLocal(parsed.subpath);
            this.getAbstractDirs().put(parsed.subpath, dir2);
            return dir2;
        }
        if (this.getAbstractDirs().containsKey(parsed.dir)) {
            dir = this.getAbstractDirs().get(parsed.dir);
        } else {
            dir = this.createDirLocal(parsed.dir);
            this.getAbstractDirs().put(parsed.dir, dir);
        }
        return dir.createDir(parsed.subpath);
    }

    @Override
    public boolean removeFile(String path) {
        SubPath subpath;
        try {
            subpath = this.getSubPath(path);
        }
        catch (PathNotExist e) {
            return false;
        }
        if (subpath.dir != null) {
            return subpath.dir.removeFile(subpath.path);
        }
        if (!this.getFiles().contains(subpath.path)) {
            return false;
        }
        this.removeFileLocal(subpath.path);
        this.getFiles().remove(subpath.path);
        return true;
    }

    @Override
    public void copyToDir(Directory out) throws DirectoryException {
        DirUtil.copyToDir(out, out);
    }

    @Override
    public void copyToDir(Directory out, String[] fileNames) throws DirectoryException {
        DirUtil.copyToDir(out, out, fileNames);
    }

    @Override
    public void copyToDir(Directory out, String fileName) throws DirectoryException {
        DirUtil.copyToDir(out, out, fileName);
    }

    @Override
    public void copyToDir(File out) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, out);
    }

    @Override
    public void copyToDir(File out, String[] fileNames) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, out, fileNames);
    }

    @Override
    public void copyToDir(File out, String fileName) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, out, fileName);
    }

    @Override
    public int getCompressionLevel(String fileName) throws DirectoryException {
        return -1;
    }

    protected Map<String, AbstractDirectory> getAbstractDirs() {
        return this.getAbstractDirs(false);
    }

    protected Map<String, AbstractDirectory> getAbstractDirs(boolean recursive) {
        if (this.mDirs == null) {
            this.loadDirs();
        }
        if (!recursive) {
            return this.mDirs;
        }
        LinkedHashMap<String, AbstractDirectory> dirs = new LinkedHashMap<String, AbstractDirectory>(this.mDirs);
        for (Map.Entry<String, AbstractDirectory> dir : this.getAbstractDirs().entrySet()) {
            for (Map.Entry<String, AbstractDirectory> subdir : dir.getValue().getAbstractDirs(true).entrySet()) {
                dirs.put(dir.getKey() + '/' + subdir.getKey(), subdir.getValue());
            }
        }
        return dirs;
    }

    @Override
    public void close() throws IOException {
    }

    private SubPath getSubPath(String path) throws PathNotExist {
        ParsedPath parsed = this.parsePath(path);
        if (parsed.dir == null) {
            return new SubPath(null, parsed.subpath);
        }
        if (!this.getAbstractDirs().containsKey(parsed.dir)) {
            throw new PathNotExist(path);
        }
        return new SubPath(this.getAbstractDirs().get(parsed.dir), parsed.subpath);
    }

    private ParsedPath parsePath(String path) {
        int pos = path.indexOf(47);
        if (pos == -1) {
            return new ParsedPath(null, path);
        }
        return new ParsedPath(path.substring(0, pos), path.substring(pos + 1));
    }

    protected abstract void loadFiles();

    protected abstract void loadDirs();

    protected abstract InputStream getFileInputLocal(String var1) throws DirectoryException;

    protected abstract OutputStream getFileOutputLocal(String var1) throws DirectoryException;

    protected abstract AbstractDirectory createDirLocal(String var1) throws DirectoryException;

    protected abstract void removeFileLocal(String var1);

    private class SubPath {
        public final AbstractDirectory dir;
        public final String path;

        public SubPath(AbstractDirectory dir, String path) {
            this.dir = dir;
            this.path = path;
        }
    }

    private class ParsedPath {
        public final String dir;
        public final String subpath;

        public ParsedPath(String dir, String subpath) {
            this.dir = dir;
            this.subpath = subpath;
        }
    }
}

