// status, foods, name, info, notice.
export default [
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Sauces,processed cheese and foods with added vitamins such as bread.',
    id: '2',
    veg: '0',
    name: 'Riboflavin (Vitamin B2)',
    info: 'Riboflavin is also known as vitamin B2. Obtained by fermenting yeast or synthesised artificially.',
    code: '101',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/101',
    function: 'food coloring (yellow-orange)',
  },
  {
    notice:
      'Safe in recommended doses. High doses should not be taken by people with gallstones, obstructive jaundice, acute bilious colic or toxic liver disorders.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:30+0300',
    foods: 'Fats and oils, curry, processed cheese and fish fingers.',
    id: '1',
    veg: '',
    name: 'Curcuma (turmeric)',
    info: 'Orange-yellow colouring extracted from the rhizomes of the turmeric plant.',
    code: '100',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/100',
    function: 'food coloring (yellow-orange)',
  },
  {
    notice: 'Safe in normal consumption. No adverse effects are known.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:45+0300',
    foods:
      'Found in some types of cheese, chewing gum, ice cream, Parsley sauce, soups and green vegetables and fruits preserved in liquids.',
    id: '34',
    veg: '0',
    name: 'Copper complexes of chlorophylls and chlorophyllins',
    info: 'Derived from Chlorophyll, E140, by substitution of copper for the magnesium, which increases stability.',
    code: '141',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/141',
    function: 'food coloring (green)',
  },
  {
    notice:
      'Unpermitted (Banned in Norway and Austria.) Provokes asthma attacks, urticaria in children, linked to thyroid tumors, chromosomal damage. Tartrazine appears to cause the most allergic and/or intolerance reactions of all the azo dyes, particularly amongst those with an aspirin intolerance and asthmatics. Other reactions can include migraine, blurred vision, itching, rhinitis and purple skin patches. In conjunction with E210 tartrazine appears to create an over-activity in children.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Fruit squash, fruit cordial, coloured fizzy drinks, instant puddings, cake mixes, custard powder, soups, sauces, ice cream, ice lollies, sweets, chewing gum, marzipan, jam, jelly, marmalade, mustard, yoghurt and many convenience foods together with glycerine, lemon and honey products.',
    id: '4',
    veg: '0',
    name: 'Tartrazine (FD&C Yellow 5)',
    info: 'Yellow coloured synthetic azo colour.',
    code: '102',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/102',
    function: 'food coloring (lemon yellow)',
  },
  {
    notice: 'No general oral toxicity studies with lysozyme were available.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ripened cheese.',
    id: '13',
    veg: '1',
    name: 'Lysozyme',
    info: 'A naturally occuring enzyme that kills bacteria. Origin - chicken eggs.',
    code: '1105',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1105',
    function: 'preservative',
  },
  {
    notice:
      'Banned in Austria, Japan, Norway, Sweden, Switzerland and US. People who suffer Asthma may also show an allergic reaction to it. HACSG recommends to avoid it and it has been linked to cancer.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Typical products are soft drinks.',
    id: '9',
    veg: '0',
    name: 'Yellow 2G',
    info: 'It has the appearance of a yellow powder, soluble in water. It is a synthetic coal tar and yellow azo dye.',
    code: '107',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/107',
    function: 'food coloring (yellow)',
  },
  {
    notice:
      'May cause allergic reactions. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:30+0300',
    foods:
      'Alcoholic drinks, bakery products and toppings, biscuits, desserts, drinks, icings, pie fillings, some varieties of cheddar cheese, sauces and sweets.',
    id: '15',
    veg: '1',
    name: 'Cochineal; Carminic acid; Carmines',
    info: 'An expensive red colouring, not suitable for vegetarians as it is extracted from the crushed carcasses of the female Dactylopius coccus, a cactus-feeding scale insect, which are killed by either immersion in hot water or by exposure to sunlight, steam, or the heat of an oven.',
    code: '120',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/120',
    function: 'food coloring (crimson)',
  },
  {
    notice:
      'Invertase is used to prevent crystallization in candy making. Invertase is an enzyme that is commonly used to make liquid centers and invert sugar in candy making, including chocolate covered cherries.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Confectionery, soft-centred chocolates.',
    id: '12',
    veg: '',
    name: 'Invertase',
    info: 'Enzyme that breaks down sucrose. Commercially derived from the fermentation of yeast.',
    code: '1103',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1103',
    function: 'stabiliser',
  },
  {
    notice:
      'Unpermitted (Banned in Canada, Finland, Japan, Norway, Sweden and the US.) Known to cause hyperactivity, asthma, uticaria, and insomnia. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Desserts, gravy granules, ice cream, mint sauce, sweets, packet breadcrumbs, cake mixes and tinned peas.',
    id: '39',
    veg: '0',
    name: 'Green S',
    info: 'A green synthetic coal tar dye.',
    code: '142',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/142',
    function: 'food coloring (green)',
  },
  {
    notice:
      'Not permitted. Banned in Australia, Japan, Norway and US. Cause dermatitis. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:30+0300',
    foods:
      'Smoked fish, ice cream, scotch eggs and smoked haddock. Used in lipsticks hair products, colognes; also in a wide range of medications;',
    id: '6',
    veg: '0',
    name: 'Quinoline Yellow',
    info: "The disodium salt of disulphonic acid. A synthetic 'coal tar' dye.",
    code: '104',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/104',
    function: 'food coloring (dull or greenish yellow)',
  },
  {
    notice:
      'Forbidden (Used in Britain.). Concerns that it can interfere with blood haemoglobin. Not recommended for consumption by children.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Meat products and sausages but can also be found in jams and drinks.',
    id: '26',
    veg: '0',
    name: 'Red 2G',
    info: 'A red synthetic coal tar or azo dye.',
    code: '128',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/128',
    function: 'food coloring (red)',
  },
  {
    notice:
      "The additives are regarded as an effective source of riboflavin in covering the animal's requirement when administered orally.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Found in many foods for babies and young children as well as jams, milk products and sweets and sugar products.',
    id: '3',
    veg: '',
    name: "Riboflavin-5'-Phosphate",
    info: "Consists mainly of the monosodium salt of the 5'-monophosphate ester of riboflavin dihydrate obtained from chemical action on E101 Riboflavin. It is rapidly turned to free riboflavin after ingestion.",
    code: '101a',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/101a',
    function: 'food coloring (yellow-orange)',
  },
  {
    notice: 'Forbidden (Permitted in the US.). Carcinogen',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: '',
    id: '19',
    veg: '',
    name: 'Citrus Red 2',
    info: 'It is an orange to yellow solid or a dark red powder with a melting point of 156 °C.',
    code: '121',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/121',
    function: 'food coloring (dark red)',
  },
  {
    id: '14',
    code: '111',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '1',
    name: 'Orange GGN',
    status: 'Hazard',
    veg: '',
    function: 'food coloring (orange)',
    foods: '',
    notice:
      'It is forbidden for food use in general, because toxicological data has shown it is harmful',
    info: 'Orange GGN, also known as alpha-naphthol orange, is a food dye.',
    url: 'http://e-additives.herokuapp.com/additives/111',
  },
  {
    id: '7',
    code: '105',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '1',
    name: 'Fast Yellow AB',
    status: 'Hazard',
    veg: '',
    function: 'food coloring (yellow)',
    foods: '',
    notice:
      'It is forbidden for food use in general, because toxicological data has shown it is harmful',
    info: 'An azo dye.',
    url: 'http://e-additives.herokuapp.com/additives/105',
  },
  {
    notice:
      'Banned in Austria, Belgium, Denmark, France, Germany, Greece, Italy, Norway, Spain, Sweden and Switzerland. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Can be found in tinned processed peas, dairy products, sweets and drinks.',
    id: '31',
    veg: '0',
    name: 'Brilliant Blue FCF (FD&C Blue 1)',
    info: 'A blue synthetic coal tar dye often used in conjunction with E102, Tartrazine, to produce various shades of green.',
    code: '133',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/133',
    function: 'food coloring (reddish blue)',
  },
  {
    notice:
      'Undergoing a voluntary phase-out in the UK, currently banned in Canada, Japan, Norway, USA & Sweden. EU currently evaluating health risks. It appears to cause allergic and/or intolerance reactions, particularly amongst those with an aspirin intolerance. Other reactions can include a rash similar to nettle rash and water retention. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Foods which must be heat treated after fermentation. Also found in blancmange, marzipan, Swiss roll, jams and preserves, sweets, brown sauce, flavoured yogurts, packet soups, jellies, breadcrumbs and cheesecake mixes.',
    id: '20',
    veg: '0',
    name: 'Carmoisine; Azorubine',
    info: 'Red coloured synthetic azo colour.',
    code: '122',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/122',
    function: 'food coloring (red to maroon)',
  },
  {
    notice:
      'With regard to allergenicity the product specification allows up to 0.8 % protein, safe at the proposed conditions of use and intake levels.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:30+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '37',
    veg: '0',
    name: 'Phosphated distarch phosphate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1413',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1413',
    function: 'stabiliser; thickening agent',
  },
  {
    notice:
      'Forbidden (Banned in the United States in 1976. Several countries still use it.) It appears to cause allergic and/or intolerance reactions, similar to nettle rash, particularly amongst those with an aspirin intolerance or asthmatics. can provoke asthma, eczema and hyperactivity; it caused birth defects and foetal deaths in some animal tests, possibly also cancer. Not recommended for consumption by children.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Ice creams, gravy granules, jams, jelly, tinned fruit pie fillings and prawns and packeted cake mixes, soups and trifles.',
    id: '21',
    veg: '0',
    name: 'Amaranth; FD&C Red 2',
    info: 'Derived from the small herbaceous plant of the same name. A purplish-red (blackcurrant) synthetic coal tar or azo dye.',
    code: '123',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/123',
    function: 'food coloring (blue)',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Dietary food supplement (tablets).',
    id: '18',
    veg: '0',
    name: 'Polyvinylpolypyrrolidone',
    info: 'Carriers are substances that can be used to contain another additive.',
    code: '1202',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1202',
    function: 'stabiliser',
  },
  {
    notice: 'There was no evidence for carcinogenicity.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '46',
    veg: '',
    name: 'Acetylated oxidised starch',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1451',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1451',
    function: 'emulsifier; thickening agent',
  },
  {
    notice:
      'Acceptable Daily Intake (ADI) not specified. Toxicity has not been observed at any amount, and some are Generally Recognized As Safe',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '40',
    veg: '0',
    name: 'Acetylated starch',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it.',
    code: '1420',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1420',
    function: 'stabiliser; thickening agent',
  },
  {
    notice:
      'Has been linked with fatal heart attacks, central nervous system depression, contact dermatitis.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Frozen dairy products.',
    id: '55',
    veg: '0',
    name: 'Propylene glycol',
    info: 'Helps to prevent the food it is added to from drying out.',
    code: '1520',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1520',
    function: 'humectant; anti-caking agent',
  },
  {
    notice:
      'Banned in Finland, Norway & the UK (voluntarily). Products in the EU require warnings and is evaluating a phase-out. Urticaria (hives), rhinitis (runny nose), nasal congestion, allergies, hyperactivity, kidney tumors, chromosomal damage, abdominal pain, nausea and vomiting, indigestion, distaste for food; increased incidence of tumors in animals. It appears to cause allergic and/or intolerance reactions, particularly amongst those with an aspirin intolerance. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Hazard.',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Orange squash, orange jelly, marzipan, Swiss roll, apricot jam, citrus marmalade, lemon curd, sweets, hot chocolate mix and packet soups, breadcrumbs, cheese sauce, ice cream, canned fish, and many medications.',
    id: '10',
    veg: '1',
    name: 'Sunset Yellow FCF (Orange Yellow S)',
    info: "A synthetic 'coal tar' and azo yellow dye used in fermented foods which must be heat treated.",
    code: '110',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/110',
    function: 'food coloring (yellow-orange)',
  },
  {
    notice:
      'Found to have Tumorigenic effects in experimental animals, as well as Mutagenic effects in both experimental animals and humans. It furthermore risks irritation of eyes, skin, digestive tract, and respiratory tract in its undiluted form.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'It can be used for tinned green peas and other vegetables, jellies, sauces, fish, desserts, and dry bakery mixes at level of up to 100 mg/kg.',
    id: '42',
    veg: '',
    name: 'Fast Green FCF (FD&C Green 3)',
    info: 'A sea green triarylmethane food dye.',
    code: '143',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/143',
    function: 'food coloring (sea green)',
  },
  {
    id: '63',
    code: '160e',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '1',
    name: "Beta-apo-8' carotenal (C30)",
    status: 'Safe',
    veg: '1',
    function: 'food coloring',
    foods: 'Processed cheese.',
    notice:
      "The low acute oral toxicity of β-apo-8'-carotenal is demonstrated by a mouse LD50 that exceeds 10 g/kg bw. Apart from the pigment deposition in the liver and kidneys, no adverse effects occurred in rats fed up to 500 mg/kg bw/day Beta-apo-8' carotenal for 34 weeks.",
    info: 'Orange-yellow synthetic colour.',
    url: 'http://e-additives.herokuapp.com/additives/160e',
  },
  {
    notice: 'Not permitted in Australia.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Used widely in poultry feed to deepen the colour of egg yolks (see also E161b) it can also be found in cheese slices and chicken pies.',
    id: '61',
    veg: '1',
    name: 'Paprika extract; Capsanthian; Capsorubin',
    info: 'An orange to red color extracted from the fruit pod and seeds of the red pepper, Capsicum annuum.',
    code: '160c',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/160c',
    function: 'food coloring',
  },
  {
    notice: "Toxic at 'high doses'.",
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Biscuits, bread, cakes, ice cream, sweets, vitamin and other tablets and to firm canned fruit and vegetables, it is sometimes used for to deacidify wine. Also used in toothpastes, white paint and cleaning powders.',
    id: '69',
    veg: '1',
    name: 'Calcium carbonate',
    info: 'Chalk. Used as a white colour. As it is an alkali, it may be also used to regulate the pH of foods such as canned fruits and vegetables.',
    code: '170',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/170',
    function: 'food coloring',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, sald dressings.',
    id: '33',
    veg: '0',
    name: 'Oxidised starch',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1404',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1404',
    function: 'thickening agent',
  },
  {
    notice:
      'Known to causes nettle rash and aggravate asthma. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Beer, fruit juice, yoghurt, soft drinks.',
    id: '82',
    veg: '0',
    name: 'Sodium benzoate',
    info: 'Prevents the growth of microbes in acidic environments.',
    code: '211',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/211',
    function: 'preservative',
  },
  {
    notice:
      'This substance was evaluated for acceptable daily intake for man (ADI) by the Joint FAO/WHO Expert Committee on Food Additives in 1969 and 1971',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '38',
    veg: '0',
    name: 'Acetylated distarch phosphate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1414',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1414',
    function: 'emulsifier; thickening agent',
  },
  {
    notice:
      'Has no maximum recommended daily intake and is not subject to any prohibitions.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Used for dyeing waxes and oils, used in medicines and cosmetics eg in chewing gum, fats and oils, ice cream, soaps, soups, sweets and, obviously, green vegetables.',
    id: '32',
    veg: '0',
    name: 'Chlorophylls and chlorophyllins',
    info: 'A fairly unstable dye, which tends to fade easily.',
    code: '140',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/140',
    function: 'food coloring (green)',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Bacon burgers, desserts, ice cream, jams, jellies, liquorice, oxtail soup, sauces and sweets.',
    id: '67',
    veg: '0',
    name: 'Beetroot Red; Betanin',
    info: 'purple color derived from beets',
    code: '162',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/162',
    function: 'food coloring',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods:
      'Black cherry yoghurt, dairy products, glacé cherries, ice cream, jellies, pickles, soft drinks, tomato, carrot or vegetable soups and sweets.',
    id: '68',
    veg: '0',
    name: 'Anthocyanins',
    info: 'Red-blue colours that are obtained from a variety of plant sources, especially grapes and red cabbage.',
    code: '163',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/163',
    function: 'food coloring',
  },
  {
    id: '8',
    code: '106',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '1',
    name: 'Riboflavin-5-Sodium Phosphate',
    status: 'Safe',
    veg: '',
    function: 'food coloring (yellow)',
    foods: '',
    notice:
      'safe for all animal species with a margin of safety of about 10–20 compared to the supplementation level in water for drinking.',
    info: 'Similar to E101a.',
    url: 'http://e-additives.herokuapp.com/additives/106',
  },
  {
    id: '50',
    code: '150c',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Ammonia caramel',
    status: 'Warning',
    veg: '0',
    function: 'food coloring',
    foods: '',
    notice: '',
    info: 'Caramel coloring, when produced with ammonia, contains the contaminants 2-methylimidazole and 4-methylimidazole. In 2007, studies by the U.S. National Toxicology Program found that those two contaminants cause cancer in male and female mice and possibly in female rats.',
    url: 'http://e-additives.herokuapp.com/additives/150c',
  },
  {
    notice:
      'Found to accumulate on the retina, having a detrimental effect on eyesight.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Used in such products as chicken in breadcrumbs, fish fingers, mallow biscuits, pickles and preserves, sauces and sweets it is also fed to laying hens to make to colour egg yolks.',
    id: '66',
    veg: '0',
    name: 'Canthaxanthin',
    info: 'Yellow color, historically it was prepared from shrimp waste or flaming feathers. Synthetic cantaxanthin is cheaper and has higher purity.',
    code: '161g',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/161g',
    function: 'food coloring',
  },
  {
    notice:
      'Forbidden (Banned in Europe since 1984. In the US, it was banned in 1988.)',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:30+0300',
    foods: '',
    id: '5',
    veg: '',
    name: 'Chrysoine resorcinol',
    info: 'Formerly used as food additive. Synthetic azo dye.',
    code: '103',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/103',
    function: 'food coloring (golden)',
  },
  {
    notice:
      'Banned in Australia, Austria, Belgium, Denmark, France, Germany, Norway, Sweden, Switzerland and USA. Bad reactions in asthmatics and people allergic to aspirin, also known to induce skin sensitivity. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Chocolate cake mixes.',
    id: '58',
    veg: '0',
    name: 'Brown HT',
    info: "A brown synthetic 'coal tar' and azo dye found mainly in chocolate flavour cakes.",
    code: '155',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/155',
    function: 'food coloring',
  },
  {
    notice: 'Dangerous additives for health',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Frozen chips, beer and wine.',
    id: '95',
    veg: '0',
    name: 'Potassium metabisulphite',
    info: 'Prevents microbial growth, especially used in home brewing and wine making.',
    code: '224',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/224',
    function: 'preservative',
  },
  {
    notice:
      'Not permitted. People who suffer from asthma, rhinitis or the skin disease urticaria may find their symptoms become worse following consumption of azo dyes.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Exterior of hard cheese.',
    id: '75',
    veg: '0',
    name: 'Pigment Rubine; Lithol Rubine BK',
    info: 'Red synthetic colour.',
    code: '180',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/180',
    function: 'food coloring',
  },
  {
    notice:
      'Unpermitted (Banned in Norway and USA). It appears to cause allergic and/or intolerance reactions particularly amongst those with an aspirin intolerance or asthmatics. Carcinogen in animals. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Sessert toppings, jelly, salami, seafood dressings, tinned strawberries and fruit pie fillings and packeted cake mixes, cheesecakes, soups and trifles.',
    id: '22',
    veg: '0',
    name: 'Ponceau 4R; Cochineal Red A, Brilliant Scarlet 4R',
    info: 'A red synthetic coal tar or azo dye.',
    code: '124',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/124',
    function: 'food coloring (red)',
  },
  {
    notice:
      'The U.S. Food and Drug Administration (FDA) does not have the authority to review dietary supplement products for safety and effectiveness before they are marketed.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Dietary food supplement (tablets).',
    id: '17',
    veg: '0',
    name: 'Polyvinylpyrrolidone',
    info: 'Carriers are substances that can be used to contain another additive.',
    code: '1201',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1201',
    function: 'stabiliser',
  },
  {
    notice:
      'Not permitted. Long, regular consumption can lead to kidney damage and a blue-grey discoloration of the eyes, nose and nasal septum, throat and skin.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Used solely for external decoration.',
    id: '73',
    veg: '0',
    name: 'Silver',
    info: 'Silver coloured surface coating.',
    code: '174',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/174',
    function: 'food coloring',
  },
  {
    notice:
      'Dangerous (Banned in Australia, USA and Norway.) Best avoided by people with allergy reactions as it can cause skin sensitivity, a rash similar to nettle rash, itching, nausea, low blood pressure, tremors and breathing problems.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:30+0300',
    foods:
      'Not widely used but can be found in Scotch eggs and is used diagnostically to colour lymph vessels.',
    id: '29',
    veg: '0',
    name: 'Patent Blue V',
    info: 'A dark bluish-violet synthetic coal tar dye.',
    code: '131',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/131',
    function: 'food coloring (dark blue)',
  },
  {
    notice:
      'Known to cause urticaria (nettle rash), the HACSG recommends to avoid it.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Cheese, coleslaw, crisps, custard, fish fingers, flavoured instant mashed potato, fruit and cream fillings and toppings, frying oil, ice cream and lollies, icings, liqueurs, low calorie spreads, margarine, meat balls, salad cream and mayonnaise, smoked fish, soft drinks, sponge cakes and puddings, steak and kidney pie pastry and yoghurt.',
    id: '60',
    veg: '1',
    name: 'Annatto; Bixin; Norbixin',
    info: 'A yellow, peach or red vegetable dye obtained from the seed coat of the fruit of the Annatto tree, Bixa orellana.',
    code: '160b',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/160b',
    function: 'food coloring',
  },
  {
    id: '89',
    code: '218',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Methyl p-hydroxybenzoate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Beer, fruit juices, preserves.',
    notice:
      'Not permitted in France and Australia. Allergic reactions possible, mainly affecting the skin.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/218',
  },
  {
    notice:
      'The preservative calcium sorbate is to be banned in the European Union due to a lack of safety data.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Ice cream, yoghurt, fruit juice.',
    id: '80',
    veg: '0',
    name: 'Calcium sorbate',
    info: 'Helps to prevent the growth of microbes on food. Related to Sorbic acid (E200). Effective in a wide range of foods. Does not have any flavour or taste.',
    code: '203',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/203',
    function: 'preservative',
  },
  {
    id: '11',
    code: '1100',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Amylase',
    status: 'Safe',
    veg: '1',
    function: 'stabiliser; flavour enhancer',
    foods: '',
    notice:
      'The food enzyme does not contain the production organism or recombinant DNA ; therefore, there is no safety concern for the environment.',
    info: 'Derived from mould mushroom or pig pancreas.',
    url: 'http://e-additives.herokuapp.com/additives/1100',
  },
  {
    notice:
      'Unpermitted (Banned in Norway and USA.) Because food processing at temperatures above 200°c partly degrades Erythrosine, releasing iodide, there are fears that it could affect thyroid activity, can increase thyroid hormone levels and lead to hyperthyroidism, was shown to cause thyroid cancer in rats in a study in 1990. It is toxic to some strains of yeast cells and is also implicated in phototoxicity (a sensitivity to light). Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Cocktail, glacé and tinned cherries, canned fruit, custard mix, sweets, bakery, snack foods, biscuits, chocolate, dressed crab, garlic sausage, luncheon meat, salmon spread, paté, scotch eggs, stuffed olives and packet trifle mix. It is also used to reveal plaque in dental disclosing tablets.',
    id: '25',
    veg: '0',
    name: 'Erythrosine (FD&C Red 3)',
    info: 'A cherry-pink/red synthetic coal tar dye.',
    code: '127',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/127',
    function: 'food coloring (red)',
  },
  {
    notice: 'Difficult for babies to metabolize.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Sweets, dressings, soft drinks (sometimes beer) infant formulas and confectionary.',
    id: '119',
    veg: '0',
    name: 'Lactic acid',
    info: 'Made by bacterial fermentation on sugar waste (molasses).',
    code: '270',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/270',
    function: 'preservative',
  },
  {
    notice:
      'Some people may have an allergic reaction to potassium sorbate in foods. These allergies are rare. Allergies to potassium sorbate are more common with cosmetics and personal products, where it can cause skin or scalp irritation.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Ice cream, yoghurt, cheese, wine.',
    id: '79',
    veg: '0',
    name: 'Potassium sorbate',
    info: 'Helps to prevent the growth of microbes on food. Related to Sorbic acid (E200). Effective in a wide range of foods. Does not have any flavour or taste.',
    code: '202',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/202',
    function: 'preservative',
  },
  {
    id: '88',
    code: '217',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Sodium propyl p-hydroxybenzoate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Fruit juices',
    notice:
      'Forbidden. (Not permitted in Australia.) Avoid it, banned in some countries.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/217',
  },
  {
    notice:
      'Studies in healthy human volunteers with phosphated distarch phosphate (E 1413), acetylated distarch phosphate (E 1414) and acetylated starch (E 1420) reported no adverse effects at doses of 60,000 mg/person.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '36',
    veg: '0',
    name: 'Distarch phosphate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1412',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1412',
    function: 'stabiliser; thickening agent',
  },
  {
    notice:
      'Forbidden. Indanthrene Blue RS was patented in 1901 by Rene Bohn as the first anthraquinone vat dye, one of the dyes with very good fastness to light and washing.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: '',
    id: '28',
    veg: '',
    name: 'Indanthrene blue RS',
    info: 'Indanthrene Blue RS was patented in 1901 by Rene Bohn as the first anthraquinone vat dye, one of the dyes with very good fastness to light and washing. It is used to dye unmordanted cotton and as a pigment in quality paints and enamels.',
    code: '130',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/130',
    function: 'food coloring (blue)',
  },
  {
    notice: 'Forbidden in Australia. A possible skin irritant.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Drinks, dairy products, fish, seafood, fat-based products, baked foods and confectionery.',
    id: '77',
    veg: '0',
    name: 'Sorbic acid',
    info: 'Either obtained from berries or synthesised from ketene.',
    code: '200',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/200',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '45',
    veg: '0',
    name: 'Starch sodium octenyl succinate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1450',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1450',
    function: 'stabiliser; emulsifier; thickening agent',
  },
  {
    id: '85',
    code: '214',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Ethyl p-hydroxybenzoate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Beer, fruit juices, preserves.',
    notice:
      'Dangerous (Not permitted in France and Australia.) Avoid it, banned in some countries.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/214',
  },
  {
    id: '90',
    code: '219',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Sodium methyl p-hydroxybenzoate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Beer, fruit juices, preserves.',
    notice:
      'Not permitted in France and Australia. Avoid it, banned in some countries.',
    info: 'Prevents the growth of microbes, especially fungi.',
    url: 'http://e-additives.herokuapp.com/additives/219',
  },
  {
    notice:
      'Banned in Norway. People with allergies should avoid it. May cause nausea, vomiting, high blood pressure, skin rashes, breathing problems and other allergic reactions.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Commonly added to tablets and capsules; also used in ice cream, sweets, baked goods, confectionery, biscuits. It is also used diagnostically to check for coloured urine in kidney function tests.',
    id: '30',
    veg: '1',
    name: 'Indigo carmine; FD&C Blue 2',
    info: 'A blue synthetic coal tar dye, normally produced by a synthesis of indoxyl by fusion of sodium phenylglycinate in a mixture of caustic soda and sodamide.',
    code: '132',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/132',
    function: 'food coloring (reddish blue)',
  },
  {
    id: '116',
    code: '262',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '2',
    name: 'Sodium acetate; Sodium diacetate',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: 'Bread, crisps.',
    notice: '',
    info: 'Food acid, acidity regulator.',
    url: 'http://e-additives.herokuapp.com/additives/262',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '41',
    veg: '0',
    name: 'Acetylated distarch adipate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it.',
    code: '1422',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1422',
    function: 'stabiliser; thickening agent',
  },
  {
    notice:
      'Known to provoke asthma attacks, difficult to metabolize, destroys vitamin B1. The HACSG recommends to avoid it.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Fruit juices, beers, wines, dried vegetables, sausages.',
    id: '91',
    veg: '0',
    name: 'Sulphur dioxide',
    info: 'One of the earliest preservatives known to humans. Sulfur dioxide has been used for centuries to prevent the growth of bacteria in beers and wines. It can be used in many situations to prevent microbial growth.',
    code: '220',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/220',
    function: 'preservative',
  },
  {
    notice:
      'Dangerous (Not permitted in Australia.) Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Oranges, lemons and limes.',
    id: '100',
    veg: '0',
    name: 'Orthophenyl phenol',
    info: 'Prevents the growth of microbes. Applied to the surface of fruits or their wrappings.',
    code: '231',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/231',
    function: 'preservative',
  },
  {
    notice: 'HACSG recommends to avoid it.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Beer, brown bread, buns, chocolate, biscuits, brandy, chocolate flavoured flour based confectionery, coatings, decorations, fillings and toppings, crisps, dessert mixes, doughnuts, fish and shellfish spreads, frozen desserts, glucose tablets, gravy browning, ice cream, jams, milk desserts, pancakes, pickles, sauces and dressings, soft drinks particularly cola drinks, stouts, sweets, vinegar, whisky and wines.',
    id: '48',
    veg: '0',
    name: 'Plain caramel',
    info: 'Made by controlled heat treatment of sugar beet or sugar cane (with or without the presence of alkalis or acids). The caramel group of colours are the most widely used group of colours, comprising some 98% of all colours used.',
    code: '150a',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/150a',
    function: 'food coloring (range from dark brown to black)',
  },
  {
    notice:
      'Banned in USA. Still used in Australia. Suspected as a carcinogenic agent. Vegetarians should note that it can be of animal origin.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Concentrated fruit juices, jams, jellies and liquorice.',
    id: '56',
    veg: '0',
    name: 'Vegetable carbon',
    info: 'It is normally derived from burnt vegetable matter.',
    code: '153',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/153',
    function: 'food coloring',
  },
  {
    notice: 'May come from Genetically Modified sources.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Found in most foods, it is abundant in, amongst other things, whole grain cereals, corn and cottonseed oils, egg yolks, meat and milk.',
    id: '134',
    veg: '0',
    name: 'Tocopherols',
    info: 'Vitamin E, known as the anti-sterility vitamin. Reduces oxidation of fatty acids and some vitamins. Commercially it can be extracted, by distillation in a vacuum, from cottonseed, maize, rice germ, soya been oil, wheat germ, or green leaves.',
    code: '306',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/306',
    function: 'antioxidant',
  },
  {
    notice:
      'Polydextrose is likely safe when used as a food additive, provided a serving contains less than 15 grams of polydextrose. ',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Baked products, chewing gum, dairy desserts, sweets.',
    id: '16',
    veg: '0',
    name: 'Polydextrose',
    info: 'Polydextrose is a low-calorie thickener that can help to replace sugars and fats.',
    code: '1200',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1200',
    function: 'stabiliser; thickener',
  },
  {
    notice: 'Not permitted (Permitted in UK.)',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Found mainly in kippers and smoked mackerel but also occasionally in cooked hams and crisps.',
    id: '57',
    veg: '0',
    name: 'Brown FK',
    info: 'A highly suspect brown mixture of six synthetic azo dyes together with other colourings and sodium chloride and/or sodium sulphate.',
    code: '154',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/154',
    function: 'food coloring',
  },
  {
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Beers, jam.',
    id: '97',
    veg: '0',
    name: 'Calcium hydrogen sulphite',
    info: 'Used in brewing and wine making to sterilise equipment and prevent microbial growth.',
    code: '227',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/227',
    function: 'preservative',
  },
  {
    id: '23',
    code: '125',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '1',
    name: 'Ponceau SX; Scarlet GN',
    status: 'Hazard',
    veg: '',
    function: 'food coloring (red)',
    foods: '',
    notice: 'Forbidden.',
    info: 'A red azo dye.',
    url: 'http://e-additives.herokuapp.com/additives/125',
  },
  {
    id: '51',
    code: '150d',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Sulphite ammonia caramel',
    status: 'Warning',
    veg: '0',
    function: 'food coloring',
    foods: '',
    notice: '',
    info: 'Caramel coloring, when produced with ammonia, contains the contaminants 2-methylimidazole and 4-methylimidazole. In 2007, studies by the U.S. National Toxicology Program found that those two contaminants cause cancer in male and female mice and possibly in female rats.',
    url: 'http://e-additives.herokuapp.com/additives/150d',
  },
  {
    notice:
      'Ingestion is harmful and may be fatal. Harmful by inhalation. An irritant. May cause congenital malformation in the foetus. Laboratory tests with animals suggest this material may cause reproductive disorders.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Caviar.',
    id: '124',
    veg: '',
    name: 'Boric acid',
    info: 'Used on the surface to prevent spoilage.',
    code: '284',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/284',
    function: 'preservative',
  },
  {
    id: '62',
    code: '160d',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '1',
    name: 'Lycopene',
    status: 'Safe',
    veg: '1',
    function: 'food coloring',
    foods: 'Canned tomatoes.',
    notice: 'Not permitted in Australia.',
    info: 'A red colour extracted from tomatoes and pink grapefruit.',
    url: 'http://e-additives.herokuapp.com/additives/160d',
  },
  {
    notice:
      'Taking big doses of vitamin A can be toxic, but your body only converts as much vitamin A from beta-carotene as it needs. That means beta-carotene is considered a safe source of vitamin A. However, too much beta-carotene can be dangerous for people who smoke.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Butter and soft margarines, coffee sponge cakes, milk products and soft drinks.',
    id: '59',
    veg: '1',
    name: 'Carotenes',
    info: 'Orange or yellow plant pigments. Converts to vitamin A in the body.',
    code: '160a',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/160a',
    function: 'food coloring',
  },
  {
    notice:
      'Permitted in the US and by the EU (Banned in Denmark, Belgium, France, Switzerland & Sweden. Undergoing a voluntary phase out in the UK.) May have slightly less allergy/intolerance reaction by aspirin intolerant people and asthmatics than most of the azo dyes, although those with skin sensitivities should be careful. Allura red has also been connected with cancer in mice. Not recommended for consumption by children.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:30+0300',
    foods: 'Sweets, drinks and condiments, medications and cosmetics.',
    id: '27',
    veg: '0',
    name: 'Allura Red AC (FD&C Red 40)',
    info: 'A red synthetic azo dye introduced in the early eighties to replace Amaranth, E123, in USA where E123 is prohibited.',
    code: '129',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/129',
    function: 'food coloring (red)',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '35',
    veg: '0',
    name: 'Monostarch phosphate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1410',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1410',
    function: 'stabiliser; thickening agent',
  },
  {
    id: '98',
    code: '228',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Potassium hydrogen sulphite',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Hamburgers, sausages, beer, dried potatoes.',
    notice: 'Dangerous additives for health.',
    info: 'Slows the growth of food-spoiling micro-organisms.',
    url: 'http://e-additives.herokuapp.com/additives/228',
  },
  {
    id: '112',
    code: '251',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Sodium nitrate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Processed meats, cheese, pizza.',
    notice: 'Dangerous for health.',
    info: 'Reduces the growth of toxic micro-organisms in meat.',
    url: 'http://e-additives.herokuapp.com/additives/251',
  },
  {
    notice:
      "There are no adverse safety warnings regarding Hydroxypropyl Starch Phosphate, as long as it's used in concentrations between 3 and 10% as recommended by the CIR.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '43',
    veg: '0',
    name: 'Hydroxyl propyl starch',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1440',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1440',
    function: 'emulsifier; thickening agent',
  },
  {
    id: '49',
    code: '150b',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Caustic sulphite caramel',
    status: 'Warning',
    veg: '0',
    function: 'food coloring',
    foods: '',
    notice: '',
    info: 'Caramel coloring, when produced with ammonia, contains the contaminants 2-methylimidazole and 4-methylimidazole. In 2007, studies by the U.S. National Toxicology Program found that those two contaminants cause cancer in male and female mice and possibly in female rats.',
    url: 'http://e-additives.herokuapp.com/additives/150b',
  },
  {
    id: '109',
    code: '242',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Dimethyl dicarbonate',
    status: 'Safe',
    veg: '',
    function: 'preservative',
    foods: 'Fruit juices, beers, wines',
    notice: '',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/242',
  },
  {
    id: '72',
    code: '173',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '1',
    name: 'Aluminium',
    status: 'Hazard',
    veg: '0',
    function: 'food coloring',
    foods: 'Used solely for external decoration.',
    notice: 'Not Permitted. Potentially toxic.',
    info: 'Silvery-white metal smelted from the ore, Bauxite.',
    url: 'http://e-additives.herokuapp.com/additives/173',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Beers, cut fruits, jams, dried potato.',
    id: '129',
    veg: '0',
    name: 'Ascorbic acid',
    info: 'Helps to prevent cut and pulped foods from going brown by preventing the oxidation reactions that cause the discolouration. Can be added to foods, such as potato, to replace vitamin C lost in processing.',
    code: '300',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/300',
    function: 'antioxidant',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Ice cream, pizza, battered fish, salad dressings.',
    id: '44',
    veg: '0',
    name: 'Hydroxyl propyl distarch phosphate',
    info: 'Modified starches form gels when added to foods. This thickens the food without having to heat it. They can also be used to help stabilise oily foods. The starch helps to emulsify the fats and so prevent the fat separating out.',
    code: '1442',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1442',
    function: 'stabiliser; thickening agent',
  },
  {
    id: '121',
    code: '281',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '2',
    name: 'Sodium propionate',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: 'Bread, cheese.',
    notice: 'Linked to migraines.',
    info: 'Prevents the growth of bacteria in breads.',
    url: 'http://e-additives.herokuapp.com/additives/281',
  },
  {
    id: '103',
    code: '234',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Nisin',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: 'Cheese.',
    notice:
      'there were no obvious effects observed for concentrations <83.25 mg/kg in humans and <66.7 mg/kg in mouse.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/234',
  },
  {
    id: '54',
    code: '1518',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Glyceryl triacetate, triacetin',
    status: 'Safe',
    veg: '1',
    function: 'humectant',
    foods: 'Baked foods and mixes, soft drinks, chewing gum and sweets.',
    notice:
      ' Triacetin was not toxic to animals in acute oral or dermal exposures, nor was it toxic in short-term inhalation or parenteral studies, and subchronic feeding and inhalation studies.',
    info: 'Helps to prevent the food it is added to from drying out.',
    url: 'http://e-additives.herokuapp.com/additives/1518',
  },
  {
    id: '87',
    code: '216',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Propyl p-hydroxybenzoate',
    status: 'Warning',
    veg: '',
    function: 'preservative',
    foods: 'Beer, sauces, fruit juices, salad cream.',
    notice: 'Forbidden. Possible contact allergen.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/216',
  },
  {
    notice:
      'Banned in Japan. Not permitted in infant foods, allergic reaction, may trigger hyperactivity, concerns over carcinogenicity and estrogenic effects.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods:
      'Used in edible oils, chewing gum, fats, margarine, nuts, instant potato products, polyethylene food wraps.',
    id: '146',
    veg: '0',
    name: 'Butylated hydroxyanisole (BHA)',
    info: 'Petroleum derivative, retards spoilage due to oxidation; helps to prevent oxidations that cause oils and fats to become rancid.',
    code: '320',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/320',
    function: 'antioxidant',
  },
  {
    id: '123',
    code: '283',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Potassium propionate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Bread, cheese.',
    notice: 'Linked to migraines.',
    info: 'Prevents the growth of bacteria in breads.',
    url: 'http://e-additives.herokuapp.com/additives/283',
  },
  {
    notice:
      'up to 20 mg per day of a lutein supplement should be safe for adults. There is no evidence available to determine a safe lutein supplement dose in children.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Eggs',
    id: '65',
    veg: '0',
    name: 'Lutein',
    info: 'Yellow-red colour extracted from plants. related to the carotenes (E160a). Can be added to chicken feed to enhance colour of egg yolk.',
    code: '161b',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/161b',
    function: 'food coloring',
  },
  {
    id: '53',
    code: '1510',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '9',
    name: 'Ethanol',
    status: 'Hazard',
    veg: '0',
    function: 'Distribute food coloring, flavour enhancer.',
    // For example, vanilla extract, a common food flavoring, is made by curing and processing vanilla beans in a solution of ethanol and water.
    foods: '',
    notice:
      'While ethanol is consumed when drinking alcoholic beverages, consuming ethanol alone can cause coma and death. Ethanol may also be a carcinogenic.',
    info: ' In the United States, the Food and Drug Administration (FDA) only allows vanilla to be called “extract” when it has an alcohol or ethanol base.',
    url: 'http://e-additives.herokuapp.com/additives/1510',
  },
  {
    notice:
      'Possible risk that this may cause reproductive disorders, based on tests with laboratory animals. Eye and skin irritant. Harmful by ingestion. May be harmful by inhalation.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Caviar.',
    id: '125',
    veg: '',
    name: 'Sodium tetraborate; borax',
    info: 'Used on the surface to prevent spoilage.',
    code: '285',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/285',
    function: 'preservative',
  },
  {
    notice: "Banned in Germany. Toxic at 'high doses'.",
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Cake and dessert mixes, meat paste, salmon and shrimp paste.',
    id: '71',
    veg: '',
    name: 'Iron oxides and hydroxides',
    info: 'Naturally occurring pigments of iron, which can be yellow, red, orange, brown or black in colour.',
    code: '172',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/172',
    function: 'food coloring',
  },
  {
    id: '143',
    code: '317',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Erythorbic acid',
    status: 'Safe',
    veg: '0',
    function: 'antioxidant',
    foods: '',
    notice:
      'The Panel noted that the acute toxicity of erythorbic acid or sodium erythorbate is low, there was no indication of adverse effects from the available subchronic toxicity studies, there is no concern with respect to their genotoxicity neither to respect to carcinogenicity.',
    info: 'Produced from sucrose.',
    url: 'http://e-additives.herokuapp.com/additives/317',
  },
  {
    notice: 'Safe but pollutes waterways.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Tablets and capsules, cottage and Mozzarella cheeses, horseradish cream and sauces, lemon curd, toothpaste, and white paint, also in sweets.',
    id: '70',
    veg: '',
    name: 'Titanium dioxide',
    info: 'White, mineral-based colour.',
    code: '171',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/171',
    function: 'food coloring (pure white)',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Oranges, lemons and limes.',
    id: '101',
    veg: '0',
    name: 'Sodium orthophenyl phenol',
    info: 'Prevents the growth of microbes. Applied to the surface of fruits or their wrappings.',
    code: '232',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/232',
    function: 'preservative',
  },
  {
    id: '132',
    code: '303',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Potassium ascorbate',
    status: 'Safe',
    veg: '0',
    function: 'antioxidant',
    foods: '',
    notice:
      "Studies using dilutions similar to what's used in body care products found it's practically non-irritating and non-sensitizing.",
    info: 'Potassium salt of vitamin C.',
    url: 'http://e-additives.herokuapp.com/additives/303',
  },
  {
    notice: 'May come from Genetically Modified sources.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Found in most foods, it is abundant in, amongst other things, whole grain cereals, corn and cottonseed oils, egg yolks, meat and milk.',
    id: '137',
    veg: '0',
    name: 'Delta-tocopherol',
    info: 'Vitamin E, known as the anti-sterility vitamin. E309 is an antioxidant for polyunsaturated fatty acids as well as a vitamin. Reported to be the most effective antioxidant of all the tocopherols in non-biological matter. It also protects other nutrients, such as Vitamin A, from oxidation but is largely destroyed by freezing.',
    code: '309',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/309',
    function: 'antioxidant',
  },
  {
    id: '174',
    code: '357',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Potassium adipate',
    status: 'Safe',
    veg: '0',
    function: 'pH regulator',
    foods: 'Cake fillings and toppings, dessert mixes.',
    notice: '',
    info: 'Helps to maintain the correct level of acidity for the food.',
    url: 'http://e-additives.herokuapp.com/additives/357',
  },
  {
    notice:
      'Banned in Denmark, Australia, Austria, Belgium, Canada, Finland, France, Germany, Japan, Norway, Switzerland, Sweden, USA and Norway. Not recommended for consumption by children. HACSG recommends to avoid it.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Used in decorations and coatings, desserts, fish paste, flavoured milk drinks, ice cream, mustard, red fruit jams, sauces, savoury snacks, soft drinks, soups and sweets.',
    id: '52',
    veg: '0',
    name: 'Black PN; Brilliant Black BN',
    info: 'A violet/black synthetic coal tar and azo dye.',
    code: '151',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/151',
    function: 'food coloring',
  },
  {
    notice:
      'Dangerous additives for health. May cause dizzynesss, headaches, difficult breathing,potential carcinogen.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Cooked meats',
    id: '110',
    veg: '0',
    name: 'Potassium nitrite',
    info: 'Prevents the growth of the botulism bacteria (Clostridium botulinum) in meat.',
    code: '249',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/249',
    function: 'preservative',
  },
  {
    id: '105',
    code: '236',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '2',
    name: 'Formic acid',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    info: 'The concentrated acid is corrosive to the skin. Formic acid is readily metabolized and eliminated by the body. Nonetheless, it has specific toxic effects; the formic acid and formaldehyde produced as metabolites of methanol are responsible for the optic nerve damage, causing blindness, seen in methanol poisoning.',
    url: 'http://e-additives.herokuapp.com/additives/236',
  },
  {
    id: '74',
    code: '175',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '1',
    name: 'Gold',
    status: 'Warning',
    veg: '0',
    function: 'food coloring',
    foods: 'Used solely for external decoration.',
    notice: 'Not permitted in Australia. Harmless, but best avoided.',
    info: 'Gold coloured surface coating.',
    url: 'http://e-additives.herokuapp.com/additives/175',
  },
  {
    id: '141',
    code: '315',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '3',
    name: 'Erythorbic acid',
    status: 'Safe',
    veg: '',
    function: 'antioxidant',
    foods: 'Brewing process.',
    notice:
      'The Panel noted that the acute toxicity of erythorbic acid or sodium erythorbate is low, there was no indication of adverse effects from the available subchronic toxicity studies, there is no concern with respect to their genotoxicity neither to respect to carcinogenicity.',
    info: 'Derived from ascorbic acid (vitamin C).',
    url: 'http://e-additives.herokuapp.com/additives/315',
  },
  {
    notice:
      'Dangerous (Not permitted in Australia.) Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Fruits',
    id: '99',
    veg: '0',
    name: 'Biphenyl; diphenyl',
    info: 'Prevents the growth of moulds such as Penicillium sp. on the surface of fruits.',
    code: '230',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/230',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Biscuits, canned fish, cheese and processed cheese products, infant formulas, cake and soup mixes, rye bread, soft drinks, fermented meat products.',
    id: '154',
    veg: '0',
    name: 'Citric acid',
    info: 'Naturally-occuring in citrus fruits like lemons. Helps to increase the anti-oxidant effects of other substances. Helps to reduce the reactions that can discolour fruits. May also be used to regulate pH in jams and jellies.',
    code: '330',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/330',
    function: 'antioxidant',
  },
  {
    notice:
      'May cause nausea, vomiting, delirium. A dose of 5g is considered fatal.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Fats, oils, margarine.',
    id: '145',
    veg: '0',
    name: 'Tert-ButylHydroQuinone (TBHQ)',
    info: 'Petroleum based.',
    code: '319',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/319',
    function: 'antioxidant',
  },
  {
    id: '86',
    code: '215',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Sodium ethyl p-hydroxybenzoate',
    status: 'Warning',
    veg: '0',
    function: 'preservative',
    foods: 'Fruit juices',
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/215',
  },
  {
    notice:
      "Early research suggests that tea tannins may provide health benefits due to their antioxidant and anti-inflammatory effects. However, more research is needed. Tea tannins may cause nausea, especially if consumed on an empty stomach. They may also hinder your body's ability to absorb iron from certain foods.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Clarifying agent in alcohol.',
    id: '76',
    veg: '0',
    name: 'Tannin',
    info: 'Derived from the nutgalls and twigs of oak trees; occurs naturally in tea.',
    code: '181',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/181',
    function: 'food coloring',
  },
  {
    notice:
      'At doses in excess of 1,000 mg per day can cause liver damage, diabetes, gastritis, eye damage, and elevated blood levels of uric acid (which can cause gout); at amounts as low as 50-100 mg may cause flushing (harmless but painful), headache, and stomach-ache especially if taken on an empty stomach.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Naturally occurs in bean, pea and other legumes, milk, egg, meat, poultry, and fish.',
    id: '177',
    veg: '0',
    name: 'Niacin',
    info: 'Vitamin B3.',
    code: '375',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/375',
    function: 'colour retention agent',
  },
  {
    notice: 'Dangerous additives for health.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Meats, beer, wine.',
    id: '92',
    veg: '0',
    name: 'Sodium sulphite',
    info: 'Similar in action to sulfur dioxide. Sodium sulfite is regularly used in brewing and wine making to sterilise equipment. In foods it prevents microbial growth (especially salmonella). It also prevents the discolouration of meat, peeled apples and potatoes.',
    code: '221',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/221',
    function: 'preservative',
  },
  {
    notice:
      'Not permitted. Can cause asthma, hyperactivity in children. The HACSG recommends to avoid it.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Beer, fruit juice, yoghurt, soft drinks.',
    id: '81',
    veg: '1',
    name: 'Benzoic acid',
    info: 'Prevents the growth of microbes in acidic environments.',
    code: '210',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/210',
    function: 'preservative',
  },
  {
    id: '83',
    code: '212',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Potassium benzoate',
    status: 'Warning',
    veg: '0',
    function: 'preservative',
    foods: 'Fruit juice concentrate and margarine.',
    notice: 'People with a history of allergies may show allergic reactions.',
    info: 'Prevents the growth of microbes in acidic environments.',
    url: 'http://e-additives.herokuapp.com/additives/212',
  },
  {
    notice:
      'Young children with lactose intolerance may show adverse reactions.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Dairy products.',
    id: '149',
    veg: '0',
    name: 'Sodium lactate',
    info: 'Derived from milk (lactic acid). Commercially only prepared from sugar. Helps to increase the anti-oxidant activity of other substances.',
    code: '325',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/325',
    function: 'antioxidant',
  },
  {
    notice: 'May come from Genetically Modified sources.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Sausages.',
    id: '135',
    veg: '0',
    name: 'Alpha-tocopherol',
    info: 'Vitamin E, known as the anti-sterility vitamin. Reduces oxidation of fatty acids and some vitamins. Commercially it can be extracted, by distillation in a vacuum, from cottonseed, maize, rice germ, soya been oil, wheat germ, or green leaves.',
    code: '307',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/307',
    function: 'antioxidant',
  },
  {
    notice: 'Dangerous additives for health.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Fruit juices, beers, wines, frozen chips.',
    id: '93',
    veg: '0',
    name: 'Sodium hydrogen sulphite',
    info: 'Used to prevent the growth of bacteria in beers and wines. It can be used in many situations to prevent microbial growth.',
    code: '222',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/222',
    function: 'preservative',
  },
  {
    notice:
      'Sodium ascorbate produces cytotoxic effect in an array of malignant cell lines, which include melanoma cells that are particularly susceptible.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Processed meats, sausages, baby foods.',
    id: '130',
    veg: '0',
    name: 'Sodium ascorbate',
    info: 'Helps to prevent oxidation reactions that can discolour foods. Sodium salt of vitamin C.',
    code: '301',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/301',
    function: 'antioxidant',
  },
  {
    id: '222',
    code: '465',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Ethyl methyl cellulose',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Processed potato foods.',
    notice:
      'There are some potential disadvantages that are not immediately obvious.',
    info: 'Derived from cellulose, the main component of plant cell walls.',
    url: 'http://e-additives.herokuapp.com/additives/465',
  },
  {
    id: '78',
    code: '201',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '2',
    name: 'Sodium sorbate',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice:
      'There have been a few reported incidents of potassium sorbate side effects over the decades, though most are now from decades ago and from personal care products, not food.',
    info: " Potassium sorbate is a common food preservative that helps extend a food's shelf life.",
    url: 'http://e-additives.herokuapp.com/additives/201',
  },
  {
    id: '147',
    code: '321',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '3',
    name: 'Butylated hydroxytoluene (BHT)',
    status: 'Warning',
    veg: '0',
    function: 'antioxidant',
    foods: 'Oils, margarine, cheese, crisps.',
    notice:
      ' BHT is not a listed carcinogen, but some data have shown that it does cause cancer in animals.',
    info: 'Petroleum derivative.',
    url: 'http://e-additives.herokuapp.com/additives/321',
  },
  {
    notice:
      'Large quantities may cause temporary flatulence or intestinal discomfort.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Jams, yoghurts, ice cream, diet drinks.',
    id: '209',
    veg: '',
    name: 'Pectins',
    info: 'Polysaccharide that is naturally found as a component of plant cell walls.',
    code: '440',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/440',
    function: 'emulsifier',
  },
  {
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Beers, fruit juices.',
    id: '96',
    veg: '0',
    name: 'Calcium sulphite',
    info: 'Used in brewing and wine making to sterilise equipment and prevent microbial growth.',
    code: '226',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/226',
    function: 'preservative',
  },
  {
    notice:
      'High intakes may upset the calcium/phosphorus equilibrium. Should be avoided by certain people, including those with kidney disease.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Sausages, cheese, pork pies.',
    id: '163',
    veg: '0',
    name: 'Sodium phosphates',
    info: 'Helps to improve the texture of foods and also increase the effects of other antioxidants.',
    code: '339',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/339',
    function: 'antioxidant; pH regulator; stabiliser',
  },
  {
    id: '126',
    code: '290',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Carbon dioxide',
    status: 'Warning',
    veg: '0',
    function: 'preservative',
    foods: 'Wine, soft drinks, confectionary.',
    notice: 'May increase the effect of alcohol.',
    info: 'Gas. Propellant, coolant, derived from lime manufacture.',
    url: 'http://e-additives.herokuapp.com/additives/290',
  },
  {
    notice:
      'Kidney stones or other very bad kidney problems have rarely happened in people taking high doses of calcium ascorbate for a long time. The risk may be higher in people who have had kidney problems or kidney stones.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Processed meats, soup.',
    id: '131',
    veg: '0',
    name: 'Calcium ascorbate',
    info: 'Helps to prevent oxidation reactions that can discolour foods. Vitamin C, may increase the formation of calcium oxalate stones.',
    code: '302',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/302',
    function: 'antioxidant',
  },
  {
    id: '84',
    code: '213',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Calcium benzoate',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: 'Pineapple juice concentrate.',
    notice: '',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/213',
  },
  {
    id: '172',
    code: '355',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Adipic acid',
    status: 'Safe',
    veg: '0',
    function: 'acidulant; pH regulator',
    foods: 'Drinks.',
    notice:
      "Although it's found naturally in a few foods, most of the adipic acid found in the food supply is synthetic.",
    info: 'Helps to give fruit drinks the characteristic sharp flavour.',
    url: 'http://e-additives.herokuapp.com/additives/355',
  },
  {
    notice:
      'The following acute (short-term) health effects may occur immediately or shortly after exposure to Fumaric Acid: Contact can irritate and burn the skin and eyes, breathing Fumaric Acid can irritate the nose and throat causing coughing and wheezing. There is no evidence that Fumaric Acid causes cancer in animals.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Yoghurt, jam.',
    id: '128',
    veg: '0',
    name: 'Fumaric acid',
    info: 'Naturally occuring compound. Derived from plants of the genus Fumaria.',
    code: '297',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/297',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jams.',
    id: '169',
    veg: '0',
    name: 'Calcium malate',
    info: 'Helps to maintain the pH in foods containing processed fruits such as jams and marmalade.',
    code: '352',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/352',
    function: 'pH regulator',
  },
  {
    id: '215',
    code: '451',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Triphosphates',
    status: 'Warning',
    veg: '0',
    function: 'pH regulator; emulsifier',
    foods: 'Fish fingers.',
    notice:
      'Since many people consume fast food, processed meats and packaged foods on a daily basis, there is concern that high levels of sodium phosphate can harm the body.',
    info: 'Can also be used to improve the colour of foods.',
    url: 'http://e-additives.herokuapp.com/additives/451',
  },
  {
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods:
      'Citrus fruits, apples, pears, potatoes, bananas, mushrooms, meat, milk.',
    id: '102',
    veg: '0',
    name: 'Thiabendazole',
    info: 'Thiabendazole is classified as a slightly toxic pesticide and carries the signal word CAUTION on the label. Effects of acute overexposure to the fungicide include dizziness, anorexia, nausea, and vomiting.',
    code: '233',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/233',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Frying fat.',
    id: '242',
    veg: '1',
    name: 'Thermally oxidised soya bean oil interacted with mono and diglycerides of fatty acids',
    info: 'Emulsifiers prevent fats from separating out when in a solution.',
    code: '479b',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/479b',
    function: 'emulsifier',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Frozen chipped potatoes, cheese, cake fillings, diet soft drinks, dried potato.',
    id: '223',
    veg: '0',
    name: 'Carboxy methyl cellulose',
    info: 'Derived from cellulose, the main component of plant cell walls.',
    code: '466',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/466',
    function: 'emulsifier',
  },
  {
    notice:
      'The mono- and diglycerides most likely to cause unwanted effects are those containing long-chain saturated fatty acids, especially stearic acid. ',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Cakes, dried potato.',
    id: '229',
    veg: '1',
    name: 'Mono- and diglycerides of fatty acids',
    info: 'Products that fats are broken down into during the digestive process. Produced commercially as an additive.',
    code: '471',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/471',
    function: 'emulsifier',
  },
  {
    id: '127',
    code: '296',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Malic acid',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Carbonated drinks, tinned soups, frozen chips, processed peas.',
    notice: 'Infants and young children should avoid it.',
    info: 'Derived from fruit or synthetic.',
    url: 'http://e-additives.herokuapp.com/additives/296',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jams.',
    id: '168',
    veg: '0',
    name: 'Potassium malate',
    info: 'Helps to maintain the pH in foods containing processed fruits such as jams and marmalade.',
    code: '351',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/351',
    function: 'pH regulator',
  },
  {
    id: '231',
    code: '472b',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Lactic acid esters of mono- and diglycerides of fatty acids',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice:
      'Sometimes consumers are worried that it may do bad to our health due to the trans fatty acids that may in it.',
    info: 'Mono and diglycerides, also called mono- and diglycerides of fatty acids, saturated or unsaturated, are a mixture of monoglycerides (commonly with 40-90%) and diglycerides, and also includes minor amounts of triglycerides.',
    url: 'http://e-additives.herokuapp.com/additives/472b',
  },
  {
    notice:
      'May be harmful if absorbed through the skin. Ingestion: May cause irritation of the digestive tract. May be harmful if swallowed. Inhalation: May cause respiratory tract irritation.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jams, carbonated drinks, tinned fruits, cakes.',
    id: '159',
    veg: '0',
    name: 'Sodium tartrates',
    info: 'Acid that occurs naturally in many fruits. Commercially obtained from grapes during the wine-making process. Reduces the reactions that cause fruits to discolour.',
    code: '335',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/335',
    function: 'antioxidant; pH regulator',
  },
  {
    notice:
      'May provoke hyperactivity and other adverse reactions; potentially carcinogenic; restricted in many countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Meats',
    id: '113',
    veg: '1',
    name: 'Potassium nitrate',
    info: 'Prevents the growth of the bacteria that causes botulism (Clostridium botulinum).',
    code: '252',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/252',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Wine.',
    id: '170',
    veg: '0',
    name: 'Metatartaric acid',
    info: 'Used in the production of wine to remove suspended particles and make the wine clear.',
    code: '353',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/353',
    function: 'sequestrant',
  },
  {
    id: '240',
    code: '477',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Propylene glycol esters of fatty acids',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Cake mixes.',
    notice: '',
    info: 'Derived from petroleum.',
    url: 'http://e-additives.herokuapp.com/additives/477',
  },
  {
    id: '107',
    code: '238',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Calcium formate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice: 'Avoid it, banned in some countries.',
    info: '',
    url: 'http://e-additives.herokuapp.com/additives/238',
  },
  {
    notice:
      'Non toxic but overdose can upset the stomach, kill the appetite and cause profuse sweating.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Chocolates, salad creams, mayonnaise.',
    id: '148',
    veg: '1',
    name: 'Lecithins',
    info: 'Obtained from soya beans, maize, peanuts and egg yolk. As an emulsifier it helps fats and oils to mix. This prevents their separation into separate parts in foods such as chocolate, salad creams and mayonnaise.',
    code: '322',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/322',
    function: 'emulsifier',
  },
  {
    id: '224',
    code: '467',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Sodium carboxy methyl cellulose',
    status: 'Safe',
    veg: '',
    function: 'thickener',
    foods: '',
    notice:
      "Because cellulose gum isn't absorbed or digested, risks such as allergic reaction are very low.",
    info: 'A cellulose derivative which is a beta-(1,4)-D-glucopyranose polymer. It is used as a bulk laxative and as an emulsifier and thickener in cosmetics and pharmaceuticals and as a stabilizer for reagents.',
    url: 'http://e-additives.herokuapp.com/additives/467',
  },
  {
    notice:
      'May cause gastric or skin irritation, blood disorder, methemoglobinemia.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Oils, margarines, butter.',
    id: '138',
    veg: '0',
    name: 'Propyl gallate',
    info: 'Helps to prevent oxidation reactions that can cause oils and fats to become spoiled.',
    code: '310',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/310',
    function: 'antioxidant',
  },
  {
    notice:
      "There are no known harmful side effects from adding it to food, and it's completely legal.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: "High fibre breads, 'diet' snacks, dried foods.",
    id: '218',
    veg: '0',
    name: 'Cellulose',
    info: 'Main component of plant cell walls. It is not digestible by humans and so adds bulk to the food. Also known as fibre or roughoage. Used in brewing to clarify beers.',
    code: '460',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/460',
    function: 'emulsifier',
  },
  {
    notice:
      'Can alter the metabolytical activity in humans; in addition to modified starch, they may cause calcification of the pelvic region in rats; they intensify the activity of heavy metals making them easier to cross the intestine wall; they may contain a lot of impurities; in Japan, a group of children were intoxicated with arsine as impurity of ortophosphate used in food',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Dried foods, desserts.',
    id: '216',
    veg: '0',
    name: 'Polyphosphates',
    info: 'Can also be used to improve the colour of foods and as a raising agent in baking.',
    code: '452',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/452',
    function: 'pH regulator; emulsifier; stabiliser',
  },
  {
    notice: 'May come from Genetically Modified sources.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Found in most foods, it is abundant in, amongst other things, whole grain cereals, corn and cottonseed oils, egg yolks, meat and milk.',
    id: '136',
    veg: '0',
    name: 'Gamma-tocopherol',
    info: 'Vitamin E, known as the anti-sterility vitamin. E308 is an antioxidant for polyunsaturated fatty acids as well as a vitamin.',
    code: '308',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/308',
    function: 'antioxidant',
  },
  {
    id: '241',
    code: '478',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Lactylated fatty acid esters of glycerol and propane',
    status: 'Hazard',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice: '',
    info: 'The fats are mainly from plant origin, but also fats of animal origin may be used. The product generally is a mixture of different components. Emulsifier, stabiliser, whipping agent, plasticiser and surface active agents.',
    url: 'http://e-additives.herokuapp.com/additives/478',
  },
  {
    notice:
      'Potentially carcinogenic, restricted in many countries. The HACSG recommends to avoid it (see 249).',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Cooked meats',
    id: '111',
    veg: '0',
    name: 'Sodium nitrite',
    info: 'Prevents the growth of the botulism bacteria (Clostridium botulinum) in meat.',
    code: '250',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/250',
    function: 'preservative',
  },
  {
    id: '144',
    code: '318',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '3',
    name: 'Sodium erythorbate',
    status: 'Safe',
    veg: '0',
    function: 'antioxidant',
    foods: '',
    notice:
      'Symptoms of exposure to this compound may include eye and skin irritation. Sodium erythorbate may be sensitive to prolonged exposure to light. ',
    info: 'Incompatible with strong oxidizing agents ',
    url: 'http://e-additives.herokuapp.com/additives/318',
  },
  {
    notice:
      'Over consumption could lead to increased thirst, vomiting, diarrhea, abdominal pain and gastrointestinal inflammation.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jams, carbonated drinks, tinned fruits, cakes.',
    id: '158',
    veg: '0',
    name: 'Tartaric acid',
    info: 'Acid that occurs naturally in many fruits. Commercially obtained from grapes during the wine-making process. Reduces the reactions that cause fruits to discolour.',
    code: '334',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/334',
    function: 'antioxidant; pH regulator',
  },
  {
    notice:
      'Studies suggest that excessive phosphorus intake can put you at risk for osteoporosis and heart disease.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Beer, confectionery, sausages, vegetable oils.',
    id: '162',
    veg: '0',
    name: 'Phosphoric acid',
    info: 'Helps to increase the effcts of other antioxidants. Regulates pH in cakes and sweets. Used as a flavour to carbonated drinks.',
    code: '338',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/338',
    function: 'antioxidant; pH regulator; flavour',
  },
  {
    id: '175',
    code: '363',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Succinic acid',
    status: 'Hazard',
    veg: '0',
    function: 'pH regulator',
    foods: 'Desserts, soups.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Naturally occuring weak organic acid.',
    url: 'http://e-additives.herokuapp.com/additives/363',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Canned liquid coffee, heat-treated meat products, confectionery, chewing gum, non-alcoholic drinks.',
    id: '236',
    veg: '1',
    name: 'Sucrose esters of fatty acids',
    info: 'Reaction products of sucrose with animal and vegetable fats.',
    code: '473',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/473',
    function: 'emulsifier',
  },
  {
    notice:
      'Common side effects include stomach upset, nausea, diarrhea, and vomiting. Many of these side effects can be alleviated by taking the supplement with food. Nearly all forms of magnesium supplements have a laxative effect.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Canned vegetables.',
    id: '260',
    veg: '0',
    name: 'Magnesium chloride',
    info: 'Magnesium is an essential mineral. Complexes with pectins in vegetables to retain and firm structure during heat processing.',
    code: '511',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/511',
    function: 'firming agent',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Oils, margarine, butter, cheese, biscuits.',
    id: '142',
    veg: '',
    name: 'Sodium erythorbate',
    info: 'Helps to prevent oxidations that cause oils and fats to become rancid.',
    code: '316',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/316',
    function: 'antioxidant',
  },
  {
    id: '244',
    code: '481',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Sodium stearoyl-2-lactylate',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Bread.',
    notice:
      'The compound is considered safe and highly effective, although some people experience allergies or intolerance to the substance.',
    info: 'Derived from lactic acid.',
    url: 'http://e-additives.herokuapp.com/additives/481',
  },
  {
    notice:
      'If you’re allergic to casein or are following a vegan or dairy-free diet, you should avoid sodium caseinate.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Low calorie drinks, cake fillings.',
    id: '226',
    veg: '0',
    name: 'Sodium caseinate',
    info: 'Derived from cellulose, the main constituent of plant cell walls.',
    code: '469',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/469',
    function: 'emulsifier',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jam, tinned fruit.',
    id: '151',
    veg: '0',
    name: 'Calcium lactate',
    info: 'Helps to increase the anti-oxidant effects of other substances. Helps to reduce the reactions that can discolour fruits. May also be used to regulate pH in jams and jellies.',
    code: '327',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/327',
    function: 'antioxidant; pH regulator',
  },
  {
    id: '140',
    code: '312',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Dodecyl gallate',
    status: 'Warning',
    veg: '0',
    function: 'antioxidant',
    foods: 'Margarine',
    notice:
      'Direct contact with foods or products containing Dodecyl Gallate may cause symptoms, including burning, irritation and redness. Direct contact may occur on the skin, lips or mouth. It is possible, but rare, that ingestion of this substance could cause generalized symptoms such as itching or redness of the skin.',
    info: 'an antioxidant used in foods especially oil, fats, cheeses and mashed potato.',
    url: 'http://e-additives.herokuapp.com/additives/312',
  },
  {
    id: '133',
    code: '304',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '3',
    name: 'Fatty acid esters of ascorbic acid',
    status: 'Safe',
    veg: '0',
    function: 'antioxidant',
    foods: 'Fats and cooking oils.',
    notice: '',
    info: 'Helps to prevent oxidation reactions that can discolour foods.',
    url: 'http://e-additives.herokuapp.com/additives/304',
  },
  {
    id: '139',
    code: '311',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Octyl gallate',
    status: 'Warning',
    veg: '0',
    function: 'antioxidant',
    foods: 'Oils, margarines, butter.',
    notice:
      'Direct contact with foods or products containing Octyl Gallate may cause symptoms, including burning, irritation and redness. Direct contact may occur on the skin, lips or mouth. It is possible, but rare, that ingestion of this substance could cause generalized symptoms such as itching or redness of the skin.',
    info: 'an antioxidant used in foods especially oil, fats, cheeses and mashed potato.',
    url: 'http://e-additives.herokuapp.com/additives/311',
  },
  {
    notice:
      'You should not use calcium acetate if you are allergic to it, or if you have high levels of calcium in your blood.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Bread.',
    id: '117',
    veg: '0',
    name: 'Calcium acetate',
    info: 'Calcium salt of acetic acid. Reduces the growth of fungi in bread.',
    code: '263',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/263',
    function: 'preservative',
  },
  {
    id: '118',
    code: '264',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Ammonium acetate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice: 'Can cause nausea and vomiting.',
    info: ' Ammonium acetate is an ammonium salt obtained by reaction of ammonia with acetic acid.',
    url: 'http://e-additives.herokuapp.com/additives/264',
  },
  {
    notice: ' It has no adverse effects and no dietary restrictions.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Pickles, bread, salad cream, processed cheese, beer.',
    id: '114',
    veg: '0',
    name: 'Acetic acid',
    info: 'Reduces the growth of bacteria and can also be used to regulate the acidity of foods.',
    code: '260',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/260',
    function: 'preservative',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Carbonated drinks, cheeses, tinned fruits, wine.',
    id: '157',
    veg: '0',
    name: 'Calcium citrates',
    info: 'Helps to regulate pH. Added to flour to give more consistent baking of bread. Reduces reaction that discolour fruits.',
    code: '333',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/333',
    function: 'antioxidant; pH regulator',
  },
  {
    id: '173',
    code: '356',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Sodium adipate',
    status: 'Safe',
    veg: '',
    function: 'pH regulator',
    foods: 'Cake toppings, powdered dessert mixes.',
    notice: '',
    info: 'Helps to maintain the correct level of acidity for the food.',
    url: 'http://e-additives.herokuapp.com/additives/356',
  },
  {
    notice:
      'Should be avoided by people with impaired liver or kidney function.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Flour products.',
    id: '259',
    veg: '0',
    name: 'Ammonium chloride',
    info: 'Ammonium Chloride is a systemic and urinary acidifying salt. Ammonium chloride helps maintain pH and exerts a mild diuretic effect. This acid forming salt also exerts an expectorant effect by irritating the mucous membranes and is used for alleviation of cough.',
    code: '510',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/510',
    function: 'improving agent',
  },
  {
    notice:
      ' The ferrocyanides are less toxic than many salts of cyanide, because they tend not to release free cyanide.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Table salt substitutes.',
    id: '282',
    veg: '0',
    name: 'Calcium ferrocyanide',
    info: 'Absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '538',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/538',
    function: 'anti-caking agent',
  },
  {
    notice:
      'Potassium lactate is non-toxic to humans and the environment and is readily biodegradable.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Jam, ice cream.',
    id: '150',
    veg: '0',
    name: 'Potassium lactate',
    info: 'Helps to increase the anti-oxidant effects of other substances. Can also be used to regulate pH in jams and jellies.',
    code: '326',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/326',
    function: 'antioxidant; pH regulator',
  },
  {
    notice:
      'This additive is under discussion and may be included in a future amendments.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Sweeteners and food supplements.',
    id: '225',
    veg: '',
    name: 'Croscarmellose',
    info: 'Derived from cellulose, which cannot be digested in the body.',
    code: '468',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/468',
    function: 'emulsifier',
  },
  {
    id: '248',
    code: '492',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Sorbitan tristearate',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Confectionery.',
    notice:
      'Sorbitan tristearate is a nonionic surfactant. It is variously used as a dispersing agent, emulsifier, and stabilizer, in food and in aerosol sprays.',
    info: 'Synthetic additive.',
    url: 'http://e-additives.herokuapp.com/additives/492',
  },
  {
    id: '221',
    code: '464',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Hydroxypropyl methyl cellulose',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Processed potato foods.',
    notice: '',
    info: 'Derived from cellulose, the main component of plant cell walls.',
    url: 'http://e-additives.herokuapp.com/additives/464',
  },
  {
    notice:
      'Multiple studies of tricalcium phosphate have shown it to be safe for both human and animal consumption. These studies have concluded that calcium phosphates can aid in bone and mineral regeneration.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Self-raising flour, powdered milk drinks, cake mixes.',
    id: '165',
    veg: '1',
    name: 'Calcium phosphates',
    info: 'Helps to improve the action of other antioxidants. Added to baking flour to improve the consistency and texture of bread.',
    code: '341',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/341',
    function: 'antioxidant; firming agent',
  },
  {
    notice:
      'Acute exposure to calcium sulfate can cause redness and itching of the eyes, runny nose, sore throat, and irritation of the respiratory tract and skin',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Brewing process.',
    id: '265',
    veg: '0',
    name: 'Calcium sulfate',
    info: 'Naturally occuring mineral. May be added to water in the brewing process to regulate water consistency.',
    code: '516',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/516',
    function: 'firming agent; sequestrant',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jam, tinned fruit, biscuits, alcoholic drinks, cheese, dried soup.',
    id: '155',
    veg: '0',
    name: 'Sodium citrates',
    info: "Helps to increase the anti-oxidant effects of other substances. Reduces the reactions that can discolour fruits. May also be used to regulate pH in jams and jellies. Assists in retaining the 'fizz' of carbonated drinks.",
    code: '331',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/331',
    function: 'antioxidant; pH regulator',
  },
  {
    id: '267',
    code: '518',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Magnesium sulphate',
    status: 'Safe',
    veg: '0',
    function: 'firming agent',
    foods: '',
    notice:
      'While there is evidence that use during pregnancy may harm the baby, the benefits in certain conditions are greater than the risks',
    info: 'a laxative',
    url: 'http://e-additives.herokuapp.com/additives/518',
  },
  {
    id: '298',
    code: '574',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '5',
    name: 'Gluconic acid',
    status: 'Safe',
    veg: '',
    function: 'pH regulator',
    foods: 'Alcoholic and non-alcoholic drinks, dried foods.',
    notice: '',
    info: 'Helps to maintain the correct acid-balance.',
    url: 'http://e-additives.herokuapp.com/additives/574',
  },
  {
    id: '120',
    code: '280',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Propionic acid',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Bread, yoghurt, cheese.',
    notice: 'Dangerous for health.',
    info: 'Naturally-occuring fatty acid. Reduces the growth of fungi.',
    url: 'http://e-additives.herokuapp.com/additives/280',
  },
  {
    id: '212',
    code: '444',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Sucrose acetate isobutyrate',
    status: 'Safe',
    veg: '',
    function: 'emulsifier',
    foods: 'Non-alcoholic, flavoured cloudy drinks.',
    notice: "Plays an important role in maintaining the drink's flavor.",
    info: 'Derived from cane sugar.',
    url: 'http://e-additives.herokuapp.com/additives/444',
  },
  {
    notice:
      'Can cause nausea, vomiting, anorexia, diarrhea and skin irritation.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Cheese.',
    id: '104',
    veg: '0',
    name: 'Natamycin',
    info: 'Antimicrobial that prevents the growth of fungi in cheeses.',
    code: '235',
    category_id: '2',
    url: 'http://e-additives.herokuapp.com/additives/235',
    function: 'preservative',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Brewing process.',
    id: '262',
    veg: '0',
    name: 'Sulfuric acid',
    info: 'Used in the brewing process to reduce the loss of sugars from the barley. The acid does not remain in the final product.',
    code: '513',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/513',
    function: 'acid',
  },
  {
    notice:
      'May be harmful if absorbed through the skin. May cause irritation of the digestive tract. May cause respiratory tract irritation.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Margarine, processed meat, cheese, confectionery.',
    id: '161',
    veg: '0',
    name: 'Sodium potassium tartrate',
    info: 'Helps to increase the effcts of other antioxidants. Regulates pH in cakes and jams.',
    code: '337',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/337',
    function: 'antioxidant; pH regulator; stabiliser',
  },
  {
    notice:
      'Serious side effects of potassium citrate include uneven heartbeat, muscle weakness or limp feeling, severe stomach pain, and numbness or tingling in your hands, feet, or mouth.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Cakes, cheese, carbonated drinks, jam, biscuits.',
    id: '156',
    veg: '0',
    name: 'Potassium citrates',
    info: 'Reduces the reactions that can discolour fruits. May also be used to regulate pH.',
    code: '332',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/332',
    function: 'antioxidant; pH regulator',
  },
  {
    id: '106',
    code: '237',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Sodium formate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice: 'Avoid it, banned in some countries.',
    info: 'Sodium formate undergoes thermal decomposition to give hydrogen gas, which explodes spontaneously in the presence of nitrous oxide above critical limits',
    url: 'http://e-additives.herokuapp.com/additives/237',
  },
  {
    id: '64',
    code: '160f',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '1',
    name: "Ethyl ester of beta-apo-8'-carotenic acid (C 30)",
    status: 'Warning',
    veg: '1',
    function: 'food coloring',
    foods: 'Cheese',
    notice: '',
    info: 'Synthesised version of a naturally-occuring orange colour.',
    url: 'http://e-additives.herokuapp.com/additives/160f',
  },
  {
    id: '115',
    code: '261',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '2',
    name: 'Potassium acetate',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Sauces, pickles. Baked goods.',
    notice: 'Should be avoided by people with impaired kidney function.',
    info: 'Food acid.',
    url: 'http://e-additives.herokuapp.com/additives/261',
  },
  {
    notice:
      ' Malic acid is likely safe when taken by mouth in food amounts. Malic acid is possibly safe when taken by mouth as a medicine.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Jams.',
    id: '167',
    veg: '0',
    name: 'Sodium malates',
    info: 'Helps to maintain the pH in foods containing processed fruits such as jams and marmalade.',
    code: '350',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/350',
    function: 'pH regulator',
  },
  {
    notice:
      'You should not take potassium phosphate and sodium phosphate if you have severe kidney disease, or high levels of phosphorus in your body.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Custard powder, jelly mixes, powdered milk, cooked meats, soups.',
    id: '164',
    veg: '0',
    name: 'Potassium phosphates',
    info: 'Range of phosphate salts of potassium. Can help to increase the effect of other antioxidants.',
    code: '340',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/340',
    function: 'antioxidant; pH regulator',
  },
  {
    id: '239',
    code: '476',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Polyglycerol polyricinoleate',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Chocolate.',
    notice: '',
    info: 'Synthetic vegetable fat. Obtained from plant oils.',
    url: 'http://e-additives.herokuapp.com/additives/476',
  },
  {
    id: '232',
    code: '472c',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Citric acid esters of mono- and diglycerides of fatty acids',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice:
      'No publication on its digestibility under gastrointestinal conditions and impact on fat digestion was available.',
    info: 'Emulsifier used in the food industry and contains citric acid esters of mono- and diglycerides (GCFE).',
    url: 'http://e-additives.herokuapp.com/additives/472c',
  },
  {
    id: '122',
    code: '282',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Calcium propionate',
    status: 'Safe',
    veg: '0',
    function: 'preservative',
    foods: 'Bread, cheese.',
    notice: 'Linked to migraines.',
    info: 'Prevents the growth of bacteria in breads.',
    url: 'http://e-additives.herokuapp.com/additives/282',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Cakes.',
    id: '220',
    veg: '0',
    name: 'Hydroxypropyl cellulose',
    info: 'Prepared from cellulose. Used to produce the glazed effect on cakes.',
    code: '463',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/463',
    function: 'emulsifier',
  },
  {
    id: '176',
    code: '370',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Heptonolactone',
    status: 'Hazard',
    veg: '0',
    function: 'acidity regulator',
    foods: '',
    notice: 'Not permitted in Australia. Avoid it, banned in some countries.',
    info: '',
    url: 'http://e-additives.herokuapp.com/additives/370',
  },
  {
    notice:
      'Inhalation of kaolin through occupational exposure may cause pneumoconiosis.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Beer and wine production.',
    id: '296',
    veg: '0',
    name: 'Aluminium silicate, kaolin',
    info: 'A naturally-occuring mineral. Used to help reduce the cloudiness of beers and wines in their production.',
    code: '559',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/559',
    function: 'anti-caking agent; clarifier.',
  },
  {
    id: '319',
    code: '634',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: "Calcium 5'-ribonucleotides",
    status: 'Hazard',
    veg: '',
    function: 'flavour enhancer',
    foods: 'May be used in any food.',
    notice: 'Not permitted in foods or safe to eat.',
    info: 'Similar to the molecules that make up DNA.',
    url: 'http://e-additives.herokuapp.com/additives/634',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Vegetable protein drinks.',
    id: '166',
    veg: '0',
    name: 'Magnesium phosphates',
    info: 'Used in beverages to prevent oxidation reactions that will spoil the drink.',
    code: '343',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/343',
    function: 'antioxidant',
  },
  {
    id: '213',
    code: '445',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Glycerol esters of wood rosins',
    status: 'Safe',
    veg: '',
    function: 'emulsifier',
    foods: '',
    notice: '',
    info: 'The food-grade material is used in foods, beverages, and cosmetics to keep oils in suspension in water.',
    url: 'http://e-additives.herokuapp.com/additives/445',
  },
  {
    id: '308',
    code: '623',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Calcium diglutamate',
    status: 'Hazard',
    veg: '0',
    function: 'flavour enhancer',
    foods: 'Meat soups.',
    notice: 'Not safe for babies.',
    info: 'Salt substitute.',
    url: 'http://e-additives.herokuapp.com/additives/623',
  },
  {
    id: '152',
    code: '328',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '3',
    name: 'Ammonium lactate',
    status: 'Warning',
    veg: '1',
    function: 'antioxidant; pH regulator',
    foods: '',
    notice:
      'Ammonium lactate may be more likely to cause skin irritation in people who have fair or sensitive skin. ',
    info: 'Derived from milk (lactic acid); may contain pork rennin or whey in process, young children with lactose intolerance may show adverse reactions.',
    url: 'http://e-additives.herokuapp.com/additives/328',
  },
  {
    id: '227',
    code: '470a',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Fatty acids salts',
    status: 'Hazard',
    veg: '1',
    function: 'anti-caking agent',
    foods: 'Cake mix, potato crisps.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Derivatives of fatty acids.',
    url: 'http://e-additives.herokuapp.com/additives/470a',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Used in the processing of various foods.',
    id: '277',
    veg: '0',
    name: 'Magnesium hydroxide',
    info: 'Used as a processing aid and is not found in significant amounts in the final product.',
    code: '528',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/528',
    function: 'pH regulator',
  },
  {
    notice:
      'Possible allergen. Asthmatics and people allergic to sulphites beware!',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: '',
    id: '210',
    veg: '1',
    name: 'Gelatine',
    info: 'From animal bones.',
    code: '441',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/441',
    function: 'emulsifier',
  },
  {
    notice:
      'May trigger gout, not permitted in foods for infants and young children.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dried gravy granules, cured and prepared meats, meat soups.',
    id: '316',
    veg: '1',
    name: 'Disodium inosinate',
    info: 'Component of muscle that can be obtained from meat extract and dried sardines.',
    code: '631',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/631',
    function: 'flavour enhancer',
  },
  {
    id: '230',
    code: '472a',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Fatty acid esters of glycerol',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice: '',
    info: 'A type of ester that result from the combination of a fatty acid with an alcohol. ',
    url: 'http://e-additives.herokuapp.com/additives/472a',
  },
  {
    notice:
      'May be associated with itchy skin rashes up to 30 hours after ingestion. Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Reconstituted dried potato products.',
    id: '320',
    veg: '1',
    name: "Disodium 5'-ribonucleotides",
    info: 'Similar to the molecules that make up DNA.',
    code: '635',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/635',
    function: 'flavour enhancer',
  },
  {
    id: '285',
    code: '542',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Bone phosphate',
    status: 'Safe',
    veg: '1',
    function: 'anti-caking agent',
    foods: '',
    notice: '',
    info: 'Derived from bones; used in dried milk for coffee machines.',
    url: 'http://e-additives.herokuapp.com/additives/542',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dried gravy granules, cured and prepared meats, meat soups.',
    id: '315',
    veg: '',
    name: 'Inosinic acid',
    info: 'Component of muscle that can be obtained from meat extract and dried sardines.',
    code: '630',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/630',
    function: 'flavour enhancer',
  },
  {
    notice: 'Linked to stomach cancer.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Chewing gum, chocolate, confectionary.',
    id: '291',
    veg: '0',
    name: 'Talc',
    info: 'A naturally-occuring mineral. Helps to prevent powders from forming clumps and being difficult to pour.',
    code: '553b',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/553b',
    function: 'anti-caking agent',
  },
  {
    id: '269',
    code: '520',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Aluminium sulphate',
    status: 'Safe',
    veg: '',
    function: 'firming agent',
    foods: '',
    notice: '',
    info: 'Other uses include water purification and sewage treatment, fireproofing and waterproofing cloth, and as an ingredient of antiperspirants.',
    url: 'http://e-additives.herokuapp.com/additives/520',
  },
  {
    id: '324',
    code: '650',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Zinc acetate',
    status: 'Safe',
    veg: '',
    function: 'flavour enhancer',
    foods: 'Chewing gum.',
    notice: '',
    info: 'Zinc salt of acetic acid. Acts as a breth-freshener.',
    url: 'http://e-additives.herokuapp.com/additives/650',
  },
  {
    id: '272',
    code: '523',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Aluminium ammonium sulfate',
    status: 'Safe',
    veg: '',
    function: 'acidity regulator',
    foods: 'Egg white, glazed fruits.',
    notice:
      'It is moderately toxic to mammals and a recognised irritant. It is relatively non-toxic to fish and aquatic invertebrates.',
    info: 'Helps to ensure that the food has the desired texture.',
    url: 'http://e-additives.herokuapp.com/additives/523',
  },
  {
    id: '274',
    code: '525',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Potassium hydroxide',
    status: 'Hazard',
    veg: '0',
    function: 'acidity regulator',
    foods: 'Production of cocoa-based foods.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Used in the processing of foods.',
    url: 'http://e-additives.herokuapp.com/additives/525',
  },
  {
    notice:
      'Adverse effects appear in some asthmatic people, not permitted in foods for infants and young children; typical products are canned vegetables.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods:
      'Variety of foods as a flavour enhancer. Cured and processed meats, noodles.',
    id: '306',
    veg: '0',
    name: 'Monosodium glutamate',
    info: 'Derived from a naturally-occuring amino acid. Commercially produced by the fermentation of bacteria or by its isolation from plant proteins.',
    code: '621',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/621',
    function: 'flavour enhancer',
  },
  {
    notice:
      'May be harmful if absorbed through the skin. May cause irritation of the digestive tract. May cause respiratory tract irritation.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Fruit pie mixes, wine, bread production.',
    id: '160',
    veg: '0',
    name: 'Potassium tartrates',
    info: 'Commercially obtained from grapes during the wine-making process. Used to regulate the pH of wine and also to help flour rise consistently.',
    code: '336',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/336',
    function: 'antioxidant; pH regulator',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: '',
    id: '235',
    veg: '1',
    name: 'Mixed acetic and tartaric acid esters of mono- and diglycerides of fatty acids',
    info: 'All esters of the product are regarded as safe food additives with no upper limit.',
    code: '472f',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/472f',
    function: 'emulsifier',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Canned liquid coffee, heat-treated meat products, confectionery, chewing gum, non-alcoholic drinks.',
    id: '237',
    veg: '1',
    name: 'Sucroglycerides',
    info: 'Prepared from sources of plant and animal fats.',
    code: '474',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/474',
    function: 'emulsifier',
  },
  {
    id: '323',
    code: '640',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Glycine and its sodium salt',
    status: 'Safe',
    veg: '1',
    function: 'flavour enhancer',
    foods: 'May be used in any food.',
    notice: 'Can be mildly toxic if ingested.',
    info: 'Naturally-occuring amino acid.',
    url: 'http://e-additives.herokuapp.com/additives/640',
  },
  {
    id: '228',
    code: '470b',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Magnesium salts of fatty acids',
    status: 'Warning',
    veg: '1',
    function: 'anti-caking agent',
    foods: 'Bakery mixes, potato crisps.',
    notice: 'Not permitted in Australia.',
    info: 'Derivatives of fatty acids.',
    url: 'http://e-additives.herokuapp.com/additives/470b',
  },
  {
    notice:
      'Potassium ferrocyanide is nontoxic, and is not decomposed to cyanide in the body. The toxicity in rats is low, with lethal dose (LD50) at 6400 mg/kg.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Table salt.',
    id: '281',
    veg: '0',
    name: 'Potassium ferrocyanide',
    info: 'Absorbs water and so helps to prevent salt from forming clumps and being difficult to pour.',
    code: '536',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/536',
    function: 'anti-caking agent',
  },
  {
    notice: 'Forbidden.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:30+0300',
    foods: '',
    id: '24',
    veg: '',
    name: 'Ponceau 6R',
    info: 'A red azo dye. It is soluble in water and slightly soluble in ethanol.',
    code: '126',
    category_id: '1',
    url: 'http://e-additives.herokuapp.com/additives/126',
    function: 'food coloring (red)',
  },
  {
    notice: 'Part becomes alcohol in the body.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:31+0300',
    foods: 'Dried egg white.',
    id: '47',
    veg: '0',
    name: 'Triethyl citrate',
    info: 'Used in dried egg whites to allow them to foam correctly when beaten.',
    code: '1505',
    category_id: '9',
    url: 'http://e-additives.herokuapp.com/additives/1505',
    function: 'foam stabiliser',
  },
  {
    id: '108',
    code: '239',
    last_update: '2020-07-04T08:01:31+0300',
    category_id: '2',
    name: 'Hexamethylene tetramine',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Smoked fish.',
    notice:
      'Dangerous (Not permitted in Australia.) Avoid it, banned in some countries.',
    info: 'Prevents the growth of microbes.',
    url: 'http://e-additives.herokuapp.com/additives/239',
  },
  {
    id: '346',
    code: '938',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Argon',
    status: 'Warning',
    veg: '',
    function: 'packaging gas',
    foods: 'Variety of foods during their packagaing and transport.',
    notice:
      ' Inhalation in excessive concentrations can result in dizziness, nausea, vomiting, loss of consciousness, and death. Death may result from errors in judgment, confusion, or loss of consciousness which prevent self-rescue.',
    info: 'Inert gas that helps to prevent oxidation and microbials growth.',
    url: 'http://e-additives.herokuapp.com/additives/938',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dairy, meat, egg-products. Only allowed with special permission.',
    id: '325',
    veg: '',
    name: 'Spiramycins',
    info: 'Spiramycins are a class of antibiotics, produced by the mould Streptomyces ambofaciens.',
    code: '710',
    category_id: '7',
    url: 'http://e-additives.herokuapp.com/additives/710',
    function: 'antibiotic',
  },
  {
    id: '94',
    code: '223',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '2',
    name: 'Sodium metabisuiphite',
    status: 'Hazard',
    veg: '0',
    function: 'preservative',
    foods: 'Fruit juices, dried potatoes, beers.',
    notice: 'Dangerous additives for health.',
    info: 'Prevents microbial growth.',
    url: 'http://e-additives.herokuapp.com/additives/223',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dried gravy granules, cured and prepared meats, meat soups.',
    id: '317',
    veg: '',
    name: 'Dipotassium inosinate',
    info: 'Component of muscle that can be obtained from meat extract and dried sardines.',
    code: '632',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/632',
    function: 'flavour enhancer',
  },
  {
    id: '153',
    code: '329',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '3',
    name: 'Magnesium lactate',
    status: 'Safe',
    veg: '1',
    function: 'antioxidant; pH regulator',
    foods: '',
    notice:
      'Young children with lactose intolerance may show adverse reactions.',
    info: ' Derived from milk (lactic acid); may contain pork rennin or whey in process.',
    url: 'http://e-additives.herokuapp.com/additives/329',
  },
  {
    id: '275',
    code: '526',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Calcium hydroxide',
    status: 'Safe',
    veg: '0',
    function: 'firming agent',
    foods: 'Brewing process.',
    notice: 'No adverse effects in small quantities.',
    info: 'Used to remove acids from barley in the brewing process.',
    url: 'http://e-additives.herokuapp.com/additives/526',
  },
  {
    id: '276',
    code: '527',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Ammonium hydroxide',
    status: 'Hazard',
    veg: '0',
    function: 'pH regulator',
    foods: 'Colourings added to food.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Used in the processing of foods.',
    url: 'http://e-additives.herokuapp.com/additives/527',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Alcoholic and non-alcoholic drinks, dried foods.',
    id: '300',
    veg: '0',
    name: 'Sodium gluconate',
    info: 'Sequestrants combine with positive ions to form a soluble salt which improves the stability of the food.',
    code: '576',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/576',
    function: 'sequestrant',
  },
  {
    id: '268',
    code: '519',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Copper sulphate',
    status: 'Warning',
    veg: '0',
    function: 'preservative',
    foods: '',
    notice:
      'Copper sulfate can cause severe eye irritation. Eating large amounts of copper sulfate can lead to nausea, vomiting, and damage to body tissues, blood cells, the liver, and kidneys. With extreme exposures, shock and death can occur.',
    info: 'essential mineral',
    url: 'http://e-additives.herokuapp.com/additives/519',
  },
  {
    notice: 'May trigger gout.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dried gravy granules, cured and prepared meats, meat soups.',
    id: '318',
    veg: '0',
    name: 'Calcium inosinate',
    info: 'Component of muscle that can be obtained from meat extract and dried sardines.',
    code: '633',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/633',
    function: 'flavour enhancer',
  },
  {
    notice: 'Occasionally causes irritations of the skin.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Sweets, edible cake decorations.',
    id: '331',
    veg: '',
    name: 'Shellac',
    info: "Obtained from a resin produced by 'lac' insects and scale insects.",
    code: '904',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/904',
    function: 'glazing agent',
  },
  {
    notice: 'Large quantities can cause gastric ulceration.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Brewing process, table salt.',
    id: '257',
    veg: '0',
    name: 'Potassium chloride',
    info: 'Used as a low sodium alternative to table salt. Also in the early stages of the brewing process.',
    code: '508',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/508',
    function: 'gelling agent',
  },
  {
    id: '245',
    code: '482',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Calcium stearoyl-2-lactylate',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Instant gravy.',
    notice: '',
    info: 'Derived from lactic acid.',
    url: 'http://e-additives.herokuapp.com/additives/482',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: '',
    id: '234',
    veg: '1',
    name: 'Mono- and diacetyltartaric acid esters of mono- and diglycerides of fatty acids',
    info: '',
    code: '472e',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/472e',
    function: 'emulsifier',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Jams, soft drinks, soups, brewing process.',
    id: '327',
    veg: '0',
    name: 'Dimethylpolysiloxane',
    info: 'Silicone based. Helps to prevent powders from clumping together and becoming difficult to pour.',
    code: '900',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/900',
    function: 'anti-caking agent',
  },
  {
    id: '233',
    code: '472d',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Tartaric acid esters of mono- and diglycerides of fatty acids',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice:
      'The substance tartaric, acetic and fatty acid esters of glycerol, mixed and allocated an ADI ‘not limited’, with the provision that the total intake of tartaric acid from food additives not exceed 30 mg/kg bw per day.',
    info: 'Consist of mixed glycerol esters of mono- and diacetyltartaric acid and fatty acids of food fats. It can be manufactured either by the interaction of diacetyltartaric anhydride and mono- and diglycerides of fatty acids in the presence of acetic acid, or by interaction of acetic anhydride and mono- and diglycerides of fatty acids in the presence of tartaric acid',
    url: 'http://e-additives.herokuapp.com/additives/472d',
  },
  {
    id: '246',
    code: '483',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Stearyl tartrate',
    status: 'Hazard',
    veg: '1',
    function: 'emulsifier',
    foods: 'Flour.',
    notice: 'Prohibited in Australia. Avoid it, banned in some countries.',
    info: 'Derived from tartaric acid.',
    url: 'http://e-additives.herokuapp.com/additives/483',
  },
  {
    id: '344',
    code: '931',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Nitrogen',
    status: 'Safe',
    veg: '0',
    // "function":".N2 is used for creating a modified atmosphere where it is applied along with carbon dioxide for preservation of the fresh packaged foods by safeguarding against oxidative damage.",
    function: 'food preservation',
    foods: '',
    notice: '',
    info: 'Used in freezing and vacuum packing.',
    url: 'http://e-additives.herokuapp.com/additives/931',
  },
  {
    notice:
      'Calcium chloride poses some serious health and safety hazards. If ingested, calcium chloride can lead to burns in the mouth and throat, excess thirst, vomiting, stomach pain, low blood pressure, and other possible severe health effects. It can also irritate skin by causing excessive dryness or desiccating moist skin.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Brewing process.',
    id: '258',
    veg: '0',
    name: 'Calcium chloride',
    info: 'Added to water in the brewing process to obtain consistent quality of beer.',
    code: '509',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/509',
    function: 'sequestrant',
  },
  {
    id: '335',
    code: '913',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Lanolin',
    status: 'Safe',
    veg: '1',
    function: 'glazing agent',
    foods: '',
    notice: 'Nonmedical grade lanolin sometimes causes a minor skin rash.',
    info: 'Derived from sheep wool.',
    url: 'http://e-additives.herokuapp.com/additives/913',
  },
  {
    id: '243',
    code: '480',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Dioctyl sodium sulphosuccinate',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: '',
    notice:
      'May be safely used in food in accordance with the following prescribed conditions: (a) As a wetting agent in the following fumaric acid-acidulated foods: Dry gelatin dessert, dry beverage base, and fruit juice drinks, when standards of identity do not preclude such use.',
    info: 'Act like detergents and are used to soften the stool when it is desirable to lessen the discomfort or the strain of defecation.',
    url: 'http://e-additives.herokuapp.com/additives/480',
  },
  {
    notice: "May upset the body's water balance.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Brewing process.',
    id: '263',
    veg: '0',
    name: 'Sodium sulfate',
    info: 'Used in the brewing process to modify water and ensure consistency of taste.',
    code: '514',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/514',
    function: 'acid',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Milk.',
    id: '294',
    veg: '0',
    name: 'Aluminium calcium silicate',
    info: 'Absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '556',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/556',
    function: 'anti-caking agent',
  },
  {
    id: '334',
    code: '912',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Montan acid esters',
    status: 'Safe',
    veg: '',
    function: 'glazing agent',
    foods: 'Fruits.',
    notice: '',
    info: 'Glazing agents help to give the food an appealing appearance.',
    url: 'http://e-additives.herokuapp.com/additives/912',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Butter, biscuits.',
    id: '255',
    veg: '0',
    name: 'Magnesium carbonate',
    info: 'May be added to table salt to help it flow smoothly when poured. Medically used as an antacid and laxative.',
    code: '504',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/504',
    function: 'pH regulator; anti-caking agent',
  },
  {
    id: '341',
    code: '926',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Chlorine dioxide',
    status: 'Hazard',
    veg: '0',
    function: 'bleach',
    foods: 'Water.',
    notice:
      'The United States Environmental Protection Agency has set a maximum level of 0.8 mg/L for chlorine dioxide in drinking water.',
    info: 'Chlorine dioxide (ClO2) is a chemical compound consisting of one chlorine atom and two oxygen atoms.',
    url: 'http://e-additives.herokuapp.com/additives/926',
  },
  {
    id: '303',
    code: '579',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '5',
    name: 'Ferrous gluconate',
    status: 'Safe',
    veg: '0',
    function: 'stabiliser',
    foods: 'Olives, iron supplements.',
    notice:
      'Large doses may have irritant/corrosive effect on gastro-intestinal mucosa which can lead to necrosis and perforation.',
    info: 'Helps to prevent food spoilage. Used with darkened olives.',
    url: 'http://e-additives.herokuapp.com/additives/579',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Herbal tea concentrates.',
    id: '251',
    veg: '1',
    name: 'Sorbitan monopalmitate Sorbitan monopalmitate',
    info: 'Emulsifiers help to prevent fats from separating out when in a solution.',
    code: '495',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/495',
    function: 'emulsifier',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Table salt, sweets.',
    id: '290',
    veg: '0',
    name: 'Magnesium silicate',
    info: 'When processed, it absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '553a',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/553a',
    function: 'anti-caking agent',
  },
  {
    notice:
      'The acid itself is corrosive, and concentrated forms release acidic mists that are also dangerous. If the acid or mist come into contact with the skin, eyes, or internal organs, the damage can be irreversible or even fatal in severe cases.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Beer making process.',
    id: '256',
    veg: '0',
    name: 'Hydrochloric acid',
    info: 'Used in the early stages of the brewing process to reduce the loss of sugars from barley. Safe in small quantities. Aids in processing of barley.',
    code: '507',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/507',
    function: 'acid',
  },
  {
    id: '247',
    code: '491',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Sorbitan monostearate',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Cake mix.',
    notice:
      ' Many tests on humans and animals have shown sorbitan monostearate not to be carcinogenic or have harmful effects.',
    info: 'Can be used to give confectionery a shiny appearance.',
    url: 'http://e-additives.herokuapp.com/additives/491',
  },
  {
    notice: 'Occasionally causes allergic reactions.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods:
      'Chocolate confectionery. Used in cosmetics and inks, and to wax fruit.',
    id: '330',
    veg: '0',
    name: 'Carnauba wax',
    info: 'Derived from a South American palm.',
    code: '903',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/903',
    function: 'glazing agent',
  },
  {
    id: '353',
    code: '948',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Oxygen',
    status: 'Safe',
    veg: '',
    function: 'packaging gas',
    foods: '',
    notice: '',
    info: 'Atmospheric gas.',
    url: 'http://e-additives.herokuapp.com/additives/948',
  },
  {
    id: '253',
    code: '501',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Potassium carbonate',
    status: 'Hazard',
    veg: '0',
    function: 'pH regulator',
    foods: 'Baking powder, baked products, cocoa, chocolate products.',
    notice:
      'There is no indication that this chemical may be carcinogenic or mutagenic, but it can be toxic if in contact with skin and eyes, swallowed or inhaled.',
    info: 'Regulates the acididty of foods.',
    url: 'http://e-additives.herokuapp.com/additives/501',
  },
  {
    id: '333',
    code: '907',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Refined microcrystalline wax',
    status: 'Hazard',
    veg: '1',
    function: 'glazing agent',
    foods: '',
    notice: 'Avoid it, banned in some countries.',
    info: '',
    url: 'http://e-additives.herokuapp.com/additives/907',
  },
  {
    notice: 'Unpermitted',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Canned asparagus.',
    id: '261',
    veg: '0',
    name: 'Stannous chloride',
    info: 'Improves antioxidant effects (synergist). Synergists are compounds that improve the effects of other additives.',
    code: '512',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/512',
    function: 'antioxidant',
  },
  {
    notice: 'Banned in the US and UK. Migraines, can be carcinogenic.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Low calorie, non-alcoholic drinks.',
    id: '357',
    veg: '0',
    name: 'Cyclamic acid and its Na and Ca salts',
    info: 'Artificial sweetener that is approximately 30 times sweeter than sucrose (table sugar).',
    code: '952',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/952',
    function: 'sweetener',
  },
  {
    id: '284',
    code: '541',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Sodium aluminium phosphate',
    status: 'Hazard',
    veg: '0',
    function: 'emulsifier',
    foods: 'Cakes.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Aerates cakes as they are baking to give them a light texture.',
    url: 'http://e-additives.herokuapp.com/additives/541',
  },
  {
    notice: 'Adverse effects, migraine headaches.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Sweeteners, diet drinks, desserts, baked foods and puddings.',
    id: '356',
    veg: '1',
    name: 'Aspartame',
    info: 'Artificial sweetener which is composed of aspartic acid and the methyl ester of phenylalanine (both amino acids). Used as a low-calorie sweetener in thousands of different products.',
    code: '951',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/951',
    function: 'sweetener',
  },
  {
    notice:
      'Calcium gluconate side effects include nausea, constipation, and upset stomach. Rapid intravenous injections of calcium gluconate may cause hypercalcaemia, which can result in vasodilation, cardiac arrhythmias, decreased blood pressure, and bradycardia. Extravasation of calcium gluconate can lead to cellulitis.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Alcoholic and non-alcoholic drinks, dried foods.',
    id: '302',
    veg: '0',
    name: 'Calcium gluconate',
    info: 'Sequestrants combine with positive ions to form a soluble salt which improves the stability of the food.',
    code: '578',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/578',
    function: 'pH regulator; sequestrant',
  },
  {
    notice:
      'May cause gastrointestinal irritation with nausea, vomiting and diarrhea.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Table salt substitutes.',
    id: '264',
    veg: '0',
    name: 'Potassium sulfate',
    info: 'May be used to replace table salt (sodium chloride) in diet products.',
    code: '515',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/515',
    function: '\n      ',
  },
  {
    notice:
      'Linked to Alzeihmers and nerve damage, bone diseases, kidney damage, neurotoxicity.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Table salt substitutes, powdered food, sliced cheese.',
    id: '293',
    veg: '',
    name: 'Potassium aluminium silicate',
    info: 'Absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '555',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/555',
    function: 'anti-caking agent',
  },
  {
    id: '365',
    code: '967',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Xylitol',
    status: 'Safe',
    veg: '0',
    function: 'sweetener',
    foods: 'Desserts, ice cream, confectionery, sauces.',
    notice:
      'If you take large amounts of xylitol, such as 30 to 40 grams, you may experience diarrhea or gas',
    info: 'Derived from naturally-occuring sugars.',
    url: 'http://e-additives.herokuapp.com/additives/967',
  },
  {
    notice: 'Most people will not take more than 100 mEq a day.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Alcoholic and non-alcoholic drinks, dried foods.',
    id: '301',
    veg: '0',
    name: 'Potassium gluconate',
    info: 'Sequestrants combine with positive ions to form a soluble salt which improves the stability of the food.',
    code: '577',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/577',
    function: 'sequestrant',
  },
  {
    id: '361',
    code: '957',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Thaumatin',
    status: 'Safe',
    veg: '0',
    function: 'flavour enhancer',
    foods: 'Used to sweeten wines, bread and fruit.',
    notice: '',
    info: 'Plant protein extracted from a fruit native to West Africa.',
    url: 'http://e-additives.herokuapp.com/additives/957',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Foods containing cocoa powder.',
    id: '279',
    veg: '0',
    name: 'Magnesium oxide',
    info: 'Absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '530',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/530',
    function: 'anti-caking agent',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Beer and wine production.',
    id: '295',
    veg: '0',
    name: 'Bentonite',
    info: 'A naturally-occuring mineral. Used to help reduce the cloudiness of beers and wines in their production.',
    code: '558',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/558',
    function: 'anti-caking agent; clarifier',
  },
  {
    notice:
      'U.S. health authorities have acknowledged that up to 3 g/day of long-chain omega-3 fatty acids (EPA and DHA) intake is Generally Recognized As Safe.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Wide range of powdered and dried foods, soup mixes, cake mixes.',
    id: '297',
    veg: '1',
    name: 'Fatty acids',
    info: 'Helps to prevent powders from forming clumps and being difficult to pour.',
    code: '570',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/570',
    function: 'anti-caking agent',
  },
  {
    notice: 'Safe in small quantities.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Used in the processing of various foods.',
    id: '278',
    veg: '0',
    name: 'Calcium oxide',
    info: 'Used as a processing aid and is not found in significant amounts in the final product.',
    code: '529',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/529',
    function: 'pH regulator',
  },
  {
    notice:
      'Generally recognized as safe when used as anticaking agent at levels not exceeding 5 percent in baking powder, two percent in other food, two percent in animal feed, by weight, regulated by FDA in the Code of Federal Regulations.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Table salt, sweets.',
    id: '289',
    veg: '0',
    name: 'Calcium silicate',
    info: 'A naturally occuring mineral. When processed, it absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '552',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/552',
    function: 'anti-caking agent',
  },
  {
    id: '339',
    code: '924',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Potassium bromate',
    status: 'Safe',
    veg: '0',
    function: 'improving agent',
    foods: 'Flour products.',
    notice: 'Can cause nausea, vomiting, diarrhea, pain.',
    info: '',
    url: 'http://e-additives.herokuapp.com/additives/924',
  },
  {
    notice:
      'It is a natural ingredient made from the fermentation and there were no toxicity and few side effects reported in studies.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Milk sterilisation and brewing process.',
    id: '299',
    veg: '0',
    name: 'Glucono delta lactone',
    info: 'Prevents the formation of salt deposits in the brewing process and when milk is heated to high temperatures.',
    code: '575',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/575',
    function: 'sequestrant',
  },
  {
    notice: 'High intakes may upset the calcium/phosphate equilibrium.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Cakes, instant mashed potato, cheese.',
    id: '214',
    veg: '0',
    name: 'Diphosphates',
    info: 'Can also be used to improve the colour of foods and as a raising agent in baking.',
    code: '450',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/450',
    function: 'pH regulator; emulsifier',
  },
  {
    id: '287',
    code: '545',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Ammonium polyphosphates',
    status: 'Hazard',
    veg: '0',
    function: 'anti-caking agent',
    foods: '',
    notice: 'Avoid it, banned in some countries.',
    info: 'May cause nose and upper respiratory tract inflammation ',
    url: 'http://e-additives.herokuapp.com/additives/545',
  },
  {
    id: '271',
    code: '522',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Aluminium potassium sulfate',
    status: 'Safe',
    veg: '',
    function: 'acidity regulator',
    foods: 'Egg white, glazed fruits.',
    notice: '',
    info: 'Helps to ensure food has the desired texture.',
    url: 'http://e-additives.herokuapp.com/additives/522',
  },
  {
    notice:
      "Known to cause placental problems in pregnancy and has been linked to Alzheimer's.",
    status: 'Warning',
    last_update: '2020-07-04T08:01:35+0300',
    foods: 'Salt, dried milk substitutes and flours.',
    id: '292',
    veg: '0',
    name: 'Sodium aluminium silicate',
    info: 'A naturally-occuring mineral. Helps to prevent powders from forming clumps and being difficult to pour.',
    code: '554',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/554',
    function: 'anti-caking agent',
  },
  {
    notice:
      "Destroys nutrients, carcinogen, in some areas tab water is contaminated with it, to make it 'safer' to drink.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Flour products.',
    id: '340',
    veg: '0',
    name: 'Chlorine',
    info: '',
    code: '925',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/925',
    function: 'preservative; bleach; improving agent',
  },
  {
    id: '362',
    code: '959',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Neohesperidine DC',
    status: 'Safe',
    veg: '',
    function: 'flavour enhancer',
    foods: 'Some drinks.',
    notice: 'Neither toxic, mutagenic nor carcinogenic.',
    info: 'Plant material extracted and purified from grapefruit skin.',
    url: 'http://e-additives.herokuapp.com/additives/959',
  },
  {
    id: '211',
    code: '442',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Ammonium phosphatides',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Chocolate.',
    notice: '',
    info: 'Synthetically-produced stabiliser.',
    url: 'http://e-additives.herokuapp.com/additives/442',
  },
  {
    id: '304',
    code: '585',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Ferrous lactate',
    status: 'Safe',
    veg: '0',
    function: 'stabiliser',
    foods: 'Olives.',
    notice: '',
    info: 'Helps to prevent food spoilage. Used with darkened olives.',
    url: 'http://e-additives.herokuapp.com/additives/585',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Herbal tea concentrates.',
    id: '249',
    veg: '1',
    name: 'Sorbitan monolaurate',
    info: 'Emulsifiers help to prevent fats from separating out when in a solution.',
    code: '493',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/493',
    function: 'emulsifier',
  },
  {
    notice: 'No known adverse effects in small quantities.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Beer, bread, cakes.',
    id: '252',
    veg: '0',
    name: 'Sodium carbonates',
    info: 'Used in the brewing process. Sodium hydrogen carbonate (sodium bicarbonate) used as a raising agent in baking. Generates carbon dioxide gas during the baking process and this causes cakes and bread to rise.',
    code: '500',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/500',
    function: 'pH regulator',
  },
  {
    notice:
      'Large oral dosages may produce gastrointestinal disturbances and irritation.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Sweeteners, diet drinks, desserts, baked foods and puddings.',
    id: '355',
    veg: '0',
    name: 'Acesulphane potassium',
    info: 'Artificial sweetener discovered in 1967. It is approximately 200 times sweeter than sucrose and used in many low-calorie products.',
    code: '950',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/950',
    function: 'sweetener',
  },
  {
    id: '238',
    code: '475',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Polyglycerol esters of fatty acids',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Cakes and cake mixes.',
    notice:
      'No adverse effects of PEFA at any dose have been observed in short‐term, subchronic or chronic toxicity studies.',
    info: 'Synthetically produced from fatty acids.',
    url: 'http://e-additives.herokuapp.com/additives/475',
  },
  {
    notice:
      'he ferrocyanides are less toxic than many salts of cyanide, because they tend not to release free cyanide.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Table salt substitutes.',
    id: '280',
    veg: '',
    name: 'Sodium ferrocyanide',
    info: 'Absorbs water and so helps to prevent powders from forming clumps and being difficult to pour.',
    code: '535',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/535',
    function: 'anti-caking agent',
  },
  {
    notice: 'Occasionally causes allergic reactions.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Cakes and confectionery. Used to wax fruit.',
    id: '328',
    veg: '1',
    name: 'Beeswax',
    info: 'Purified from honey-bee hives. Made by bees, but does not contain insects.',
    code: '901',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/901',
    function: 'glazing agent',
  },
  {
    id: '338',
    code: '921',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'L-Cystin',
    status: 'Safe',
    veg: '1',
    function: 'improving agent',
    foods: '',
    notice:
      "there's some concern that taking L-cysteine in combination with certain medications (such as prednisone and other drugs that suppress the immune system) may increase the potency of those medications and trigger adverse effects.",
    info: 'l-cysteine (l-Cys) is a non-essential amino acid and thus is one of the building blocks required for the synthesis of proteins.',
    url: 'http://e-additives.herokuapp.com/additives/921',
  },
  {
    notice: 'May trigger gout.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Seasonings.',
    id: '311',
    veg: '0',
    name: 'Guanylic acid',
    info: 'Derived from a naturally-occuring amino acid. Helps to bring out the flavours of many foods.',
    code: '626',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/626',
    function: 'flavour enhancer',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dairy, meat, egg-products. Only allowed with special permission.',
    id: '326',
    veg: '',
    name: 'Tylosin',
    info: 'Tylosin is an antibiotic, produced by the mould Streptomyces fradiae.',
    code: '713',
    category_id: '7',
    url: 'http://e-additives.herokuapp.com/additives/713',
    function: 'antibiotic',
  },
  {
    id: '329',
    code: '902',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Candelilla wax',
    status: 'Safe',
    veg: '',
    function: 'glazing agent',
    foods: 'Chocolate, nuts, coffee beans, fruits.',
    notice: '',
    info: 'Glazing agents help to give the food an appealing appearance.',
    url: 'http://e-additives.herokuapp.com/additives/902',
  },
  {
    id: '322',
    code: '637',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Ethyl maltol',
    status: 'Safe',
    veg: '0',
    function: 'flavour enhancer',
    foods: '',
    notice:
      'This chemical was well tolerated for two years by rats and dogs. No adverse toxic, reproductive or embryogenic effects at doses up to and including 200 mg/kg/day were observed.',
    info: 'Derived from maltol.',
    url: 'http://e-additives.herokuapp.com/additives/637',
  },
  {
    notice: 'Maltol is currently authorised as a flavour in food;',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: '',
    id: '321',
    veg: '0',
    name: 'Maltol',
    info: 'Derived from the bark of larch trees, pine needles, chicory wood, oils and roasted malt; it may be produced synthetically.',
    code: '636',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/636',
    function: 'flavour enhancer',
  },
  {
    id: '217',
    code: '459',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Beta-cyclodextrin',
    status: 'Safe',
    veg: '',
    function: 'stabiliser',
    foods: 'Foods in tablet or coated tablet form.',
    notice: 'Higher dose of cyclodextrins may be harmful.',
    info: 'Starch-based material used as a tableting excipient.',
    url: 'http://e-additives.herokuapp.com/additives/459',
  },
  {
    id: '342',
    code: '927b',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Carbamide',
    status: 'Hazard',
    veg: '0',
    function: 'improving agent',
    foods: 'Cakes.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Used in cakes to improve the flour during baking conditions.',
    url: 'http://e-additives.herokuapp.com/additives/927b',
  },
  {
    id: '283',
    code: '540',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Dicalcium diphosphate',
    status: 'Hazard',
    veg: '0',
    function: 'anti-caking agent',
    foods: '',
    notice: 'Avoid it, banned in some countries',
    info: 'Dibasic calcium phosphate is mainly used as a dietary supplement in prepared breakfast cereals, dog treats, enriched flour, and noodle product',
    url: 'http://e-additives.herokuapp.com/additives/540',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Herbal tea concentrates.',
    id: '250',
    veg: '1',
    name: 'Sorbitan monooleate',
    info: 'Emulsifiers help to prevent fats from separating out when in a solution.',
    code: '494',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/494',
    function: 'emulsifier',
  },
  {
    id: '332',
    code: '905',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Microcrystalline wax',
    status: 'Warning',
    veg: '1',
    function: 'glazing agent',
    foods: 'Confectionery, dried fruits.',
    notice: 'May be a link to bowel cancer.',
    info: 'Synthetically-produced waxes.',
    url: 'http://e-additives.herokuapp.com/additives/905',
  },
  {
    notice:
      'Disodium guanylate is not safe for babies under twelve weeks, and should generally be avoided by asthmatics and people with gout, as guanylates are metabolized to purines. However, the typical amounts found in food are generally too low to produce significant side effects.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'May be used in any food.',
    id: '313',
    veg: '',
    name: 'Dipotassium guanylate',
    info: 'Derived from a naturally-found nuceotide (component of DNA) that is commercially synthesised for use as a food additive.',
    code: '628',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/628',
    function: 'flavour enhancer',
  },
  {
    notice: 'Can cause flatulence, distension, intestinal obstruction.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Processed potato snacks, soft drinks, cakes.',
    id: '219',
    veg: '0',
    name: 'Methyl cellulose',
    info: 'Derived from cellulose, the main component of plant cell walls. It is not digestible by humans and so adds bulk to the food. Also known as fibre or roughage. Can be used in special diets for diabetics or lactose intolerant people.',
    code: '461',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/461',
    function: 'emulsifier',
  },
  {
    id: '358',
    code: '953',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'lsomalt',
    status: 'Warning',
    veg: '',
    function: 'sweetener',
    foods: 'Desserts, ice cream, confectionery, sauces.',
    notice:
      'It carries a risk of gastric distress, including flatulence and diarrhea, when consumed in large quantities (above about 20–30 g (1 oz) per day).',
    info: 'Derived from naturally-occuring sugars.',
    url: 'http://e-additives.herokuapp.com/additives/953',
  },
  {
    id: '286',
    code: '544',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '5',
    name: 'Calcium polyphosphates',
    status: 'Hazard',
    veg: '0',
    function: 'anti-caking agent',
    foods: '',
    notice: 'Avoid it, banned in some countries.',
    info: '',
    url: 'http://e-additives.herokuapp.com/additives/544',
  },
  {
    id: '349',
    code: '942',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Nitrous oxide',
    status: 'Safe',
    veg: '',
    function: 'propellant',
    foods: '',
    notice: 'Seems quite safe in small quantities.',
    info: "Nitrous oxide is a safe, common sedation method that's appropriate for adults and children.",
    url: 'http://e-additives.herokuapp.com/additives/942',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Brewing process, production of edible oils.',
    id: '273',
    veg: '0',
    name: 'Sodium hydroxide',
    info: 'Used in the processing of many foods. In the brewing process it is use to remove acids from barley. Used in the production of edible oils.',
    code: '524',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/524',
    function: 'acidity regulator',
  },
  {
    id: '310',
    code: '625',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Magnesium diglutamate',
    status: 'Safe',
    veg: '0',
    function: 'flavour enhancer',
    foods: 'May be used in any food.',
    notice: '',
    info: 'Magnesium is a cofactor in more than 300 enzyme systems that regulate diverse biochemical reactions in the body, including protein synthesis, muscle and nerve function, blood glucose control, and blood pressure regulation.',
    url: 'http://e-additives.herokuapp.com/additives/625',
  },
  {
    id: '364',
    code: '966',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '8',
    name: 'Lactitol',
    status: 'Safe',
    veg: '1',
    function: 'sweetener',
    foods: 'Desserts, ice cream, confectionery, sauces.',
    notice:
      'Consumption of 20 grams per day of polyols, including lactitol, is unlikely to cause undesirable laxative symptoms.',
    info: 'Derived from naturally-occuring sugars.',
    url: 'http://e-additives.herokuapp.com/additives/966',
  },
  {
    id: '336',
    code: '914',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Oxidised polyethylene wax',
    status: 'Safe',
    veg: '',
    function: 'glazing agent',
    foods: 'Fruits.',
    notice: '',
    info: 'Glazing agents help to give the food an appealing appearance.',
    url: 'http://e-additives.herokuapp.com/additives/914',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dependent on additive.',
    id: '266',
    veg: '',
    name: 'Ammonium sulfate',
    info: 'Carriers are substances that can be used to hold other additives.',
    code: '517',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/517',
    function: 'improving agent',
  },
  {
    id: '270',
    code: '521',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '5',
    name: 'Aluminium sodium sulfate',
    status: 'Safe',
    veg: '',
    function: 'firming agent',
    foods: 'Egg white, glazed fruits.',
    notice: '',
    info: 'Helps to ensure food has the desired texture.',
    url: 'http://e-additives.herokuapp.com/additives/521',
  },
  {
    notice: 'Young children should avoid it.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Variety of foods as a flavour enhancer.',
    id: '305',
    veg: '0',
    name: 'Glutamic acid',
    info: 'A naturally-occuring amino acid. Commercially produced by the fermentation of bacteria.',
    code: '620',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/620',
    function: 'flavour enhancer',
  },
  {
    notice:
      "there's some concern that taking L-cysteine in combination with certain medications (such as prednisone and other drugs that suppress the immune system) may increase the potency of those medications and trigger adverse effects.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Cakes, chicken soup.',
    id: '337',
    veg: '1',
    name: 'L-cysteine',
    info: 'Flour treatment agent derived from animal hair and chicken feathers.',
    code: '920',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/920',
    function: 'improving agent',
  },
  {
    notice:
      "There isn't yet evidence to suggest it's dangerous to ingest as a food additive, but more research is needed on what role it plays in the body.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Beer and wine production process.',
    id: '288',
    veg: '0',
    name: 'Silicon dioxide',
    info: 'Used in beer and wine making to remove cloudiness during the production process.',
    code: '551',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/551',
    function: 'anti-caking agent; thickener',
  },
  {
    id: '343',
    code: '928',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Benzoyl peroxide',
    status: 'Safe',
    veg: '0',
    function: 'bleach',
    foods: '',
    notice: 'Asthmatics and people with a history of allergies must beware.',
    info: 'BPO works primarily as an exfoliating agent by increasing the turnover of the skin and removes the mixture of sebum and dead skin cells from the pores.',
    url: 'http://e-additives.herokuapp.com/additives/928',
  },
  {
    id: '354',
    code: '949',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Hydrogen',
    status: 'Safe',
    veg: '',
    function: 'packaging gas',
    foods: '',
    notice: '',
    info: 'Gas.',
    url: 'http://e-additives.herokuapp.com/additives/949',
  },
  {
    id: '363',
    code: '965',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '8',
    name: 'Maltitol; Maltitol syrup',
    status: 'Safe',
    veg: '0',
    function: 'humectant',
    foods: 'Desserts, ice cream, confectionery, sauces.',
    notice:
      'Maltitol is found in many sugar-free products, but people with diabetes should remember that it’s a carbohydrate. This means that it still has a glycemic index. While not as high as sugar, it still has an effect on blood glucose.',
    info: 'Derived from naturally-occuring sugars.',
    url: 'http://e-additives.herokuapp.com/additives/965',
  },
  {
    notice: 'Irritant to mucous membranes.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Baking powder, cakes, bread.',
    id: '254',
    veg: '0',
    name: 'Ammonium carbonate',
    info: 'Generates carbon dioxide gas during the baking process and this causes cakes and bread to rise.',
    code: '503',
    category_id: '5',
    url: 'http://e-additives.herokuapp.com/additives/503',
    function: 'pH regulator',
  },
  {
    notice: 'May trigger gout.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'May be used in any food.',
    id: '314',
    veg: '0',
    name: 'Calcium guanylate',
    info: 'Derived from a naturally-found nuceotide (component of DNA) that is commercially synthesised for use as a food additive.',
    code: '629',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/629',
    function: 'flavour enhancer',
  },
  {
    notice: 'Can cause nausea, vomiting, diarrhea, abdominal cramps.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Variety of foods as a flavour enhancer, salt substitute.',
    id: '307',
    veg: '0',
    name: 'Monopotassium glutamate',
    info: 'Derived from a naturally-occuring amino acid. Commercially produced by the fermentation of bacteria.',
    code: '622',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/622',
    function: 'flavour enhancer',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Used in foods as a sugar replacement.',
    id: '360',
    veg: '',
    name: 'Sucralose',
    info: 'Derived from sugar (sucrose) but modified so that it is not absorbed into the body. Used as a low calorie sweetener and substitute for sugar.',
    code: '955',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/955',
    function: 'Sweetener.',
  },
  {
    notice: 'Possible contact allergy.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Processed cheese, confectionery, salad dressing, jams, yoghurt.',
    id: '192',
    veg: '0',
    name: 'Tragacanth',
    info: 'A naturally occuring polysaccharide that is collected from the stems of the tragacanth bush.',
    code: '413',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/413',
    function: 'emulsifier',
  },
  {
    notice: 'Can cause nausea, flatulence and cramps.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods:
      'Coleslaw, dried soups, brown sauce, ice cream, yoghurt, fruit drinks.',
    id: '191',
    veg: '0',
    name: 'Guar gum',
    info: 'Polysaccharide obtained from the seeds of the Cluster bean plant. Can be used in foods for diabetics to assist in the control of blood sugar levels.',
    code: '412',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/412',
    function: 'stabiliser',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Tinned fish.',
    id: '180',
    veg: '0',
    name: 'Calcium disodium EDTA',
    info: 'Chelating agents attract ions such as copper, zinc and iron. They trap the ions and prevent them from reacting which could make the food go rancid.',
    code: '385',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/385',
    function: 'sequestrant',
  },
  {
    notice:
      'May be hazardous to your health, determined to cause cancer in laboratory animals.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Soft drinks, sugar substitutes.',
    id: '359',
    veg: '0',
    name: 'Saccharin and its Na, K and Ca salts',
    info: 'One of the first artificial sweeteners.',
    code: '954',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/954',
    function: 'sweetener',
  },
  {
    id: '184',
    code: '403',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Ammonium alginate',
    status: 'Warning',
    veg: '0',
    function: 'emulsifier',
    foods: 'Icing sugar.',
    notice: '',
    info: 'Derived from brown sea weed.',
    url: 'http://e-additives.herokuapp.com/additives/403',
  },
  {
    notice: 'Avoid it, banned in some countries.',
    status: 'Hazard',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Cakes, desserts, milk substitutes.',
    id: '204',
    veg: '1',
    name: 'Polysorbate 20',
    info: 'Emulsifiers help to prevent fats from separating out of solutions. This property is useful in artificial milks such as coffee creamers.',
    code: '432',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/432',
    function: 'emulsifier',
  },
  {
    notice:
      'Some people may be allergic to it. This allergy can take the form of asthma and breathing issues, which can be serious. If you are allergic to locust bean gum, you should avoid it and all carob-containing foods.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Tinned vegetables, processed cream, cakes, fruit pie fillings, salad cream.',
    id: '190',
    veg: '0',
    name: 'Locust bean gum; carob gum',
    info: 'Polysaccharide obtained from the seeds of the Carob tree. Frequently used as a caffeine-free chocolate substitute; may lower cholesterol levels.',
    code: '410',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/410',
    function: 'emulsifier',
  },
  {
    notice: 'Linked to toxic hazards, including ulcers and cancer.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Milk drinks, ice cream, biscuits, jam, processed meats, pastries.',
    id: '188',
    veg: '0',
    name: 'Carrageenan',
    info: 'Mixture of polysaccharides produced from a variety of red sea weeds.',
    code: '407',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/407',
    function: 'emulsifier',
  },
  {
    notice:
      'Large quantities can cause headaches, thirst, nausea and high blood sugar levels.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Confectionery, drinks, desserts.',
    id: '200',
    veg: '1',
    name: 'Glycerol',
    info: 'Glycerol is a humectant. That means it is added to foods like fruit gums to prevent them from drying out. It can also be used to dissolve other flavours before adding them to the food.',
    code: '422',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/422',
    function: 'sweetener; humectant',
  },
  {
    id: '207',
    code: '435',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Polysorbate 60',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Confectionery, bread, ice cream, sweets.',
    notice: '',
    info: 'Complex mixture of esters of sorbitol.',
    url: 'http://e-additives.herokuapp.com/additives/435',
  },
  {
    id: '181',
    code: '400',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Alginic acid',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Soft drinks, yoghurt, jam.',
    notice: 'Large quantities can inhibit the absorption of some nutrients.',
    info: 'Obtained from brown sea weed.',
    url: 'http://e-additives.herokuapp.com/additives/400',
  },
  {
    notice:
      'Ferric Ammonium Citrate can affect you when inhaled. Inhaling Ferric Ammonium Citrate can irritate the nose, throat and lungs.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Used as a dietary iron supplement in breakfast cereals and dietary formulas.',
    id: '179',
    veg: '0',
    name: 'Ammonium ferric citrates',
    info: 'Essential mineral, food acid derived from citric acid.',
    code: '381',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/381',
    function: 'acidity regulator',
  },
  {
    id: '201',
    code: '425',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Konjac',
    status: 'Safe',
    veg: '',
    function: 'emulsifier',
    foods: '',
    notice: 'Unpermitted',
    info: 'Tuberous root vegetable. This vegetable is extremely rich in dietary fiber.',
    url: 'http://e-additives.herokuapp.com/additives/425',
  },
  {
    notice: 'Xanthan gum is safe when up to 15 grams per day are taken.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Salad dressing, dairy products, cake mix, coleslaw.',
    id: '194',
    veg: '',
    name: 'Xanthan gum',
    info: 'Obtained by the fermentation of sugar by the bacteria Xanthomonas campestris.',
    code: '415',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/415',
    function: 'stabiliser',
  },
  {
    notice: 'Possible allergen.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Brown sauce, confectionery, ice cream.',
    id: '195',
    veg: '0',
    name: 'Karaya gum',
    info: 'A naturally occuring polysaccharide obtained from the stems of the karaya tree. Major producing regions are North and Central India.',
    code: '416',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/416',
    function: 'emulsifier',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Syrups, sauces, ice cream, fruit drinks, fruit pie fillings.',
    id: '183',
    veg: '0',
    name: 'Potassium alginate',
    info: 'Derived from brown sea weed. More often, sodium alginate (E401) is used in foods.',
    code: '402',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/402',
    function: 'emulsifier',
  },
  {
    id: '186',
    code: '405',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Propane-1,2-diol alginate',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Ice cream, salad dressing, fruit drinks.',
    notice: 'Not permitted in France.',
    info: 'Derived from brown sea weed.',
    url: 'http://e-additives.herokuapp.com/additives/405',
  },
  {
    id: '187',
    code: '406',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Agar',
    status: 'Safe',
    veg: '0',
    function: 'stabiliser',
    foods: 'Ice cream, drinks, cakes, yoghurt.',
    notice:
      'Agar is possibly safe for most adults when taken with at least one 8-ounce glass of water. If it is not taken with enough water, agar can swell and block the esophagus or bowel.',
    info: 'Polysaccharide obtained from certain varieties of sea weed.',
    url: 'http://e-additives.herokuapp.com/additives/406',
  },
  {
    notice: 'Possible allergen, soothes irritations of mucous membranes.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Beer, sweets, tinned vegetables.',
    id: '193',
    veg: '0',
    name: 'Acacia gum; gum arabic',
    info: 'A naturally occuring polysaccharide that is collected from the stems of the acacia bush. Helps to prevent the formation of large sugar crystals in sweets and also retains the froth on beer.',
    code: '414',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/414',
    function: 'emulsifier',
  },
  {
    id: '202',
    code: '430',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Polyoxyethylene stearate',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: '',
    notice: '',
    info: 'Polyoxyethylene stearate is a neutral surfactant, which is permitted for use as the E number food additive E431.',
    url: 'http://e-additives.herokuapp.com/additives/430',
  },
  {
    id: '309',
    code: '624',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '6',
    name: 'Monoammonium glutamate',
    status: 'Safe',
    veg: '0',
    function: 'flavour enhancer',
    foods: 'May be used in any food.',
    notice:
      "The Food and Drug Administration (FDA) has classified MSG as a food ingredient that's generally recognized as safe, but its use remains controversial.",
    info: 'See E623. Helps to bring out the flavours of many foods.',
    url: 'http://e-additives.herokuapp.com/additives/624',
  },
  {
    notice:
      'Possible allergen, not permitted in infant foods, may cause nausea, vomiting.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Sweets, ice cream.',
    id: '199',
    veg: '0',
    name: 'Mannitol',
    info: 'Carbohydrate prepared from the sea weed Manna ash or commercially from glucose.',
    code: '421',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/421',
    function: 'sweetener',
  },
  {
    id: '182',
    code: '401',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Sodium alginate',
    status: 'Safe',
    veg: '0',
    function: 'emulsifier',
    foods: 'Syrups, sauces, ice cream, fruit drinks, fruit pie fillings.',
    notice:
      'No irritant effects have been reported in humans, but occasional skin sensitisation was reported.',
    info: 'Derived from brown sea weed.',
    url: 'http://e-additives.herokuapp.com/additives/401',
  },
  {
    id: '171',
    code: '354',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '3',
    name: 'Calcium tartrate',
    status: 'Safe',
    veg: '0',
    function: 'antioxidant',
    foods: 'Baked goods.',
    notice: '',
    info: 'Calcium salt of tartaric acid. Prevents oxidation.',
    url: 'http://e-additives.herokuapp.com/additives/354',
  },
  {
    notice:
      'May trigger gout, not permitted in foods for infants and young children.',
    status: 'Warning',
    last_update: '2020-07-04T08:01:34+0300',
    foods: 'Dried gravy granules, cured and prepared meats, meat soups.',
    id: '312',
    veg: '0',
    name: 'Disodium guanylate',
    info: 'Derived from a naturally-found nucleotide (component of DNA) that is commercially synthesised for use as a food additive.',
    code: '627',
    category_id: '6',
    url: 'http://e-additives.herokuapp.com/additives/627',
    function: 'flavour enhancer',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Yoghurt, cream cheese, ice cream, tinned vegetables, pasteurised cream.',
    id: '185',
    veg: '0',
    name: 'Calcium alginate',
    info: 'Derived from brown sea weed.',
    code: '404',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/404',
    function: 'emulsifier',
  },
  {
    id: '208',
    code: '436',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Polysorbate 65',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Bread, pastries, frozen desserts.',
    notice: '',
    info: 'Complex mixture of esters of sorbitol.',
    url: 'http://e-additives.herokuapp.com/additives/436',
  },
  {
    notice: 'May interfere with liver and pancreas function.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: 'Cheese spread.',
    id: '178',
    veg: '0',
    name: 'Triammonium citrate',
    info: 'Helps to keep maintain the correct consistency of cheese spreads.',
    code: '380',
    category_id: '3',
    url: 'http://e-additives.herokuapp.com/additives/380',
    function: 'pH regulator; emulsifier',
  },
  {
    notice:
      "It expressed concern about the potential promotion of colon carcinogenesis by carrageenans and processed Eucheuma seaweed and therefore made the group ADI ‘not specified'",
    status: 'Warning',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Milk drinks, ice cream, biscuits, jam, processed meats, pastries.',
    id: '189',
    veg: '0',
    name: 'Processed eucheuma seaweed',
    info: 'Mixture of polysaccharides produced from a variety of sea weeds.',
    code: '407a',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/407a',
    function: 'emulsifier',
  },
  {
    id: '206',
    code: '434',
    last_update: '2020-07-04T08:01:33+0300',
    category_id: '4',
    name: 'Polysorbate 40',
    status: 'Hazard',
    veg: '1',
    function: 'emulsifier',
    foods: 'Confectionery, ice cream.',
    notice: 'Avoid it, banned in some countries.',
    info: 'Complex mixture of esters of sorbitol.',
    url: 'http://e-additives.herokuapp.com/additives/434',
  },
  {
    notice:
      'Not permitted in foods for infants and young children, can cause gastric disturbance.',
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods:
      'Sweets, ice cream, cakes, chocolates, some artificially sweetened drinks.',
    id: '198',
    veg: '0',
    name: 'Sorbitol; Sorbitol syrup',
    info: 'Sorbitol syrup is produced commercially from glucose. It can help to reduce the formation of sugar crystals in food and maintain the texture of chewy sweets.',
    code: '420',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/420',
    function: 'sweetener',
  },
  {
    notice:
      "It has 'Adequate Daily Intake (ADI) not specified' status by JECFA, which is the highest safety category. Toxnet has reported no toxic effects related to tara gum.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:32+0300',
    foods: '',
    id: '196',
    veg: '0',
    name: 'Tara gum',
    info: 'Polysaccharide which is a good stabiliser for use in dairy products. Derived from the Tara bush, Caesalpinia Spinosa is indigenous to Ecuador and Peru and is grown in Kenya.',
    code: '417',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/417',
    function: 'stabiliser',
  },
  {
    id: '205',
    code: '433',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Polysorbate 80',
    status: 'Safe',
    veg: '1',
    function: 'emulsifier',
    foods: 'Bread, pastries, ice cream.',
    notice: '',
    info: 'Complex mixture of esters of sorbitol.',
    url: 'http://e-additives.herokuapp.com/additives/433',
  },
  {
    notice: '',
    status: 'Safe',
    last_update: '2020-07-04T08:01:34+0300',
    foods:
      'Variety of foods during their packagaing and transport. Used in freezing and vacuum packing.',
    id: '348',
    veg: '',
    name: 'Nitrogen',
    info: 'Inert gas that helps to prevent oxidation and microbials growth.',
    code: '941',
    category_id: '8',
    url: 'http://e-additives.herokuapp.com/additives/941',
    function: 'propellant',
  },
  {
    notice:
      "Because it's typically used in small amounts, it's unlikely to cause problems.",
    status: 'Safe',
    last_update: '2020-07-04T08:01:33+0300',
    foods: 'Jellies, confectionery, low calorie drinks.',
    id: '197',
    veg: '',
    name: 'Gellan gum',
    info: 'A polysaccharide obtained by fermentation using the bacteria Sphingomonas elodea.',
    code: '418',
    category_id: '4',
    url: 'http://e-additives.herokuapp.com/additives/418',
    function: 'emulsifier',
  },
  {
    id: '351',
    code: '943b',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Iso-butane',
    status: 'Safe',
    veg: '',
    function: 'propellant',
    foods: '',
    notice: '',
    info: 'To be used quantum satis as a gas propellant only in vegetable oil pan spray (for professional use only) and water‐based emulsion spray according to Regulation (EC) No 1333/2008.',
    url: 'http://e-additives.herokuapp.com/additives/943b',
  },
  {
    id: '203',
    code: '431',
    last_update: '2020-07-04T08:01:32+0300',
    category_id: '4',
    name: 'Polyoxyethylene (40) stearate',
    status: 'Warning',
    veg: '1',
    function: 'emulsifier',
    foods: 'Bread',
    notice:
      'According to a study published in the International Journal of Toxicology, PEGs (including Polyoxyl 40 Stearate) can contain harmful impurities, including: Ethylene Oxide, known to increase the incidences of uterine and breast cancers and of leukemia and brain cancer.',
    info: 'Used to give bread a soft texture.',
    url: 'http://e-additives.herokuapp.com/additives/431',
  },
  {
    id: '350',
    code: '943a',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Butane',
    status: 'Safe',
    veg: '',
    function: 'propellant',
    foods: '',
    notice:
      ' The toxicity of butane is low. Huge exposure concentrations can be assumed in butane abuse. The predominant effects observed in abuse cases are central nervous system (CNS) and cardiac effects.',
    info: 'Butane is a gas at room temperature and atmospheric pressure. Butane is highly flammable, colorless, easily liquefied gas that quickly vaporize at room temperature.',
    url: 'http://e-additives.herokuapp.com/additives/943a',
  },
  {
    id: '352',
    code: '944',
    last_update: '2020-07-04T08:01:34+0300',
    category_id: '8',
    name: 'Propane',
    status: 'Safe',
    veg: '',
    function: 'propellant',
    foods: '',
    notice: '',
    info: 'Hydrocarbon gas.',
    url: 'http://e-additives.herokuapp.com/additives/944',
  },
  {
    id: '347',
    code: '939',
    last_update: '2020-07-04T08:01:35+0300',
    category_id: '8',
    name: 'Helium',
    status: 'Warning',
    veg: '',
    function: 'packaging gas',
    foods: 'Variety of foods during their packagaing and transport.',
    notice:
      'Helium displaces oxygen in your lungs when you inhale it, which can cause suffocation and dangerous inhalants now include helium.',
    info: 'Inert gas that helps to prevent oxidation and microbials growth.',
    url: 'http://e-additives.herokuapp.com/additives/939',
  },
];
