# Unity Script Collection
A maintained collection of **useful** & **free** unity scripts / libraries / plugins and extensions.

If you want to suggest a link, then read the [Contribution Guidelines](CONTRIBUTING.md) first.
Please report broken links, outdated assets and spelling mistakes. The links are in no particular order. This list is licensed under the [GNU General Public License v3.0](LICENSE) and does only apply to this repository.

Navigation:
- [GameObjects & Transforms](#gameobjects--transforms)
- [Movement & Animation](#movement--animation)
- [Controls & Input](#controls--input)
- [Character Controller](#character-controller)
- [AI & Pathfinding](#ai--pathfinding)
- [Physics](#physics)
- [Particles](#particles)
- [Meshes & Construction](#meshes--construction)
- [Materials & Shading](#materials--shading)
- [2D](#2d)
- [Networking](#networking)
- [VR](#vr)
- [Sound & Music](#sound--music)
- [UI](#ui)
- [Post-Processing & Rendering](#post-processing--rendering)
- [Mobile](#mobile)
- [Debug](#debug)
- [Editor](#editor)
  - [Tools](#tools)
  - [Editors](#editors)
  - [Inspector Extensions](#inspector-extensions)
  - [Importer](#importer)
- [Serialization & Web](#serialization--web)
- [Social SDKs](#social-sdks)
- [API Extensions & Helper](#api-extensions--helper)
- [Design Patterns](#design-patterns)
- [Utilities](#utilities)
- [Other](#other)


## GameObjects & Transforms
* [RecyclerKit](https://github.com/prime31/RecyclerKit) - pooling system.
* [UnityOctree](https://github.com/Nition/UnityOctree) - octrees.
* [In-Game Replay System](https://github.com/FeNo/InGameReplay) - record and replay transforms.
* [Unity Scene Query](https://github.com/Real-Serious-Games/Unity-Scene-Query) - library to traverse and query the Unity scene to find particular objects.
* [Unity3DRuntimeTransformGizmo](https://github.com/HiddenMonk/Unity3DRuntimeTransformGizmo) - Another runtime transform gizmo.

## Movement & Animation
* [List View Framework](https://bitbucket.org/Unity-Technologies/list-view-framework) - create dynamic, scrollable lists.
* [Reaktion](https://github.com/keijiro/Reaktion) - audio reaction toolkit.
* [DOTween](https://github.com/Demigiant/dotween) - tween engine.
* [Camera Path Creator](https://www.assetstore.unity3d.com/en/#!/content/84074) - create complex camera paths.
* [Cinemachine BaseRig](https://www.assetstore.unity3d.com/en/#!/content/79898) - procedural camera system.
* [UnitySpritesAndBones](https://github.com/Banbury/UnitySpritesAndBones) - skeletal sprite animations.
* [spine-unity](https://github.com/EsotericSoftware/spine-runtimes/tree/master/spine-unity) - import spine animations.
* [ikccd](https://github.com/sunilnayak133/ikccd) - IK Solver using Cyclic Coordinate Descent.
* [Aim-IK](https://github.com/ehsan-mohammadi/Aim-IK) - Procedural orientate character head (and chest) in a direction without using any animation data.
* [RecordAndRepeat](https://github.com/fx-lange/unity-record-and-repeat) - Record and playback of custom data via the timeline.

## Controls & Input
* [InputManager](https://github.com/daemon3000/InputManager) - a powerful input manager.
* [TouchScript](https://github.com/TouchScript/TouchScript) - multitouch library.

## Character Controller
* [Unity 2D Platformer Controller](https://github.com/cjddmut/Unity-2D-Platformer-Controller) - 2d platformer character controller.
* [CharacterController2D](https://github.com/prime31/CharacterController2D) - 2d character controller.
* [SuperCharacterController](https://github.com/IronWarrior/SuperCharacterController) - 3d character controller.

## AI & Pathfinding
* [A Star Pathfinding for Platformers](https://github.com/tutsplus/A-Star-Pathfinding-for-Platformers) - A* for platformers.
* [Astar for Unity](https://github.com/sharpaccent/Astar-for-Unity) - A* pathfinding.
* [A* Pathfinding Project](http://arongranberg.com/astar/) - A* pathfinding.
* [UnitySteer](https://github.com/ricardojmendez/UnitySteer) - steering, obstacle avoidance and path following behaviors.
* [SimpleTraffic](https://github.com/Kink3d/SimpleTraffic) - a simple traffic simulation using Nav Mesh.
* [Self-driving-vehicle](https://github.com/Habrador/Self-driving-vehicle) - Car pathfinding using Hybrid A* search algorithm.
* [GOAP](https://github.com/crashkonijn/GOAP) - Multithreaded Goal Oriented Action Planner for Unity.
* [DotRecast](https://github.com/ikpil/DotRecast) - a port of Recast & Detour, navigation mesh toolset for games, Unity3D, servers, C#.

## Physics
* [Mario Galaxy Gravity for Unity](https://gist.github.com/phosphoer/a283cdbeca5d2160d5eed318d0362826) - mario galaxy gravity.
* [Ocean Community Next Gen](https://github.com/eliasts/Ocean_Community_Next_Gen) - water physics/shader.
* [Voxel GPU Physics](https://github.com/jknightdoeswork/gpu-physics-unity) - GPU accelerated voxel physics.
* [Interactive Erosion](https://github.com/Scrawk/Interactive-Erosion) - Runtime fluid erosion for terrain. 

## Particles
* [KvantSpray](https://github.com/keijiro/KvantSpray) - gpu accelerated particles.
* [NVIDIA Hair Works Integration](https://github.com/unity3d-jp/NVIDIAHairWorksIntegration) - Nvidia hair works.
* [Ember Particles](https://twitter.com/Der_Kevin/status/832545397109309440) - turbulent ember particles.
* [SPHFluid](https://github.com/MangoSister/SPHFluid) - Interactive 3D Fluid Simulation based on SPH.

## Meshes & Construction
* [ProceduralToolkit](https://github.com/Syomus/ProceduralToolkit) - procedural mesh toolkit/generator. 
* [Draw](https://gist.github.com/nothke/82dccc121457541fcce32aea7744618a) - draws primitives with lines.
* [VolumetricLinesUnity](https://github.com/johannesugb/VolumetricLinesUnity) - volumetric lines.
* [giles](https://github.com/procore3d/giles) - 3d runtime level editor.
* [Voxelmetric](https://github.com/Voxelmetric/Voxelmetric) - voxel framework.
* [Procedural Shapes for Unity](https://bitbucket.org/alexzzzz/procedural-shapes-for-unity) - procedural shapes.
* [ICO Sphere Mesh Creator](https://github.com/kaiware007/IcoSphreCreator) - procedural ico spheres.
* [Vertex Painter](https://github.com/slipster216/VertexPaint) - paint information onto vertices.
* [FacePaint](https://github.com/SixWays/FacePaint) - paint triangles of meshes.
* [Simplygon](https://www.assetstore.unity3d.com/en/?&_ga=1.224491866.1155275539.1473983191#!/content/10144) - mesh optimization & lod generation.
* [TextMesh Pro](https://www.assetstore.unity3d.com/en/#!/content/17662) - generate text with custom styling.
* [meshcombinewizard](https://github.com/sirgru/MeshCombineWizard) - combines all meshes on the chosen gameObject and its children that share the same material.
* [RoadArchitect](https://github.com/MicroGSD/RoadArchitect) - road system creator featuring dynamic intersections, bridges, etc.
* [DrawLine](https://github.com/geniikw/drawLine) - procedural line mesh tool.
* [Deform](https://github.com/keenanwoodall/Deform) - a framework for deforming meshes in the editor and at runtime in Unity.
* [2.5D Destruction](https://github.com/Nesh108/Unity-2.5D-Destruction) - breaks 2D sprites into 2.5D fragments.
* [MetaBalls Liquids](https://github.com/Nesh108/Unity_MetaBalls_Liquids) - liquid simulation using MetaBalls.

## Materials & Shading
* [Projects by RM](https://www.assetstore.unity3d.com/en/#!/content/21648) - wet surface & skin shader.
* [Ocean Community Next Gen](https://github.com/eliasts/Ocean_Community_Next_Gen) - water physics/shader.
* [Flow Map Shader](https://gist.github.com/TarasOsiris/e0e6e6c3b8fdb0d8074b) - flow map shader working with sprites.
* [VertexPaint](https://github.com/slipster216/VertexPaint) - additional vertex streams.
* [ShaderProject](https://github.com/ellioman/ShaderProject) - shader collection.
* [Skybox Plus](https://github.com/keijiro/SkyboxPlus) - a collection of skybox shaders.
* [Outline Shader](https://gist.github.com/michidk/3b49362e21563a1d66d52f4cf4bdc7ce) - outline shader which accomodates screen width and camera distance.
* [Unity Sprite Uber Shader](https://github.com/traggett/UnitySpriteShaders) - 3D shading for sprites (e.g. normal mapping).
* [Low Poly Shaders](https://github.com/BrokenVector/LowPolyShaders) - material shaders optimized for Low Poly stylized meshes.
* [Lux Shader Framework](https://github.com/larsbertram69/Lux-2.02-Personal) - Lux 2.02 pbr Shader Framework.
* [Unity Wireframe Shaders](https://github.com/Chaser324/unity-wireframe) - general purpose wireframe shaders.
* [Hologram Shader](https://github.com/andydbc/HologramShader) - simple hologram shader.
* [Kamakura Shaders](https://github.com/kayac/kamakura-shaders/) - a collection of shaders and components focusing on Non-Photorealistic Rendering.
* [Facepunch.Highlight](https://github.com/Facepunch/Facepunch.Highlight) - Mesh outline effect.

## 2D
* [UnitySVG](https://github.com/MrJoy/UnitySVG) - svg renderer.
* [UnityStbEasyFont](https://github.com/aras-p/UnityStbEasyFont) - text mesh generator.
* [SpriteLightKit](https://github.com/prime31/SpriteLightKit) - 2d sprite lights.
* [2D Light of Sight Unity](https://github.com/f15gdsy/2D-Light-of-Sight-Unity) - 2d flat geometric lightning.
* [Unity Sprite Uber Shader](https://github.com/traggett/UnitySpriteShaders) - 3D shading for sprites (e.g. normal mapping).
* [Fungus](https://github.com/snozbot/fungus) - 2d interactive storytelling game framework.
* [PolyMesh](https://github.com/UnityPatterns/PolyMesh) - 2d shape editor.
* [Unity Tilemap](https://github.com/toinfiniityandbeyond/unity-tilemap) - 2D tilemap editor.
* [2D Extras](https://github.com/Unity-Technologies/2d-extras) - reusable 2d scripts (tilemaps, etc.).
* [Vector Graphics Samples](https://github.com/Unity-Technologies/vector-graphics-samples) - samples of the Vector Graphics features to be used with Unity 2018.1 and newe.

## Networking
* [UNet Authoritative Networking](https://github.com/atrakeur/unity-unet-authoritative-networking) - authoritative networking implementation.
* [MLAPI](https://github.com/MidLevel/MLAPI) An alternative to Unity's UNET high level API, allows for separate server/client projects and more.
* [Barebones Master Server](https://github.com/alvyxaz/barebones-masterserver) - Host your own custom master server setup, avoid CCU fees.
* [Fish-Net](https://github.com/FirstGearGames/FishNet) - free networking solution built from ground up with synchronization of states and logic
* [PlayFab](https://github.com/PlayFab) - PlayFab is a backend-as-a-service for games. Provides SDK's too.
* [UGS- Unity Gaming Services](https://unity.com/solutions/gaming-services) - A complete service ecosystem for live games

## VR
* [SteamVR](https://github.com/ValveSoftware/steamvr_unity_plugin) - VR SDK.
* [The Lab Renderer](https://www.assetstore.unity3d.com/en/#!/content/63141) - VR renderer by Valve.
* [VRTK](https://github.com/thestonefox/VRTK) - contains useful scripts for building VR games.
* [NewtonVR](https://github.com/TomorrowTodayLabs/NewtonVR) - VR physics and interactions.
* [Cutie Keys](https://github.com/NormalVR/CutieKeys/) - VR keyboard.
* [Punchkeyboard](https://github.com/rjth/Punchkeyboard) - Another VR keyboard.
* [Hover UI Kit](https://github.com/aestheticinteractive/Hover-UI-Kit) - a complete VR input framework.
* [VRLineRenderer](https://github.com/Unity-Technologies/VRLineRenderer) - glowing lines renderer optimized for VR.

## Sound & Music
* [usfxr](https://github.com/zeh/usfxr) - procedual audio effects.
* [Reaktion](https://github.com/keijiro/Reaktion) - audio reaction toolkit (mac only).
* [DefaultMicrophone](https://github.com/GabeBigBoxVR/UnityDefaultMicrophone) - gets the default microphone (windows only).
* [Lasp](https://github.com/keijiro/Lasp) - Low-latency Audio Signal Processing plugin for Unity.
* [Unity-Audio-Manager](https://github.com/MathewHDYT/Unity-Audio-Manager) - Plugin, that allows to easily play/change/stop/mute/... sounds in 2D/3D.

## UI
* [Unity UI Extensions](https://bitbucket.org/ddreaper/unity-ui-extensions) - collection of ui extensions.
* [Book Page Curl](https://github.com/Dandarawy/Unity3DBookPageCurl) - page curl transition.
* [Open Pause Menu](https://github.com/GreatArcStudios/unitypausemenu) - read-to-use pause menu.
* [Lunar Mobile Console](https://github.com/SpaceMadness/lunar-unity-console) - debug console for mobiles.
* [InfinityScroll](https://github.com/ivomarel/InfinityScroll) - infinite scrollrects.
* [TextMesh Pro](https://www.assetstore.unity3d.com/en/#!/content/17662) - generate text with custom styling.
* [EasyButtons](https://github.com/madsbangh/EasyButtons) - create buttons in the inspector using annotations.
* [UI Extensions](https://bitbucket.org/UnityUIExtensions/unity-ui-extensions) - various NGUI extensions/helper/scripts.
* [NGUI Extensions](https://github.com/kimsama/Unity-NGUIExtension) - a few NGUI extensions.
* [Webview CSharp](https://github.com/kimsama/unity3d-webview-csharp) - render websites.
* [Typogenic](https://github.com/Chman/Typogenic) - an easy to use, fast and high-quality 3D text renderer.
* [unity-debug-overlay](https://github.com/pandr/unity-debug-overlay) - a fast and (almost) garbage free debug overlay.

## Post-Processing & Rendering
* [kode80SSR](https://github.com/kode80/kode80SSR) - screen-space reflections.
* [KinoObscurance](https://github.com/keijiro/KinoObscurance) - screen-space ambient obscurance.
* [SMAA](https://github.com/Chman/SMAA) - subpixel morphological anti-aliasing. 
* [Temporal Reprojection Anti-Aliasing](https://github.com/playdeadgames/temporal) - anti-aliasing solution used in INSIDE.
* [kode80CloudsUnity3D](https://github.com/kode80/kode80CloudsUnity3D) - realtime volumetric clouds.
* [PixelRenderUnity3D](https://github.com/kode80/PixelRenderUnity3D) - pixelized rendering.
* [PixelCamera2D](https://github.com/RyanNielson/PixelCamera2D) - pixel-perfect rendering.
* [KinoMotion](https://github.com/keijiro/KinoMotion) - motion blur using motion vectors.
* [KinoContour](https://github.com/keijiro/KinoContour) - edge detection.
* [KinoMirror](https://github.com/keijiro/KinoMirror) - kaleidoscope effect.
* [KinoFringe](https://github.com/keijiro/KinoFringe) - chromatic aberration.
* [KinoBinary](https://github.com/keijiro/KinoBinary) - 1-bit monochrome effect.
* [KinoFeedback](https://github.com/keijiro/KinoFeedback) - retro framebuffer feedback effect.
* [KinoRamp](https://github.com/keijiro/KinoRamp) - color ramp overlay.
* [KinoSlitscan](https://github.com/keijiro/KinoSlitscan) - slit-scan effect.
* [KinoGlitch](https://github.com/keijiro/KinoGlitch) - glitch effect.
* [KinoDatamosh](https://github.com/keijiro/KinoDatamosh) - datamosh. 
* [unity vhsglitch](https://github.com/staffantan/unity-vhsglitch) - vhs glitch effect.
* [Scanline Shader](https://bitbucket.org/Bitcake-Studio/bitstrap/src/e912c1e939700f42956272290d3e8c293f90c142/Assets/BitStrap/Shaders/Scanline.shader) - scanline effect.
* [KinoFog](https://github.com/keijiro/KinoFog) - global fog. 
* [KinoBloom](https://github.com/keijiro/KinoBloom) - bloom.
* [KinoBokeh](https://github.com/keijiro/KinoBokeh) - bokeh effect. 
* [KinoVignette](https://github.com/keijiro/KinoVignette) - vignette. 
* [KinoVision](https://github.com/keijiro/KinoVision) - frame information visualizer.
* [Unity5Effects](https://github.com/i-saint/Unity5Effects) - post-processing collection.
* [LightShafts](https://github.com/robertcupisz/LightShafts) - light shafts.
* [VolumetricLights](https://github.com/SlightlyMad/VolumetricLights) - volumetric lights.
* [SonarFx](https://github.com/keijiro/SonarFx) - wave patterns. 
* [Cinematic Image Effects](https://bitbucket.org/Unity-Technologies/cinematic-image-effects) - cinematic image effects.
* [Post-processing Stack](https://github.com/Unity-Technologies/PostProcessing) - multiple image effects in one pipeline.
* [Moments](https://github.com/Chman/Moments) - gif recorder.
* [uDesktopDuplication](https://github.com/hecomi/uDesktopDuplication) - realtime screen capture as Texture2D.
* [Heat Distortion Effect](https://twitter.com/minionsart/status/833967666780110849) - a shader which distorts the image behind, using a normal map.
* [Clear Flags Effect](https://github.com/falconmick/ClearFlagsMobile) - Image Effect to reproduce the Clear Flags camera effect.
* [DeLightingTool](https://github.com/Unity-Technologies/DeLightingTool) - tool to remove lighting information from textures in a photogrammetry asset pipeline.
* [unity-lut-generator](https://github.com/mattatz/unity-lut-generator) - LookUpTable generator for Unity.
* [SEGI](https://github.com/sonicether/SEGI) - Sonic Ether's voxel-based global illumination system.
* [Aura](https://github.com/raphael-ernaelsten/Aura) - a local simulation of the light scattering into the surrounding medium.

## Mobile
* [Toast](https://gist.github.com/TarasOsiris/dec42cf3ecca6c854182f385e38dbf57) - android toast notifications.
* [FBSucks](https://gist.github.com/PhannGor/b8eec5911913d7e6eac6) - android share image & text.
* [UnityShowAndroidStatusBar](https://github.com/Over17/UnityShowAndroidStatusBar) - android show statusbar.
* [Google VR SDK](https://github.com/googlevr/gvr-unity-sdk) - google mobile vr sdk.
* [Unity Webview](https://github.com/gree/unity-webview) - webview overlay.
* [CUDLR](https://github.com/proletariatgames/CUDLR) - remote debugging and logging console.
* [Simplygon](https://www.assetstore.unity3d.com/en/?&_ga=1.224491866.1155275539.1473983191#!/content/10144) - mesh optimization & lod generation.

## Debug
* [uREPL](https://github.com/hecomi/uREPL) - runtime evaluation of c# expressions.
* [UberLogger](https://github.com/bbbscarter/UberLogger) - advanced logging API, improved editor console & ingame console.
* [Unity File Debug](https://github.com/Sacred-Seed-Studio/Unity-File-Debug) - enhanced Debug.Log with file export and web viewer.
* [Immediate Window](https://docs.unity3d.com/Packages/com.unity.immediate-window@latest/index.html) -- Type code and get immediate feedback with object inspection like chrome console debugger.
* [Consolation](https://github.com/mminer/consolation) - in-game debug console.

## Editor
### Tools
* [Favorites List](https://github.com/BrokenVector/favorites-list) - mark objects/scenen/assets as favorites to return to them quickly.
* [REX Diagnostics](https://thorgeirk11.github.io/REX-Diagnostics/) - runtime evaluation of c# expressions.
* [Better Defines](https://github.com/TarasOsiris/Better-Defines) - platform dependent preprocessor directive manager.
* [MissingReferencesUnity](https://github.com/liortal53/MissingReferencesUnity) - find missing references.
* [Unity Resource Checker](https://github.com/handcircus/Unity-Resource-Checker) - resource analyzer.
* [Asset Usage Detector](https://github.com/yasirkula/UnityAssetUsageDetector) - checks if an asset is used in code and/or scene files.
* [Compile Time Tracker](https://github.com/DarrenTsung/compile-time-tracker) - compile time tracker.
* [UnityStudio](https://github.com/RaduMC/UnityStudio) - unity asset export tool.
* [Screen Shooter](https://github.com/PhannGor/Screen-Shooter) - takes screenshots with multiple resolutions at once.
* [Script Templates for Unity](https://bitbucket.org/rotorz/script-templates-for-unity) - script templates.
* [Unity 2D Destruction](https://github.com/mjholtzem/Unity-2D-Destruction) - sprite destruction.
* [CurveTexture](https://github.com/slipster216/CurveTexture) - bake curves into texture. 
* [Unity3D Rainbow Folders](https://github.com/PhannGor/unity3d-rainbow-folders) - folder icons.
* [Unity Themes](https://github.com/zios/unity-themes) - editor themes.
* [Tree Randomizer](https://www.assetstore.unity3d.com/en/#!/content/59228) - randomize unity trees.
* [Render Settings Duplicator](https://www.assetstore.unity3d.com/en/#!/content/58831) - clones the render settings from one scene to another.
* [Piviot Transform Helper](https://twitter.com/talecrafter/status/780812894502084609) - adds piviot creation shortcuts to the context menu.
* [ScriptExecutionOrder Attribute](https://gist.github.com/Skybladev2/d0d029716b1651cc1947) - attribute to specify execution order.
* [Simple Editor Shortcuts Tools Collection](https://github.com/sirgru/Unity-Simple-Editor-Shortcuts-Tools-Collection) - small collection of simple tools to help in scene editing workflows.
* [Mulligan Renamer](https://github.com/redbluegames/unity-mulligan-renamer) - bulk renaming tool for game objects and assets.
* [BitField Attribute](https://github.com/lee-io/BitField-Attribute) - Enable bit field masking from the Unity Editor.
* [ScriptableObject Menu](https://github.com/lee-io/ScriptableObject-Menu) - Create ScriptableObjects from the Unity Editor.
* [StableDiffusionUnityTools](https://github.com/KonH/StableDiffusionUnityTools) - Editor assets generation via Stable Diffusion.

### Editors
* [Brainiac](https://github.com/daemon3000/Brainiac) - behaviour tree & (behaviour-)node-based visual editor.
* [Node Editor](https://github.com/Baste-RainGames/Node_Editor) - (calculation-)node editor.
* [BrotherhoodOfNode](https://github.com/aphex-/BrotherhoodOfNode/) - (more graphical-)node editor for visual things.
* [VisualNoiseDesigner](https://github.com/x0r04rg/VisualNoiseDesigner) - visual noise designer.
* [SimpleGeo](https://gist.github.com/phosphoer/8cccb00e20d9892af1438a795779bee0) - simple geometry painter.
* [Curves and Splines](http://catlikecoding.com/unity/tutorials/curves-and-splines/) - curve & spline editor.
* [Unity 2D Joint Editors](https://github.com/toxicFork/Unity-2D-Joint-Editors) - 2d joint editors.
* [PolyMesh](https://github.com/UnityPatterns/PolyMesh) - 2d shape editor.
* [VertexPaint](https://github.com/slipster216/VertexPaint) - vertex data painter.
* [SabreCSG](https://github.com/sabresaurus/SabreCSG) - a set of level design tools for building complex levels.
* [Unity Tilemap](https://github.com/toinfiniityandbeyond/unity-tilemap) - 2D tilemap editor.
* [Node Editor Framework](https://github.com/Seneral/Node_Editor_Framework) - Node Editor Framework for creating node based displays and editors.
* [Unity Event Visualizer](https://github.com/MephestoKhaan/UnityEventVisualizer) - graph editor for viewing all UnityEvents.
* [Runtime Node editor](https://github.com/cemuka/UnityRuntimeNodeEditor) - Unity runtime node editor using with Unity UI.

### Inspector Extensions
* [Reorderable Lists](https://bitbucket.org/rotorz/reorderable-list-editor-field-for-unity) - reorderable list field.
* [Ordered Dictionary](https://bitbucket.org/rotorz/ordered-dictionary-asset-for-unity) - ordered dictionary field.
* [ClassTypeReference](https://bitbucket.org/rotorz/classtypereference-for-unity) - class type reference field.
* [Unity3D ExtendedEvent](https://github.com/Thundernerd/Unity3D-ExtendedEvent) - extended event selector.
* [Property Drawer Collection](https://github.com/anchan828/property-drawer-collection) - collection of property drawers.
* [Node Inspector](https://github.com/nicloay/Node-Inspector) - node based inspector.
* [ColorBands](https://github.com/rstecca/ColorBands) - color bands.
* [QuickEvent](https://www.assetstore.unity3d.com/en/#!/content/53869) - persistent event handlers with static or dynamic values.
* [Reorder Components](https://twitter.com/mrpodunkian/status/715309192886624256) - reorder components on your GameObjects.
* [AwesomeComponent](https://gist.github.com/nicoplv/df3368eb38849a3f76a97fc27ba8ca62) - auto load assets on SerializedFields.
* [ScenePreview Inspector](http://diegogiacomelli.com.br/unity3d-scenepreview-inspector/) - view scene preview in inspector.

### Importer
* [Unity Excel Importer Maker](https://github.com/tsubaki/Unity-Excel-Importer-Maker) - excel.
* [Unity Psd Importer](https://github.com/ChemiKhazi/UnityPsdImporter) - advanced psd import.

## Serialization & Web
* [Full Serializer](https://github.com/jacobdufault/fullserializer) - custom serializer.
* [Json.Net](https://github.com/SaladLab/Json.Net.Unity3D) - Newtonsoft Json.NET.
* [SQLite4Unity3d](https://github.com/codecoding/SQLite4Unity3d) - sql lite.
* [UnityHTTP](https://github.com/andyburke/UnityHTTP) - http library.
* [Unity QuickSheet](https://github.com/kimsama/Unity-QuickSheet) - import data from google/excel sheets.
* [Odin Unity Serializer](https://github.com/TeamSirenix/odin-serializer) - Arguably the best serializer for Unity out there.

## Social SDKs
* [Google Analytics Plugin](https://github.com/googleanalytics/google-analytics-plugin-for-unity) - Google Analytics.
* [Google Play Games Plugin](https://github.com/playgameservices/play-games-plugin-for-unity) - Google Play plugin.
* [Facebook SDK](https://github.com/facebook/facebook-sdk-for-unity) - Facebook sdk.
* [Reign Unity Plugin](https://github.com/reignstudios/Reign-Unity-Plugin5) - unified mobile api.
* [GetSocial SDK](https://github.com/getsocial-im/getsocial-unity-sdk) - community api.
* [SOOMLA Framework](https://github.com/soomla/unity3d-store) - store api.
* [Steamworks.NET](https://github.com/rlabrecque/Steamworks.NET) - c# wrapper for valve's Steamworks API.
* [Facepunch.Steamworks](https://github.com/Facepunch/Facepunch.Steamworks) - Steamworks C# API (not all features implemented, but better API).
* [twitter-for-unity](https://github.com/toofu37/twitter-for-unity) - Twitter API Client for Unity.

## API Extensions & Helper
* [Camera Extension](https://gist.github.com/TarasOsiris/a8904989c18424bcdf73) - a better way of manipulating the culling mask.
* [Download Manager](https://gist.github.com/asus4/2490117) - simple file downloads.
* [UnityMainThreadDispatcher](https://github.com/PimDeWitte/UnityMainThreadDispatcher) - main thread dispatcher.
* [UnityBitmapDrawing](https://github.com/ProtoTurtle/UnityBitmapDrawing) - texture2d drawing extensions.
* [Unity3D ComponentAttribute](https://github.com/Thundernerd/Unity3D-ComponentAttribute) - auto component referencing.
* [Unity3D ExecutionOrderAttribute](https://github.com/Thundernerd/Unity3D-ExecutionOrderAttribute) - execution order attribute.
* [LINQ to GameObject for Unity](https://github.com/neuecc/LINQ-to-GameObject-for-Unity) - gameobject linq querys.
* [Chained Works](https://bitbucket.org/snippets/Lordinarius/8rnLn/chainedworks) - coroutine chained procedures. 
* [TeaTime](https://github.com/alvivar/TeaTime) - timer queue for coroutines.
* [Smart Tags and Layers](https://github.com/nicoplv/smart-tags-and-layers) - generates static values for your tags and layers.
* [DTValidator](https://github.com/DarrenTsung/DTValidator) - finds broken and unassigned references.
* [xNode](https://github.com/Siccity/xNode) - easily create node-based plugins.

## Design Patterns
* [Unity Singleton MonoBehaviour](https://github.com/kleber-swf/Unity-Singleton-MonoBehaviour) - powerful singleton.
* [Signals](https://github.com/UnityPatterns/Signals) - simple event/signal system.
* [Unity3d Finite State Machine](https://github.com/thefuntastic/Unity3d-Finite-State-Machine) - simple finite stata machine.
* [stateless](https://github.com/StompyRobot/stateless) - more complex state machines.
* [Design Patterns in Unity Example](https://github.com/marwie/Design-Patterns-in-Unity-Example) - collection of design patterns.
* [Entitas CSharp](https://github.com/sschmid/Entitas-CSharp) - entity component system framework. 
* [strangeioc](https://github.com/strangeioc/strangeioc) - inversion of control framework. 
* [Zenject](https://github.com/modesttree/Zenject) - depedency injection framework. 
* [UniRx](https://github.com/neuecc/UniRx) - unity reactive extensions implementation.
* [Stateless](https://github.com/Patroklo/stateless) - Fork of Stateless dot net statemachine for .Net 3.5.
* [UniTask](https://github.com/Cysharp/UniTask) - An efficient allocation free async/await integration for Unity.
* [UniState](https://github.com/bazyleu/UniState) - Code architecture framework for Unity, designed around State pattern.

## Utilities
* [demilib](https://github.com/Demigiant/demilib) - various utilities and tools for Unity.
* [Excessives](https://github.com/SirHall/Excessives) - General purpose C# and Unity3D utility scripts.

## Other
* [Unity Right Click](https://gist.github.com/adamtuliper/48a6e2ce3d9b5e72be36) - windows context menu extension: 'open with unity'.
* [No Hot-Reload](https://capeguy.co.uk/2015/06/no-more-unity-hot-reload/) - prevent unity hot-reloads.
* [Unity C# 5.0 and 6.0 Integration](https://bitbucket.org/alexzzzz/unity-c-5.0-and-6.0-integration) - c# 5 & 6 integration for unity.
* [FLUnity](https://github.com/canab/flunity) - flash to unity.
* [Projeny](https://github.com/modesttree/projeny) - project management. 
* [CUDLR](https://github.com/proletariatgames/CUDLR) - remote debugging and logging console.
* [WebGL - Simple Loading Fix](http://designagame.eu/2016/09/is-unity-webgl-loading-a-simple-fix/) - custom loading bar for the webgl loader.
* [UtilityKit](https://github.com/prime31/UtilityKit) - SerializationUtil, SpriteAnimator, SpriteAnimator, MathHelpers, AutoSnap, ...
* [Remove Boo.Lang and UnityScript Hints](https://gist.github.com/jbevain/a982cc580fb796c93e4e) - Project Generation Hook to remove references to Boo.Lang and UnityScript assemblies.
* [Asset Store Batch Mode](https://github.com/thinksquirrel/asset-store-batch-mode) - API for uploading Unity Asset Store packages.
* [Unity Size Explorer](https://github.com/aschearer/unitysizeexplorer) - analyzes the disk space usage of your build.
* [Better Unity Script Templates](https://github.com/BrokenVector/BetterUnityScriptTemplates) - improved Script templates.
* [UnityCsReference](https://github.com/Unity-Technologies/UnityCsReference) - Unity C# reference source code.
* [Shader Calibration Charts](https://oc.unity3d.com/index.php/s/dfc9aa1491ff905f589408aa136eab23) - Unity StandardShader calibration charts.
* [Save Game Free](https://github.com/BayatGames/SaveGameFree) - cross platform, encrypted, online-stored saves.
* [UCompile](https://github.com/SoapCode/UCompile) - runtime compilation and execution of CSharp code.
* [UDBase](https://github.com/KonH/UDBase) - module-based game template for Unity.
* [Hull-Delaunay-Voronoi](https://github.com/Scrawk/Hull-Delaunay-Voronoi) - Hull, Delaunay and Voronoi algorithms in Unity.
* [YTranslate](https://gist.github.com/rubenhorn/e8de0fb635c3936d47cd15dfbaafc3d4) - machine translation using Yandex Translate.
* [AR Support Checker](https://github.com/Rozhovetskyi/AR-Support-Checker) - plain detection of AR supported (ARCore, ARKit, AR Foundation) devices.
* [Steam Microtransaction API Handler](https://github.com/jasielmacedo/steam-microtransaction-api/) - API for Steam In-Game Purchase with examples using Unity
* [Trimmer](https://github.com/sttz/trimmer) - An editor, build and player configuration framework for Unity.
* [Gamium](https://github.com/dogu-team/gamium) - Game test automation library, scripting the behavior of game users.
