#include <array>

#include "test_helpers.h"

namespace dwarfs::test {

std::span<std::pair<simplestat, std::string_view> const> test_dirtree() {
  // clang-format off
  static std::array<std::pair<simplestat, std::string_view>, 337> const dt{{
    {{46193947, 040755, 1, 0, 0, 10, 27, 1667125429, 1666544836, 1666894334}, "stage"},
    {{46193949, 040755, 1, 0, 0, 10, 27, 1667125429, 1666544836, 1666894334}, "stage/run"},
    {{46193951, 040755, 1, 0, 0, 10, 27, 1667125429, 1666544836, 1666894334}, "stage/boot"},
    {{46193953, 040755, 1, 0, 0, 1368, 27, 1667125429, 1666545611, 1666894345}, "stage/etc"},
    {{46194585, 040755, 1, 0, 0, 1022, 27, 1667125429, 1666545508, 1666894345}, "stage/bin"},
    {{46194688, 040755, 1, 0, 0, 10, 27, 1667125429, 1666544836, 1666894335}, "stage/opt"},
    {{46194690, 041777, 1, 0, 0, 10, 27, 1667125429, 1666545611, 1666894335}, "stage/tmp"},
    {{46194692, 040755, 1, 0, 0, 128, 27, 1667125429, 1666544884, 1666894345}, "stage/usr"},
    {{46246095, 040755, 1, 0, 0, 812, 27, 1667125432, 1666545509, 1666894345}, "stage/lib"},
    {{46246342, 040755, 1, 0, 0, 2358, 27, 1667125432, 1666545611, 1666894345}, "stage/sbin"},
    {{46246480, 040755, 1, 0, 0, 3208, 27, 1667125432, 1666545568, 1666894345}, "stage/lib64"},
    {{46246641, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/mnt"},
    {{46246643, 040755, 1, 0, 0, 66, 27, 1667125432, 1666544837, 1666894345}, "stage/var"},
    {{46255011, 040700, 1, 0, 0, 10, 27, 1666894421, 1666544836, 1666894345}, "stage/root"},
    {{46255013, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/media"},
    {{46255015, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/home"},
    {{46255017, 040755, 1, 0, 0, 0, 27, 1667125432, 1666544749, 1666894345}, "stage/proc"},
    {{46255018, 040755, 1, 0, 0, 1686, 27, 1667125432, 1666544853, 1666894345}, "stage/dev"},
    {{46255297, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/sys"},
    {{46193954, 040755, 1, 0, 0, 396, 27, 1667125429, 1666545508, 1666894334}, "stage/etc/pam.d"},
    {{46193980, 040755, 1, 0, 0, 60, 27, 1667125429, 1666544892, 1666894334}, "stage/etc/ld.so.conf.d"},
    {{46193983, 040755, 1, 0, 0, 836, 27, 1667125429, 1666545510, 1666894345}, "stage/etc/init.d"},
    {{46194036, 040755, 1, 0, 0, 36, 27, 1667125429, 1666545611, 1666894334}, "stage/etc/environment.d"},
    {{46194041, 040755, 1, 0, 0, 20, 27, 1667125429, 1666545488, 1666894334}, "stage/etc/kernel"},
    {{46194045, 040755, 1, 0, 0, 54, 27, 1667125429, 1666545445, 1666894334}, "stage/etc/ssh"},
    {{46194049, 040755, 1, 0, 0, 40, 27, 1667125429, 1666545204, 1666894334}, "stage/etc/profile.d"},
    {{46194056, 040755, 1, 0, 0, 282, 27, 1667125429, 1666545292, 1666894334}, "stage/etc/security"},
    {{46194074, 040755, 1, 0, 0, 162, 27, 1667125429, 1666545414, 1666894334}, "stage/etc/iproute2"},
    {{46194087, 040755, 1, 0, 0, 134, 27, 1667125429, 1666545611, 1666894345}, "stage/etc/portage"},
    {{46194095, 040755, 1, 0, 0, 384, 27, 1667125429, 1666545508, 1666894334}, "stage/etc/conf.d"},
    {{46194122, 040755, 1, 0, 0, 12, 27, 1667125429, 1666545508, 1666894334}, "stage/etc/sysctl.d"},
    {{46194124, 040755, 1, 0, 0, 246, 27, 1667125429, 1666545389, 1666894334}, "stage/etc/xml"},
    {{46194132, 040755, 1, 0, 0, 52, 27, 1667125429, 1666545501, 1666894334}, "stage/etc/sandbox.d"},
    {{46194139, 040755, 1, 0, 0, 50, 27, 1667125429, 1666545270, 1666894334}, "stage/etc/inittab.d"},
    {{46194148, 040755, 1, 0, 0, 32, 27, 1667125429, 1666545017, 1666894334}, "stage/etc/python-exec"},
    {{46194154, 040755, 1, 0, 0, 156, 27, 1667125429, 1666545310, 1666894345}, "stage/etc/ssl"},
    {{46194451, 040755, 1, 0, 0, 206, 27, 1667125429, 1666545389, 1666894334}, "stage/etc/sgml"},
    {{46194461, 040755, 1, 0, 0, 58, 27, 1667125429, 1666545508, 1666894334}, "stage/etc/logrotate.d"},
    {{46194471, 040755, 1, 0, 0, 50, 27, 1667125429, 1666545164, 1666894334}, "stage/etc/bash"},
    {{46194477, 040755, 1, 0, 0, 72, 27, 1667125429, 1666545445, 1666894334}, "stage/etc/skel"},
    {{46194482, 040755, 1, 0, 0, 12, 27, 1667125429, 1666545419, 1666894334}, "stage/etc/xinetd.d"},
    {{46194485, 040755, 1, 0, 0, 262, 27, 1667125429, 1666545490, 1666894334}, "stage/etc/env.d"},
    {{46194503, 040755, 1, 0, 0, 14, 27, 1667125429, 1666544805, 1666894334}, "stage/etc/terminfo"},
    {{46194529, 040755, 1, 0, 0, 12, 27, 1667125429, 1666545508, 1666894334}, "stage/etc/local.d"},
    {{46194532, 040755, 1, 0, 0, 60, 27, 1667125429, 1666545493, 1666894334}, "stage/etc/udev"},
    {{46194539, 040755, 1, 0, 0, 12, 27, 1667125429, 1666545501, 1666894334}, "stage/etc/cron.daily"},
    {{46194542, 040755, 1, 0, 0, 70, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels"},
    {{46194581, 040755, 1, 0, 0, 14, 27, 1667125429, 1666545304, 1666894334}, "stage/etc/default"},
    {{46194070, 0100644, 1, 0, 0, 767, 27, 1666981723, 1666545104, 1666894334}, "stage/etc/netconfig"},
    {{46193989, 0100755, 1, 0, 0, 1258, 27, 1666981723, 1665941721, 1666894334}, "stage/etc/init.d/procfs"},
    {{46194022, 0100755, 1, 0, 0, 500, 27, 1666981723, 1662916992, 1666894334}, "stage/etc/init.d/kmod-static-nodes"},
    {{46194012, 0100755, 1, 0, 0, 985, 27, 1666981723, 1665941721, 1666894334}, "stage/etc/init.d/save-termencoding"},
    {{46193986, 0100755, 1, 0, 0, 956, 27, 1666981723, 1665941721, 1666894334}, "stage/etc/init.d/swclock"},
    {{46194042, 040755, 1, 0, 0, 78, 27, 1667125429, 1666545488, 1666894334}, "stage/etc/kernel/postinst.d"},
    {{46194057, 040755, 1, 0, 0, 0, 27, 1667125429, 1666545282, 1666894334}, "stage/etc/security/namespace.d"},
    {{46194063, 040755, 1, 0, 0, 0, 27, 1667125429, 1666545282, 1666894334}, "stage/etc/security/limits.d"},
    {{46194088, 040755, 1, 0, 0, 0, 27, 1667125429, 1666545611, 1666894334}, "stage/etc/portage/package.mask"},
    {{46194089, 040755, 1, 0, 0, 0, 27, 1667125429, 1666545611, 1666894334}, "stage/etc/portage/package.accept_keywords"},
    {{46194090, 040755, 1, 0, 0, 0, 27, 1667125429, 1666545611, 1666894334}, "stage/etc/portage/package.use"},
    {{46194104, 0100644, 1, 0, 0, 389, 27, 1666981723, 1656870845, 1666894334}, "stage/etc/conf.d/localmount"},
    {{46194125, 040755, 1, 0, 0, 52, 27, 1667125429, 1666545355, 1666894334}, "stage/etc/xml/.lock"},
    {{46194155, 040700, 1, 0, 0, 48, 27, 1666894420, 1666545310, 1666894334}, "stage/etc/ssl/private"},
    {{46194158, 040755, 1, 0, 0, 36, 27, 1667125429, 1666545310, 1666894334}, "stage/etc/ssl/misc"},
    {{46194164, 040755, 1, 0, 0, 11442, 27, 1667125429, 1666545490, 1666894345}, "stage/etc/ssl/certs"},
    {{46194432, 0120777, 1, 0, 0, 25, 27, 1667125815, 1662916979, 1666894334}, "stage/etc/ssl/certs/e18bfb83.0"},
    {{46194209, 0120777, 1, 0, 0, 15, 27, 1667125815, 1662916979, 1666894334}, "stage/etc/ssl/certs/1001acf7.0"},
    {{46194474, 040755, 1, 0, 0, 46, 27, 1667125429, 1666545164, 1666894334}, "stage/etc/bash/bashrc.d"},
    {{46194481, 040700, 1, 0, 0, 0, 27, 1666894420, 1666545445, 1666894334}, "stage/etc/skel/.ssh"},
    {{46194487, 040755, 1, 0, 0, 100, 27, 1667125429, 1666545189, 1666894334}, "stage/etc/env.d/binutils"},
    {{46194499, 040755, 1, 0, 0, 104, 27, 1667125429, 1666545398, 1666894334}, "stage/etc/env.d/gcc"},
    {{46194504, 040755, 1, 0, 0, 8, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/d"},
    {{46194506, 040755, 1, 0, 0, 60, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/x"},
    {{46194510, 040755, 1, 0, 0, 10, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/l"},
    {{46194512, 040755, 1, 0, 0, 48, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/v"},
    {{46194518, 040755, 1, 0, 0, 84, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/s"},
    {{46194522, 040755, 1, 0, 0, 100, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/r"},
    {{46194527, 040755, 1, 0, 0, 8, 27, 1667125429, 1666544993, 1666894334}, "stage/etc/terminfo/a"},
    {{46194534, 040755, 1, 0, 0, 60, 27, 1667125429, 1666545492, 1666894334}, "stage/etc/udev/rules.d"},
    {{46194537, 040755, 1, 0, 0, 60, 27, 1667125429, 1666545492, 1666894334}, "stage/etc/udev/hwdb.d"},
    {{46194543, 040755, 1, 0, 0, 318, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels/boot"},
    {{46194563, 040755, 1, 0, 0, 162, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels/sysinit"},
    {{46194572, 040755, 1, 0, 0, 10, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels/nonetwork"},
    {{46194574, 040755, 1, 0, 0, 52, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels/shutdown"},
    {{46194578, 040755, 1, 0, 0, 26, 27, 1667125429, 1666545508, 1666894345}, "stage/etc/runlevels/default"},
    {{46194668, 0100755, 1, 0, 0, 40360, 27, 1666894420, 1625780924, 1666894335}, "stage/bin/fuser"},
    {{46194675, 0100755, 1, 0, 0, 633824, 27, 1666894420, 1640539384, 1666894335}, "stage/bin/ip"},
    {{46194693, 040755, 1, 0, 0, 766, 27, 1667125429, 1666545606, 1666894345}, "stage/usr/share"},
    {{46223883, 040755, 1, 0, 0, 13192, 27, 1667125430, 1666545606, 1666894345}, "stage/usr/bin"},
    {{46224624, 040755, 1, 0, 0, 210, 27, 1667125430, 1666545501, 1666894340}, "stage/usr/libexec"},
    {{46224652, 040755, 1, 0, 0, 4478, 27, 1667125430, 1666545602, 1666894345}, "stage/usr/include"},
    {{46227132, 040755, 1, 0, 0, 912, 27, 1667125430, 1666545285, 1666894345}, "stage/usr/lib"},
    {{46242441, 040755, 1, 0, 0, 992, 27, 1667125432, 1666545611, 1666894345}, "stage/usr/sbin"},
    {{46242499, 040755, 1, 0, 0, 8396, 27, 1667125432, 1666545602, 1666894345}, "stage/usr/lib64"},
    {{46246022, 040755, 1, 0, 0, 50, 27, 1667125432, 1666544892, 1666894345}, "stage/usr/x86_64-pc-linux-gnu"},
    {{46246086, 040755, 1, 0, 0, 30, 27, 1667125432, 1666544836, 1666894345}, "stage/usr/local"},
    {{46246093, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/usr/src"},
    {{46255369, 0120777, 1, 0, 0, 8, 27, 1667125815, 1666544837, 1666894345}, "stage/usr/tmp"},
    {{46224422, 0120777, 1, 0, 0, 26, 27, 1667125816, 1666545516, 1666894338}, "stage/usr/bin/json_pp"},
    {{46255372, 0120777, 1, 0, 0, 27, 27, 1667125816, 1653239730, 1666894345}, "stage/usr/bin/autoheader"},
    {{46223889, 0100755, 1, 0, 0, 2550, 27, 1666894421, 1665335859, 1666894338}, "stage/usr/bin/x86_64-pc-linux-gnu-xslt-config"},
    {{46224628, 040755, 1, 0, 0, 44, 27, 1667125430, 1666545501, 1666894338}, "stage/usr/libexec/man-db"},
    {{46224634, 040755, 1, 0, 0, 38, 27, 1667125430, 1666544892, 1666894340}, "stage/usr/libexec/gcc"},
    {{46224648, 040755, 1, 0, 0, 24, 27, 1667125430, 1666545151, 1666894340}, "stage/usr/libexec/coreutils"},
    {{46224635, 040755, 1, 0, 0, 12, 27, 1667125430, 1666544892, 1666894340}, "stage/usr/libexec/gcc/x86_64-pc-linux-gnu"},
    {{46224636, 040755, 1, 0, 0, 184, 27, 1667125430, 1666545400, 1666894340}, "stage/usr/libexec/gcc/x86_64-pc-linux-gnu/11.3.0"},
    {{46224640, 040755, 1, 0, 0, 16, 27, 1667125430, 1666545400, 1666894339}, "stage/usr/libexec/gcc/x86_64-pc-linux-gnu/11.3.0/plugin"},
    {{46227134, 040755, 1, 0, 0, 4076, 27, 1667125430, 1666545327, 1666894342}, "stage/usr/lib/python3.10"},
    {{46240331, 040755, 1, 0, 0, 5396, 27, 1667125432, 1666545213, 1666894342}, "stage/usr/lib/gconv"},
    {{46240588, 040755, 1, 0, 0, 20, 27, 1667125432, 1666545431, 1666894342}, "stage/usr/lib/systemd"},
    {{46240601, 040755, 1, 0, 0, 132, 27, 1667125432, 1666545501, 1666894342}, "stage/usr/lib/tmpfiles.d"},
    {{46240608, 040755, 1, 0, 0, 770, 27, 1667125432, 1666545085, 1666894342}, "stage/usr/lib/sysusers.d"},
    {{46240629, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544877, 1666894342}, "stage/usr/lib/misc"},
    {{46240633, 040755, 1, 0, 0, 46, 27, 1667125432, 1666545237, 1666894342}, "stage/usr/lib/pkgconfig"},
    {{46240640, 040755, 1, 0, 0, 26, 27, 1667125432, 1666544915, 1666894342}, "stage/usr/lib/portage"},
    {{46240763, 040755, 1, 0, 0, 18, 27, 1667125432, 1666545014, 1666894342}, "stage/usr/lib/python"},
    {{46240770, 040755, 1, 0, 0, 44, 27, 1667125432, 1666545073, 1666894345}, "stage/usr/lib/python-exec"},
    {{46240813, 040755, 1, 0, 0, 28, 27, 1667125432, 1666545213, 1666894342}, "stage/usr/lib/audit"},
    {{46240815, 040755, 1, 0, 0, 38, 27, 1667125432, 1666544892, 1666894343}, "stage/usr/lib/gcc"},
    {{46242433, 040755, 1, 0, 0, 76, 27, 1667125432, 1666545215, 1666894343}, "stage/usr/lib/locale"},
    {{46240802, 0100644, 1, 0, 0, 8, 27, 1666894421, 1659288743, 1666894342}, "stage/usr/lib/libutil.a"},
    {{46240803, 0100644, 1, 0, 0, 516, 27, 1666894421, 1659288742, 1666894342}, "stage/usr/lib/Mcrt1.o"},
    {{46227139, 040755, 1, 0, 0, 118, 27, 1667125430, 1666545326, 1666894340}, "stage/usr/lib/python3.10/json"},
    {{46227161, 040755, 1, 0, 0, 282, 27, 1667125430, 1666545327, 1666894340}, "stage/usr/lib/python3.10/importlib"},
    {{46227244, 040755, 1, 0, 0, 5974, 27, 1667125430, 1666545324, 1666894340}, "stage/usr/lib/python3.10/lib-dynload"},
    {{46227292, 0100755, 1, 0, 0, 70176, 27, 1666894421, 1665941549, 1666894340}, "stage/usr/lib/python3.10/lib-dynload/_asyncio.cpython-310-x86_64-linux-gnu.so"},
    {{46227304, 0100755, 1, 0, 0, 48224, 27, 1666894421, 1665941548, 1666894340}, "stage/usr/lib/python3.10/lib-dynload/audioop.cpython-310-x86_64-linux-gnu.so"},
    {{46227315, 0100755, 1, 0, 0, 112904, 27, 1666894421, 1665941548, 1666894340}, "stage/usr/lib/python3.10/lib-dynload/_codecs_tw.cpython-310-x86_64-linux-gnu.so"},
    {{46227261, 0100755, 1, 0, 0, 76768, 27, 1666894421, 1665941548, 1666894340}, "stage/usr/lib/python3.10/lib-dynload/_elementtree.cpython-310-x86_64-linux-gnu.so"},
    {{46240363, 040755, 1, 0, 0, 48, 27, 1667125432, 1666545213, 1666894342}, "stage/usr/lib/gconv/gconv-modules.d"},
    {{46240589, 040755, 1, 0, 0, 42, 27, 1667125432, 1666545282, 1666894342}, "stage/usr/lib/systemd/system"},
    {{46240591, 040755, 1, 0, 0, 256, 27, 1667125432, 1666545431, 1666894342}, "stage/usr/lib/systemd/user"},
    {{46240623, 0100644, 1, 0, 0, 13, 27, 1666894421, 1625882854, 1666894342}, "stage/usr/lib/sysusers.d/acct-group-dialout.conf"},
    {{46240630, 040755, 1, 0, 0, 14, 27, 1667125432, 1666544877, 1666894342}, "stage/usr/lib/misc/glibc"},
    {{46240631, 040755, 1, 0, 0, 230, 27, 1667125432, 1666545213, 1666894342}, "stage/usr/lib/misc/glibc/getconf"},
    {{46240641, 040755, 1, 0, 0, 1122, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10"},
    {{46240761, 040755, 1, 0, 0, 30, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/bin"},
    {{46240648, 040755, 1, 0, 0, 556, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/install-qa-check.d"},
    {{46240688, 040755, 1, 0, 0, 736, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/ebuild-helpers"},
    {{46240749, 040755, 1, 0, 0, 22, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/preinst-qa-check.d"},
    {{46240759, 040755, 1, 0, 0, 22, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/postinst-qa-check.d"},
    {{46240643, 0100755, 1, 0, 0, 616, 27, 1666894421, 1664843079, 1666894342}, "stage/usr/lib/portage/python3.10/chmod-lite"},
    {{46240675, 0100755, 1, 0, 0, 1339, 27, 1666894421, 1666545472, 1666894342}, "stage/usr/lib/portage/python3.10/shelve-utils"},
    {{46240753, 0100755, 1, 0, 0, 952, 27, 1666894421, 1666545472, 1666894342}, "stage/usr/lib/portage/python3.10/chmod-lite.py"},
    {{46240662, 0100755, 1, 0, 0, 5559, 27, 1666894421, 1664843079, 1666894342}, "stage/usr/lib/portage/python3.10/install-qa-check.d/10executable-issues"},
    {{46240661, 0100755, 1, 0, 0, 668, 27, 1666894421, 1664843079, 1666894342}, "stage/usr/lib/portage/python3.10/install-qa-check.d/60pngfix"},
    {{46240698, 040755, 1, 0, 0, 20, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/ebuild-helpers/unprivileged"},
    {{46240742, 040755, 1, 0, 0, 14, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/ebuild-helpers/xattr"},
    {{46240745, 040755, 1, 0, 0, 6, 27, 1667125432, 1666545481, 1666894342}, "stage/usr/lib/portage/python3.10/ebuild-helpers/bsd"},
    {{46240764, 040755, 1, 0, 0, 122, 27, 1667125432, 1666545016, 1666894342}, "stage/usr/lib/python/ensurepip"},
    {{46240771, 040755, 1, 0, 0, 498, 27, 1667125432, 1666545481, 1666894345}, "stage/usr/lib/python-exec/python3.10"},
    {{46240776, 0120777, 1, 0, 0, 14, 27, 1667125817, 1665941545, 1666894342}, "stage/usr/lib/python-exec/python3.10/python-config"},
    {{46240816, 040755, 1, 0, 0, 12, 27, 1667125432, 1666544892, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu"},
    {{46240817, 040755, 1, 0, 0, 1850, 27, 1667125432, 1666545399, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0"},
    {{46240824, 040755, 1, 0, 0, 1468, 27, 1667125432, 1666545399, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/32"},
    {{46240910, 040755, 1, 0, 0, 248, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin"},
    {{46241388, 040755, 1, 0, 0, 3144, 27, 1667125432, 1666545399, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/include"},
    {{46242380, 040755, 1, 0, 0, 310, 27, 1667125432, 1666545398, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/finclude"},
    {{46242398, 040755, 1, 0, 0, 50, 27, 1667125432, 1666545398, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/include-fixed"},
    {{46242412, 0100644, 1, 0, 0, 162, 27, 1666894421, 1654456331, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/libitm.spec"},
    {{46242413, 0120777, 1, 0, 0, 15, 27, 1667125817, 1654456331, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/libitm.so"},
    {{46240902, 0120777, 1, 0, 0, 19, 27, 1667125817, 1654456336, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/libstdc++.so.6"},
    {{46242407, 0100755, 1, 0, 0, 993, 27, 1666894421, 1654456367, 1666894343}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/libquadmath.la"},
    {{46240849, 040755, 1, 0, 0, 310, 27, 1667125432, 1666545399, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/32/finclude"},
    {{46240891, 0120777, 1, 0, 0, 18, 27, 1667125817, 1654456317, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/32/libatomic.so"},
    {{46240866, 0100644, 1, 0, 0, 1412, 27, 1666894421, 1654456370, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/32/crtbegin.o"},
    {{46240913, 040755, 1, 0, 0, 10410, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include"},
    {{46240923, 040755, 1, 0, 0, 20, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/d"},
    {{46241089, 040755, 1, 0, 0, 220, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/config"},
    {{46241114, 040755, 1, 0, 0, 112, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/c-family"},
    {{46241160, 040755, 1, 0, 0, 26, 27, 1667125432, 1666544892, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/ada"},
    {{46241244, 040755, 1, 0, 0, 26, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/objc"},
    {{46241292, 040755, 1, 0, 0, 12, 27, 1667125432, 1666544892, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/common"},
    {{46241347, 040755, 1, 0, 0, 152, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/cp"},
    {{46241253, 0100644, 1, 0, 0, 2145, 27, 1666894421, 1654456329, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/alias.h"},
    {{46240959, 0100644, 1, 0, 0, 8536, 27, 1666894421, 1654456329, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/asan.h"},
    {{46241299, 0100644, 1, 0, 0, 17013, 27, 1666894421, 1654456335, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/gengtype.h"},
    {{46240984, 0100644, 1, 0, 0, 198, 27, 1666894421, 1654456329, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/all-tree.def"},
    {{46241094, 040755, 1, 0, 0, 270, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/config/i386"},
    {{46241161, 040755, 1, 0, 0, 24, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/ada/gcc-interface"},
    {{46241293, 040755, 1, 0, 0, 8, 27, 1667125432, 1666544892, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/common/config"},
    {{46241294, 040755, 1, 0, 0, 28, 27, 1667125432, 1666545398, 1666894342}, "stage/usr/lib/gcc/x86_64-pc-linux-gnu/11.3.0/plugin/include/common/config/i386"},
    {{46242462, 0100755, 1, 0, 0, 122104, 27, 1666894421, 1656869840, 1666894343}, "stage/usr/sbin/partx"},
    {{46242484, 0120777, 1, 0, 0, 4, 27, 1667125817, 1662312044, 1666894343}, "stage/usr/sbin/vigr"},
    {{46242480, 0100755, 1, 0, 0, 60160, 27, 1666894421, 1662312047, 1666894343}, "stage/usr/sbin/groupmems"},
    {{46242454, 0100755, 1, 0, 0, 131432, 27, 1666894421, 1662312047, 1666894343}, "stage/usr/sbin/usermod"},
    {{46242532, 040755, 1, 0, 0, 50, 27, 1667125432, 1666545310, 1666894343}, "stage/usr/lib64/engines-1.1"},
    {{46242539, 040755, 1, 0, 0, 3154, 27, 1667125432, 1666545224, 1666894343}, "stage/usr/lib64/xtables"},
    {{46242646, 040755, 1, 0, 0, 38, 27, 1667125432, 1666544884, 1666894343}, "stage/usr/lib64/binutils"},
    {{46242853, 040755, 1, 0, 0, 238, 27, 1667125432, 1666545204, 1666894343}, "stage/usr/lib64/gawk"},
    {{46242868, 040755, 1, 0, 0, 5434, 27, 1667125432, 1666545214, 1666894343}, "stage/usr/lib64/gconv"},
    {{46243160, 040755, 1, 0, 0, 146, 27, 1667125432, 1666545445, 1666894343}, "stage/usr/lib64/misc"},
    {{46243175, 040755, 1, 0, 0, 34, 27, 1667125432, 1666545586, 1666894343}, "stage/usr/lib64/help2man"},
    {{46243179, 040755, 1, 0, 0, 1986, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/pkgconfig"},
    {{46243283, 040755, 1, 0, 0, 262, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6"},
    {{46243538, 040755, 1, 0, 0, 92, 27, 1667125432, 1666545348, 1666894343}, "stage/usr/lib64/gettext"},
    {{46243553, 040755, 1, 0, 0, 14, 27, 1667125432, 1666544849, 1666894343}, "stage/usr/lib64/libffi"},
    {{46243559, 040755, 1, 0, 0, 64, 27, 1667125432, 1666545433, 1666894343}, "stage/usr/lib64/cmake"},
    {{46243573, 040755, 1, 0, 0, 108, 27, 1667125432, 1666545502, 1666894343}, "stage/usr/lib64/man-db"},
    {{46243625, 040755, 1, 0, 0, 30, 27, 1667125432, 1666544920, 1666894345}, "stage/usr/lib64/perl5"},
    {{46245904, 040755, 1, 0, 0, 22, 27, 1667125432, 1666545212, 1666894344}, "stage/usr/lib64/glibc-2.35"},
    {{46245935, 040755, 1, 0, 0, 28, 27, 1667125432, 1666545212, 1666894344}, "stage/usr/lib64/audit"},
    {{46245946, 040755, 1, 0, 0, 160, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff"},
    {{46245999, 040755, 1, 0, 0, 18, 27, 1667125432, 1666545603, 1666894344}, "stage/usr/lib64/tcl8"},
    {{46246017, 040755, 1, 0, 0, 24, 27, 1667125432, 1666545569, 1666894344}, "stage/usr/lib64/e2fsprogs"},
    {{46255332, 0120777, 1, 0, 0, 17, 27, 1667125817, 1656263681, 1666894345}, "stage/usr/lib64/terminfo"},
    {{46243615, 0100644, 1, 0, 0, 2464, 27, 1666981723, 1659288743, 1666894343}, "stage/usr/lib64/gcrt1.o"},
    {{46243614, 0100755, 1, 0, 0, 286104, 27, 1666981723, 1650216338, 1666894343}, "stage/usr/lib64/libnettle.so.8.4"},
    {{46242626, 0120777, 1, 0, 0, 18, 27, 1667125817, 1662916996, 1666894343}, "stage/usr/lib64/xtables/libxt_state.so"},
    {{46242644, 0100755, 1, 0, 0, 14512, 27, 1666981724, 1662916997, 1666894343}, "stage/usr/lib64/xtables/libxt_LED.so"},
    {{46242552, 0100755, 1, 0, 0, 14728, 27, 1666981724, 1662916997, 1666894343}, "stage/usr/lib64/xtables/libxt_policy.so"},
    {{46242557, 0100755, 1, 0, 0, 14504, 27, 1666981724, 1662916997, 1666894343}, "stage/usr/lib64/xtables/libxt_udp.so"},
    {{46242647, 040755, 1, 0, 0, 8, 27, 1667125432, 1666544884, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu"},
    {{46242648, 040755, 1, 0, 0, 532, 27, 1667125432, 1666545188, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38"},
    {{46242652, 040755, 1, 0, 0, 3404, 27, 1667125432, 1666545188, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38/ldscripts"},
    {{46242787, 040755, 1, 0, 0, 324, 27, 1667125432, 1666545188, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38/include"},
    {{46242819, 040755, 1, 0, 0, 18, 27, 1667125432, 1666545188, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38/bfd-plugins"},
    {{46242686, 0100644, 1, 0, 0, 8790, 27, 1666981724, 1659288464, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38/ldscripts/elf_iamcu.xde"},
    {{46242794, 040755, 1, 0, 0, 280, 27, 1667125432, 1666545188, 1666894343}, "stage/usr/lib64/binutils/x86_64-pc-linux-gnu/2.38/include/libiberty"},
    {{46242900, 040755, 1, 0, 0, 48, 27, 1667125432, 1666545212, 1666894343}, "stage/usr/lib64/gconv/gconv-modules.d"},
    {{46242996, 0100755, 1, 0, 0, 18416, 27, 1666981724, 1659288743, 1666894343}, "stage/usr/lib64/gconv/IBM500.so"},
    {{46242907, 0100755, 1, 0, 0, 472880, 27, 1666981724, 1659288743, 1666894343}, "stage/usr/lib64/gconv/libCNS.so"},
    {{46243018, 0100755, 1, 0, 0, 18416, 27, 1666981724, 1659288743, 1666894343}, "stage/usr/lib64/gconv/ISO8859-16.so"},
    {{46243161, 040755, 1, 0, 0, 20, 27, 1667125432, 1666545204, 1666894343}, "stage/usr/lib64/misc/awk"},
    {{46243169, 040755, 1, 0, 0, 14, 27, 1667125432, 1666544877, 1666894343}, "stage/usr/lib64/misc/glibc"},
    {{46243170, 040755, 1, 0, 0, 106, 27, 1667125432, 1666545212, 1666894343}, "stage/usr/lib64/misc/glibc/getconf"},
    {{46243245, 0100644, 1, 0, 0, 1641, 27, 1666981723, 1656869911, 1666894343}, "stage/usr/lib64/pkgconfig/libcurl.pc"},
    {{46243275, 0100644, 1, 0, 0, 250, 27, 1666981723, 1665941530, 1666894343}, "stage/usr/lib64/pkgconfig/python-3.10.pc"},
    {{46243215, 0100644, 1, 0, 0, 431, 27, 1666981723, 1656263669, 1666894343}, "stage/usr/lib64/pkgconfig/tinfo.pc"},
    {{46243288, 040755, 1, 0, 0, 22, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/include"},
    {{46243318, 040755, 1, 0, 0, 40, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/http1.0"},
    {{46243325, 040755, 1, 0, 0, 48, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/opt0.4"},
    {{46243328, 040755, 1, 0, 0, 1792, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/encoding"},
    {{46243409, 040755, 1, 0, 0, 1930, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/msgs"},
    {{46243322, 0100644, 1, 0, 0, 23244, 27, 1666981724, 1650216350, 1666894343}, "stage/usr/lib64/tcl8.6/package.tcl"},
    {{46243289, 040755, 1, 0, 0, 528, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/include/generic"},
    {{46243313, 040755, 1, 0, 0, 52, 27, 1667125432, 1666545603, 1666894343}, "stage/usr/lib64/tcl8.6/include/unix"},
    {{46243308, 0100644, 1, 0, 0, 56808, 27, 1666981724, 1650216353, 1666894343}, "stage/usr/lib64/tcl8.6/include/generic/tclIntDecls.h"},
    {{46243337, 0100644, 1, 0, 0, 91831, 27, 1666981724, 1650216350, 1666894343}, "stage/usr/lib64/tcl8.6/encoding/cp950.enc"},
    {{46243397, 0100644, 1, 0, 0, 1094, 27, 1666981724, 1650216351, 1666894343}, "stage/usr/lib64/tcl8.6/encoding/iso8859-8.enc"},
    {{46243437, 0100644, 1, 0, 0, 242, 27, 1666981724, 1650216351, 1666894343}, "stage/usr/lib64/tcl8.6/msgs/ru_ua.msg"},
    {{46243533, 0100644, 1, 0, 0, 1566, 27, 1666981724, 1650216351, 1666894343}, "stage/usr/lib64/tcl8.6/msgs/ko.msg"},
    {{46243464, 0100644, 1, 0, 0, 2305, 27, 1666981724, 1650216351, 1666894343}, "stage/usr/lib64/tcl8.6/msgs/th.msg"},
    {{46243554, 040755, 1, 0, 0, 32, 27, 1667125432, 1666545010, 1666894343}, "stage/usr/lib64/libffi/include"},
    {{46243560, 040755, 1, 0, 0, 40, 27, 1667125432, 1666545340, 1666894343}, "stage/usr/lib64/cmake/libxml2"},
    {{46243562, 040755, 1, 0, 0, 90, 27, 1667125432, 1666545433, 1666894343}, "stage/usr/lib64/cmake/Gpgmepp"},
    {{46243565, 040755, 1, 0, 0, 72, 27, 1667125432, 1666545353, 1666894343}, "stage/usr/lib64/cmake/libxslt"},
    {{46243568, 040755, 1, 0, 0, 150, 27, 1667125432, 1666545194, 1666894343}, "stage/usr/lib64/cmake/expat-2.4.9"},
    {{46245947, 040755, 1, 0, 0, 46, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff/glilypond"},
    {{46245951, 040755, 1, 0, 0, 14, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff/gpinyin"},
    {{46245953, 040755, 1, 0, 0, 94, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff/groffer"},
    {{46245959, 040755, 1, 0, 0, 14, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff/grog"},
    {{46245962, 040755, 1, 0, 0, 0, 27, 1667125432, 1666545233, 1666894344}, "stage/usr/lib64/groff/site-tmac"},
    {{46246000, 040755, 1, 0, 0, 62, 27, 1667125432, 1666545603, 1666894344}, "stage/usr/lib64/tcl8/8.5"},
    {{46246003, 040755, 1, 0, 0, 52, 27, 1667125432, 1666545603, 1666894344}, "stage/usr/lib64/tcl8/8.4"},
    {{46246007, 040755, 1, 0, 0, 26, 27, 1667125432, 1666545603, 1666894344}, "stage/usr/lib64/tcl8/8.6"},
    {{46246004, 040755, 1, 0, 0, 28, 27, 1667125432, 1666545603, 1666894344}, "stage/usr/lib64/tcl8/8.4/platform"},
    {{46246023, 040755, 1, 0, 0, 190, 27, 1667125432, 1666545189, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/bin"},
    {{46246042, 040755, 1, 0, 0, 12, 27, 1667125432, 1666544892, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/gcc-bin"},
    {{46246062, 040755, 1, 0, 0, 18, 27, 1667125432, 1666545189, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/lib"},
    {{46246064, 040755, 1, 0, 0, 14, 27, 1667125432, 1666544892, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/binutils-bin"},
    {{46246043, 040755, 1, 0, 0, 656, 27, 1667125432, 1666545400, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/gcc-bin/11.3.0"},
    {{46246053, 0100755, 2, 0, 0, 35184, 27, 1666981723, 1654456370, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/gcc-bin/11.3.0/gcc-ar"},
    {{46246055, 0100755, 2, 0, 0, 35184, 27, 1666981723, 1654456370, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/gcc-bin/11.3.0/x86_64-pc-linux-gnu-gcc-ranlib"},
    {{46255313, 0120777, 1, 0, 0, 54, 27, 1667125817, 1666545189, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/lib/ldscripts"},
    {{46246065, 040755, 1, 0, 0, 190, 27, 1667125432, 1666545188, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/binutils-bin/2.38"},
    {{46246083, 040755, 1, 0, 0, 22, 27, 1667125432, 1666544892, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/binutils-bin/lib"},
    {{46246070, 0100755, 1, 0, 0, 43888, 27, 1666981723, 1659288466, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/binutils-bin/2.38/elfedit"},
    {{46246084, 040755, 1, 0, 0, 32, 27, 1667125432, 1666545401, 1666894345}, "stage/usr/x86_64-pc-linux-gnu/binutils-bin/lib/bfd-plugins"},
    {{46246087, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/usr/local/bin"},
    {{46246089, 040755, 1, 0, 0, 0, 27, 1667125432, 1666544795, 1666894345}, "stage/usr/local/lib"},
    {{46246090, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544836, 1666894345}, "stage/usr/local/sbin"},
    {{46246092, 040755, 1, 0, 0, 0, 27, 1667125432, 1666544795, 1666894345}, "stage/usr/local/lib64"},
    {{46246101, 040755, 1, 0, 0, 90, 27, 1667125432, 1666545219, 1666894345}, "stage/lib/modprobe.d"},
    {{46246106, 040755, 1, 0, 0, 52, 27, 1667125432, 1666545492, 1666894345}, "stage/lib/systemd"},
    {{46246132, 040755, 1, 0, 0, 24, 27, 1667125432, 1666545510, 1666894345}, "stage/lib/netifrc"},
    {{46246179, 040755, 1, 0, 0, 44, 27, 1667125432, 1666545052, 1666894345}, "stage/lib/sysctl.d"},
    {{46246187, 040755, 1, 0, 0, 24, 27, 1667125432, 1666545001, 1666894345}, "stage/lib/gentoo"},
    {{46246191, 040755, 1, 0, 0, 38, 27, 1667125432, 1666545508, 1666894345}, "stage/lib/rc"},
    {{46246270, 040755, 1, 0, 0, 124, 27, 1667125432, 1666545510, 1666894345}, "stage/lib/udev"},
    {{46246096, 0100755, 1, 0, 0, 13636, 27, 1666981723, 1659288743, 1666894345}, "stage/lib/libpcprofile.so"},
    {{46246108, 040755, 1, 0, 0, 30, 27, 1667125432, 1666545492, 1666894345}, "stage/lib/systemd/network"},
    {{46246110, 040755, 1, 0, 0, 578, 27, 1667125432, 1666545569, 1666894345}, "stage/lib/systemd/system"},
    {{46246133, 040755, 1, 0, 0, 88, 27, 1667125432, 1666545510, 1666894345}, "stage/lib/netifrc/sh"},
    {{46246138, 040755, 1, 0, 0, 718, 27, 1667125432, 1666545510, 1666894345}, "stage/lib/netifrc/net"},
    {{46246192, 040755, 1, 0, 0, 878, 27, 1667125432, 1666545508, 1666894345}, "stage/lib/rc/bin"},
    {{46246236, 040755, 1, 0, 0, 46, 27, 1667125432, 1666545508, 1666894345}, "stage/lib/rc/tmp"},
    {{46246238, 040755, 1, 0, 0, 360, 27, 1667125432, 1666545508, 1666894345}, "stage/lib/rc/sh"},
    {{46246253, 040755, 1, 0, 0, 422, 27, 1667125432, 1666545508, 1666894345}, "stage/lib/rc/sbin"},
    {{46246219, 0100755, 1, 0, 0, 23136, 27, 1666981723, 1665941733, 1666894345}, "stage/lib/rc/bin/service_started"},
    {{46246203, 0100755, 1, 0, 0, 31392, 27, 1666981723, 1665941733, 1666894345}, "stage/lib/rc/bin/fstabinfo"},
    {{46246224, 0100755, 1, 0, 0, 23136, 27, 1666981723, 1665941733, 1666894345}, "stage/lib/rc/bin/service_crashed"},
    {{46246247, 0100755, 1, 0, 0, 3014, 27, 1666981723, 1665941721, 1666894345}, "stage/lib/rc/sh/init.sh"},
    {{46246255, 0100755, 1, 0, 0, 27264, 27, 1666981723, 1665941733, 1666894345}, "stage/lib/rc/sbin/swclock"},
    {{46246276, 040755, 1, 0, 0, 1096, 27, 1667125432, 1666545569, 1666894345}, "stage/lib/udev/rules.d"},
    {{46246308, 040755, 1, 0, 0, 1124, 27, 1667125432, 1666545492, 1666894345}, "stage/lib/udev/hwdb.d"},
    {{46246282, 0100644, 1, 0, 0, 990, 27, 1666981723, 1663521638, 1666894345}, "stage/lib/udev/rules.d/60-evdev.rules"},
    {{46246311, 0100644, 1, 0, 0, 926, 27, 1666981723, 1663521638, 1666894345}, "stage/lib/udev/hwdb.d/70-pda.hwdb"},
    {{46246505, 040755, 1, 0, 0, 142, 27, 1667125432, 1666545414, 1666894345}, "stage/lib64/tc"},
    {{46246517, 040755, 1, 0, 0, 1130, 27, 1667125432, 1666545292, 1666894345}, "stage/lib64/security"},
    {{46246483, 0100755, 1, 0, 0, 101248, 27, 1666981723, 1662916993, 1666894345}, "stage/lib64/libkmod.so.2.4.0"},
    {{46246573, 0100755, 1, 0, 0, 35416, 27, 1666981723, 1662916997, 1666894345}, "stage/lib64/libip4tc.so.2.0.0"},
    {{46246551, 040755, 1, 0, 0, 20, 27, 1667125432, 1666545282, 1666894345}, "stage/lib64/security/pam_filter"},
    {{46246646, 040755, 1, 0, 0, 10, 27, 1667125432, 1666544837, 1666894345}, "stage/var/spool"},
    {{46246648, 041777, 1, 0, 0, 10, 27, 1667125432, 1666545611, 1666894345}, "stage/var/tmp"},
    {{46246650, 040755, 1, 0, 0, 32, 27, 1667125432, 1666545611, 1666894345}, "stage/var/db"},
    {{46254965, 040755, 1, 0, 0, 70, 27, 1667125432, 1666545224, 1666894345}, "stage/var/lib"},
    {{46254982, 040755, 1, 0, 0, 70, 27, 1667125432, 1666545501, 1666894345}, "stage/var/cache"},
    {{46255000, 040755, 1, 0, 0, 78, 27, 1667125432, 1666545611, 1666894345}, "stage/var/log"},
    {{46255008, 040755, 1, 0, 0, 54, 27, 1667125432, 1666545085, 1666894345}, "stage/var/empty"},
    {{46255303, 0120777, 1, 0, 0, 4, 27, 1667125817, 1666544837, 1666894345}, "stage/var/run"},
    {{46255304, 0120777, 1, 0, 0, 9, 27, 1667125817, 1666544837, 1666894345}, "stage/var/lock"},
    {{46246651, 040755, 1, 0, 0, 0, 27, 1667125432, 1666545611, 1666894345}, "stage/var/db/repos"},
    {{46254967, 040755, 1, 0, 0, 58, 27, 1667125432, 1666545224, 1666894345}, "stage/var/lib/ip6tables"},
    {{46254969, 040755, 1, 0, 0, 58, 27, 1667125432, 1666545224, 1666894345}, "stage/var/lib/iptables"},
    {{46254971, 042755, 1, 0, 250, 76, 27, 1667125432, 1666545611, 1666894345}, "stage/var/lib/portage"},
    {{46254977, 040755, 1, 0, 0, 8, 27, 1667125432, 1666544866, 1666894345}, "stage/var/lib/gentoo"},
    {{46254974, 040755, 1, 250, 250, 50, 27, 1667125432, 1666545083, 1666894345}, "stage/var/lib/portage/home"},
    {{46254978, 040775, 1, 0, 250, 118, 27, 1667125432, 1666545611, 1666894345}, "stage/var/lib/gentoo/news"},
    {{46254984, 040755, 1, 0, 0, 0, 27, 1667125432, 1666544961, 1666894345}, "stage/var/cache/binpkgs"},
    {{46254985, 040755, 1, 0, 0, 0, 27, 1667125432, 1666544961, 1666894345}, "stage/var/cache/distfiles"},
    {{46254986, 040755, 1, 13, 15, 0, 27, 1667125432, 1666545501, 1666894345}, "stage/var/cache/man"},
    {{46254987, 040700, 1, 0, 0, 18, 27, 1666894421, 1666545609, 1666894345}, "stage/var/cache/ldconfig"},
    {{46254989, 040755, 1, 0, 250, 156, 27, 1667125432, 1666545611, 1666894345}, "stage/var/cache/edb"},
    {{46254994, 042775, 1, 0, 250, 6, 27, 1667125432, 1666544962, 1666894345}, "stage/var/cache/edb/dep"},
    {{46254995, 040775, 1, 0, 250, 4, 27, 1667125432, 1666544962, 1666894345}, "stage/var/cache/edb/dep/var"},
    {{46254996, 040775, 1, 0, 250, 10, 27, 1667125432, 1666544962, 1666894345}, "stage/var/cache/edb/dep/var/db"},
    {{46254997, 040775, 1, 0, 250, 12, 27, 1667125432, 1666544962, 1666894345}, "stage/var/cache/edb/dep/var/db/repos"},
    {{46254998, 040775, 1, 0, 250, 0, 27, 1667125432, 1666544962, 1666894345}, "stage/var/cache/edb/dep/var/db/repos/gentoo"},
    {{46255004, 042775, 1, 250, 250, 8, 27, 1667125432, 1666544915, 1666894345}, "stage/var/log/portage"},
    {{46255007, 040770, 1, 0, 250, 0, 27, 1666894421, 1666544848, 1666894345}, "stage/var/log/sandbox"},
    {{46255005, 042775, 1, 250, 250, 48, 27, 1667125432, 1666544915, 1666894345}, "stage/var/log/portage/elog"},
    {{46255145, 040755, 1, 0, 0, 1124, 27, 1667125432, 1666544853, 1666894345}, "stage/dev/input"},
    {{46255130, 020620, 1, 0, 5, 0, 27, 1666894345, 1666544853, 1666894345}, "stage/dev/tty37"},
    {{46255270, 060640, 1, 0, 6, 0, 27, 1666894345, 1666544853, 1666894345}, "stage/dev/sdc4"},
    {{46255143, 060640, 1, 0, 6, 0, 27, 1666894345, 1666544853, 1666894345}, "stage/dev/hda20"},
    {{46255250, 060640, 1, 0, 6, 0, 27, 1666894345, 1666544853, 1666894345}, "stage/dev/sdd"},
    {{46255234, 020600, 1, 0, 0, 0, 27, 1666894345, 1666544853, 1666894345}, "stage/dev/input/event23"},
  }};
  // clang-format on
  return dt;
}

} // namespace dwarfs::test
