# Comparison with other analyzers

## Equivalent rules

|                                                                                                                           |                                                                                            |
|---------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------|
| [CA1018](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1018?WT.mc_id=DT-MVP-5003978) | [MA0010](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0010.md) |
| [CA1036](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1036?WT.mc_id=DT-MVP-5003978) | [MA0097](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0097.md) |
| [CA1050](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1050?WT.mc_id=DT-MVP-5003978) | [MA0047](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0047.md) |
| [CA1058](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1058?WT.mc_id=DT-MVP-5003978) | [MA0013](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0013.md) |
| [CA1065](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1065?WT.mc_id=DT-MVP-5003978) | [MA0072](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0072.md) |
| [CA1065](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1065?WT.mc_id=DT-MVP-5003978) | [MA0086](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0086.md) |
| [CA1067](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1067?WT.mc_id=DT-MVP-5003978) | [MA0095](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0095.md) |
| [CA1304](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1304?WT.mc_id=DT-MVP-5003978) | [MA0011](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0011.md) |
| [CA1305](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1305?WT.mc_id=DT-MVP-5003978) | [MA0011](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0011.md) |
| [CA1307](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1307?WT.mc_id=DT-MVP-5003978) | [MA0001](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0001.md), [MA0074](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0074.md) |
| [CA1309](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1309?WT.mc_id=DT-MVP-5003978) | [MA0001](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0001.md), [MA0074](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0074.md) |
| [CA1310](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1310?WT.mc_id=DT-MVP-5003978) | [MA0001](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0001.md) |
| [CA1710](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1710?WT.mc_id=DT-MVP-5003978) | [MA0057](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0057.md) |
| [CA1710](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1710?WT.mc_id=DT-MVP-5003978) | [MA0058](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0058.md) |
| [CA1710](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1710?WT.mc_id=DT-MVP-5003978) | [MA0059](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0059.md) |
| [CA1724](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1724?WT.mc_id=DT-MVP-5003978) | [MA0049](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0049.md) |
| [CA1825](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1825?WT.mc_id=DT-MVP-5003978) | [MA0005](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0005.md) |
| [CA1826](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1829?WT.mc_id=DT-MVP-5003978) | [MA0020](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0020.md) |
| [CA1830](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1830?WT.mc_id=DT-MVP-5003978) | [MA0028](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0028.md) |
| [CA1834](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1834?WT.mc_id=DT-MVP-5003978) | [MA0028](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0028.md) |
| [CA2200](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2200?WT.mc_id=DT-MVP-5003978) | [MA0027](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0027.md) |
| [CA2201](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2201?WT.mc_id=DT-MVP-5003978) | [MA0012](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0012.md) |
| [CA2201](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2201?WT.mc_id=DT-MVP-5003978) | [MA0014](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0014.md) |
| [CA2208](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2208?WT.mc_id=DT-MVP-5003978) | [MA0015](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0015.md) |
| [CA2211](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2211?WT.mc_id=DT-MVP-5003978) | [MA0069](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0069.md) |
| [CA2214](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2214?WT.mc_id=DT-MVP-5003978) | [MA0056](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0056.md) |
| [CA2217](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2217?WT.mc_id=DT-MVP-5003978) | [MA0062](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0062.md) |
| [CA2219](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2219?WT.mc_id=DT-MVP-5003978) | [MA0072](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0072.md) |
| [CA2242](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2242?WT.mc_id=DT-MVP-5003978) | [MA0082](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0082.md) |
| [CA5359](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca5359?WT.mc_id=DT-MVP-5003978) | [MA0039](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0039.md) |
| [S3442](https://rules.sonarsource.com/csharp/RSPEC-3442/)                                                                  | [MA0017](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0017.md) |
| [S3450](https://rules.sonarsource.com/csharp/RSPEC-3450/)                                                                  | [MA0087](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0087.md) |
| [S3903](https://rules.sonarsource.com/csharp/RSPEC-3903/)                                                                  | [MA0047](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0047.md) |
| [SA1413](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/SA1413.md)                         | [MA0007](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0007.md) |
| [SA1649](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/SA1649.md)                         | [MA0048](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0048.md) |

## Similar rules

|                                                                                                                           |                                                                                            |                                                                                   |
|---------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------|
| [CA1000](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1000?WT.mc_id=DT-MVP-5003978) | [MA0018](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0018.md) | CA can also be configured to run against non-public API surface                   |
| [CA1002](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1002?WT.mc_id=DT-MVP-5003978) | [MA0016](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0016.md) | CA only applies to `List<T>`                                                      |
| [CA1003](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1003?WT.mc_id=DT-MVP-5003978) | [MA0046](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0046.md) | CA only applies to public types by default (can be configured) |
| [CA1052](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1052?WT.mc_id=DT-MVP-5003978) | [MA0036](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0036.md) | CA can be configured to only run against specific API surfaces                    |
| [CA1815](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1815?WT.mc_id=DT-MVP-5003978) | [MA0065](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0065.md) | MA reports only when Equals or GetHashCode is used                                |
| [CA1815](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1815?WT.mc_id=DT-MVP-5003978) | [MA0066](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0066.md) | MA reports only when the struct is used with HashSet types                        |
| [CA1819](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1819?WT.mc_id=DT-MVP-5003978) | [MA0016](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0016.md) | CA only applies to arrays                                                         |
| [CA1822](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1822?WT.mc_id=DT-MVP-5003978) | [MA0038](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0038.md) | CA supports more cases and can be configured to only run against specific API surfaces |
| [CA1822](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1822?WT.mc_id=DT-MVP-5003978) | [MA0041](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0041.md) | CA supports more cases and can be configured to only run against specific API surfaces |
| [CA1826](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1826?WT.mc_id=DT-MVP-5003978) | [MA0020](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0020.md) | MA reports more cases such as `List<T>.Find` instead of `FirstOrDefault`          |
| [CA1827](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1827?WT.mc_id=DT-MVP-5003978) | [MA0031](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0031.md) | MA reports more `Count()` optimizations                                           |
| [CA1852](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca1852?WT.mc_id=DT-MVP-5003978) | [MA0053](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0053.md) | CA only applies to internal types in assemblies that do not expose internal types and members and - by default - report types that inherit from [Exception] (https://learn.microsoft.com/en-us/dotnet/api/system.exception?WT.mc_id=DT-MVP-5003978), but cannot be configured to report types that define virtual members |
| [CA2007](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2007?WT.mc_id=DT-MVP-5003978) | [MA0004](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0004.md) | MA does not report when the context is needed (WPF, WinForms, Blazor, etc.)       |
| [CA2016](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2016?WT.mc_id=DT-MVP-5003978) | [MA0040](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0040.md) | MA rules detects more CancellationToken                                           |
| [CA2016](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2016?WT.mc_id=DT-MVP-5003978) | [MA0032](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0032.md) | MA reports even if there is no CancellationToken available in the current context |
| [CA2016](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2016?WT.mc_id=DT-MVP-5003978) | [MA0079](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0079.md) | MA reports missing CancellationToken in `await foreach` expressions               |
| [CA2016](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2016?WT.mc_id=DT-MVP-5003978) | [MA0080](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0080.md) | MA reports missing CancellationToken in `await foreach` expressions               |
| [CA2208](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/quality-rules/ca2208?WT.mc_id=DT-MVP-5003978) | [MA0015](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0015.md) | MA reports more cases                                                             |
| [IDE0330](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/style-rules/ide0330?WT.mc_id=DT-MVP-5003978) | [MA0153](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0153.md) | MA supports variables in methods                                                  |
| [SA1649](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/SA1649.md)                         | [MA0048](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0048.md) | SA supports configuration of file naming convention and skips partial classes     |
| [S6580](https://rules.sonarsource.com/csharp/RSPEC-6580/)                                                                  | [MA0011](https://github.com/meziantou/Meziantou.Analyzer/blob/main/docs/Rules/MA0011.md) | S6580 only applies to parse methods, and also reports diagnostic when `null` is passed as value for format provider argument.|
