# MA0164 - Use parentheses to make not pattern clearer

`not` patterns are often wrongly used in combination with the `or` operator. This rule suggests using parentheses to make evaluation order clearer.

````c#
DayOfWeek day = DayOfWeek.Tuesday;

var isWeekday = day is not DayOfWeek.Saturday or DayOfWeek.Sunday;      // wrong
var isWeekday = day is not (DayOfWeek.Saturday or DayOfWeek.Sunday);    // ok
var isWeekday = day is not DayOfWeek.Saturday and not DayOfWeek.Sunday; // ok
````

````c#
_ = value is not null or ""; // not-compliant

_ = value is (not null) or ""; // ok
_ = value is not (null or ""); // ok
````

> **Warning**
Note that the provided code fix may not always be correct. It adds parenthesis to show the current evaluation order, but this may not be what is expected. It is recommended to review the code after applying the fix.
