# MA0163 - UseShellExecute must be false when redirecting standard input or output

Detects when `Process.Start` is called without specifying the value of `UseShellExecute`.

Specifying the value is important because:
- The default value for this property is `true` on .NET Framework apps and `false` on .NET Core apps. It's a common issue when migrating a desktop app from .NET Framework to .NET Core.
- It must be set to to `false` when redirecting I/O. Otherwise you'll get an issue at runtime.


````c#
using System.Diasgnostics;

// Non compliant

Process.Start("cmd"); // Intent is not clear if you want to use ShellExecute or not

Process.Start("https://www.meziantou.net/"); // Will fail on .NET Core apps

Process.Start(new ProcessStartInfo("cmd")
{
    RedirectStandardOutput = true,
    UseShellExecute = true,
});  // It will throw with error "UseShellExecute must be set to false when redirecting I/O"

Process.Start(new ProcessStartInfo("cmd")
{
    RedirectStandardOutput = true,
});  // It will throw with error "UseShellExecute must be set to false when redirecting I/O" on .NET Framework apps

// Compliant

Process.Start(new ProcessStartInfo("https://www.meziantou.net/")
{
    UseShellExecute = true,
});

Process.Start(new ProcessStartInfo("cmd")
{
    RedirectStandardOutput = true,
    UseShellExecute = false,
});

````
