# MA0162 - Use Process.Start overload with ProcessStartInfo

Detects when `Process.Start` is called without the `ProcessStartInfo` parameter.

Specifying a `ProcessStartInfo` allows to specify the `UseShellExecute` property. This value is important because the default value for this property is `true` on .NET Framework apps and `false` on .NET Core apps. It's a common issue when migrating a desktop app from .NET Framework to .NET Core.

````c#
using System.Diasgnostics;

// Non compliant

Process.Start("cmd"); // Intent is not clear if you want to use ShellExecute or not

Process.Start("https://www.meziantou.net/"); // Will fail on .NET Core apps

// Compliant

Process.Start(new ProcessStartInfo("https://www.meziantou.net/")
{
    UseShellExecute = true,
});

````
