# MA0158 - Use System.Threading.Lock

Starting with .NET 9 and C# 13, you can use `System.Threading.Lock`. When a field or a local variable is only used inside `lock`, this rule will suggest using `System.Threading.Lock` instead of `object`.

````c#
using System.Threading;

class MyClass
{
    private object _lock = new(); // non-compliant

    public void MyMethod()
    {
        lock (_lock)
        {            
        }
    }
}
````

````c#
using System.Threading;

class MyClass
{
    private Lock _lock = new(); // ok

    public void MyMethod()
    {
        lock (_lock)
        {            
        }
    }
}
````
