# MA0153 - Do not log symbols decorated with DataClassificationAttribute directly

Detects when a log parameter is decorated with an attribute that inherits from `Microsoft.Extensions.Compliance.Classification.DataClassificationAttribute`.
Most of the time, these values should not be used with `[LogProperties]` to redact values.

````c#
using Microsoft.Extensions.Logging;

ILogger logger;

// non-compliant as Prop is decorated with an attribute that inherits from DataClassificationAttribute
logger.LogInformation("{Prop}", new Dummy().Prop);

class Dummy
{
    [PiiAttribute]
    public string Prop { get; set; }
}

class PiiAttribute : Microsoft.Extensions.Compliance.Classification.DataClassificationAttribute
{
    public TaxonomyAttribute() : base(default)
    {
    }
}
````
