# MA0146 - Name must be set explicitly on local functions

Local function names are mangle by the compiler, so the `Name` named constructor parameter is required

````c#
// non compliant
void Sample()
{
    [UnsafeAccessor(UnsafeAccessorKind.Field)]
    extern static ref int _Major_(System.Version a);
}

// Ok
void Sample()
{
    [UnsafeAccessor(UnsafeAccessorKind.Field, Name = "_Major")]
    extern static ref int _Major_(System.Version a);
}
````
