# MA0145 - Signature for \[UnsafeAccessorAttribute\] method is not valid

Report some cases where a method decorated with `[UnsafeAccessorAttribute]` is not valid.

Note: Because some references doesn't expose their private members through Roslyn, it's not possible to validate the full signature.

````c#
[UnsafeAccessor(UnsafeAccessorKind.Field, Name = "dummy")]
extern static ref int Demo(MyStruct a); // Not compliant as the first parameter is not by ref

[UnsafeAccessor(UnsafeAccessorKind.Field, Name = "dummy")]
extern static ref int Demo(ref MyStruct a); // ok
````
