# MA0136 - Raw String contains an implicit end of line character

When using a raw string `"""test"""` that contains a new line, the end of line may depend on the user's configuration (`\n` or `\r\n`).
Also, some tools such as git can change the end of line from `\n` to `\r\n` or `\r\n` to `\n`.

This means the compilation may not be deterministic.

````csharp
// ok
_ = """line1"""
_ = """
    line1
    """

// non-compliant
_ = """
    line1
    line2
    """;
````
