# MA0135 - The log parameter has no configured type

This rule ensures the parameters for Microsoft.Extensions.Logging's logger can be found in the configuration file (`LoggerParameterTypes.txt` or `LoggerParameterTypes.*.txt`).

````
# LoggerParameterTypes.txt
Name;System.String
````

````c#
using Microsoft.Extensions.Logging;

ILogger logger = null;
logger.LogInformation("{Prop}", 2); // non-compliant as "Prop" is not defined in the configuration file
logger.LogInformation("{Name}", ""); // ok as Name is defined in the configuration file
````
