# MA0132 - Do not convert implicitly to DateTimeOffset

Implicit conversions from `DateTime` to `DateTimeOffset` are dangerous. The result depends on `DateTime.Kind` which is often `Unspecified`, and so, fallback to a local time.
This may not be desired. Also, this may indicate that you are mixing `DateTime` and `DateTimeOffset` in your application, which may be unintentional.

````c#
DateTime dt = ...;

dt - DateTimeOffset.UtcNow; // non-compliant as there is an implicit conversion from DateTime to DateTimeOffset

DateTimeOffset.UtcNow - DateTimeOffset.UtcNow;  // ok
new DateTimeOffset(dt) - DateTimeOffset.UtcNow; // ok
(DateTimeOffset)dt - DateTimeOffset.UtcNow;     // ok
````
