# MA0128 - Use 'is' operator instead of SequenceEqual

In C# 11, the `MemoryExtensions.SequenceEqual` and `MemoryExtensions.Equals` can be simplified when the value is a constant string.

````
ReadOnlySpan<char> span = "foo";

_ = span.Equals("bar", StringComparison.Ordinal); // report diagnostic
_ = span is "bar";

_ = span.SequenceEqual("bar"); // report diagnostic
_ = span is "bar";
````
