# MA0127 - Use String.Equals instead of is pattern

Note that this rule is disabled by default and must be enabled manually using an `.editorconfig` file.

You should use `string.Equals` instead of `is`, to make string comparison rules explicit. _Similar to [MA0006](./MA0006.md) but for patterns._

````csharp
_ str = is "foo";

// Should be
string.Equals(str, foo, StringComparison.Ordinal);
````

## Additional resources

- [Best practices for comparing strings in .NET](https://learn.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings?WT.mc_id=DT-MVP-5003978#specifying-string-comparisons-explicitly)
- [String comparisons are harder than it seems](https://www.meziantou.net/string-comparisons-are-harder-than-it-seems.htm)
