# MA0122 - Parameters with \[SupplyParameterFromQuery\] attributes are only valid in routable components (@page)

Component parameters can only receive query parameter values in routable components with an `@page` directive.

````razor
@code {
    // non-compliant as there is no @page
    [Parameter, SupplyParameterFromQuery]
    public int Value { get; set; }
}
````

````razor
@page "/"
@code {
    // ok
    [Parameter, SupplyParameterFromQuery]
    public int Value { get; set; }
}
````

[ASP.NET Core Blazor routing and navigation - Query strings](https://learn.microsoft.com/en-us/aspnet/core/blazor/fundamentals/routing?view=aspnetcore-6.0&WT.mc_id=DT-MVP-5003978#query-strings)
