# MA0120 - Use InvokeVoidAsync when the returned value is not used

Simplify the usage of `IJSRuntime` or `IJSInProcessRuntime` when the returned value is not used.

````c#
IJSInProcessRuntime js = ...;

await js.InvokeVoidAsync("dummy"); // compliant
var result = await js.InvokeAsync<object>("dummy"); // compliant
Console.WriteLine(await js.InvokeAsync<object>("dummy")); // compliant 

await js.InvokeAsync<object>("dummy"); // not-compliant => use InvokeVoidAsync
````
