# MA0119 - JSRuntime must not be used in OnInitialized or OnInitializedAsync

In a Blazor component, JSRuntime is not available in `OnInitialize` or `OnInitializedAsync`. The analyzer also reports usages of `ProtectedBrowserStorage` and derived classes as it uses `IJSRuntime` under the hood.


> **Note**
> If the analyzer is able to detect a Blazor WebAssembly context, then the rule is disabled.

````c#
using System.Threading.Tasks;
using Microsoft.AspNetCore.Components;
using Microsoft.JSInterop;

class MyComponent : ComponentBase
{
    public IJSRuntime JS { get; set; }
    
    protected override void OnInitialized()
    {
        _ = JS.InvokeVoidAsync("dummy"); // non-compliant
    }

    protected override async Task OnInitializedAsync()
    {
        await JS.InvokeVoidAsync("dummy");  // non-compliant
    }

    private async Task OtherMethod()
    {
        await JS.InvokeVoidAsync("dummy");  // ok
    }
}
````
