# MA0117 - Parameters with \[EditorRequired\] attributes should also be marked as \[Parameter\]

Detect when `[EditorRequired]` attributes are used without the `[Parameter]` attribute.

````razor
using Microsoft.AspNetCore.Components;

@code {
    [EditorRequired] // non-compliant
    public int A { get; set; }

    [Parameter]
    [EditorRequired] // ok as the property has the Parameter attribute
    public int B { get; set; }
}
````
