# MA0116 - Parameters with \[SupplyParameterFromQuery\] attributes should also be marked as \[Parameter\]

Detect when `[SupplyParameterFromQuery]` attributes are used without the `[Parameter]` attributes.

````razor
using Microsoft.AspNetCore.Components;

@code {
    [SupplyParameterFromQuery] // non-compliant
    public int A { get; set; }

    [Parameter]
    [SupplyParameterFromQuery] // ok as the property has the Parameter attribute
    public int B { get; set; }
}
````
