# MA0115 - Unknown component parameter

Detect usage of invalid parameter in Razor components.

```razor
@* SampleComponent *@
<p>@Text</p>

@code {
    [Parameter]
    public string Text { get; set; }
}
```

```razor
<SampleComponent
    Text="Dummy"
    InvalidParameter="Dummy" />  // Report diagnostic as `InvalidParameter` does not exist in SampleComponent
```

In the case where the component allows for unmatched parameters, you can still detect parameters that are in PascalCase.

```.editorconfig
MA0115.ReportPascalCaseUnmatchedParameter
```

In the following example, `Param` is reported as an unmatched parameter.

````c#
class MyComponent : ComponentBase
{
    [Parameter(CaptureUnmatchedValues = true)]
    public Dictionary<string, object> AdditionalAttributes { get; set; }
}
````

````razor
@*
attribute1 is valid as it starts with a lowercase character
InvalidParameter is not valid as it starts with an uppercase character
*@
<MyComponent validAttribute="value" InvalidParameter="value" />
````
