# MA0111 - Use string.Create instead of FormattableString

Use `string.Create` instead of `FormattableString` when possible.

````c#
FormattableString.Invariant($""); // report diagnostic

string.Create(CultureInfo.Invariant, $""); // ok
````

# Benchmark

````c#
using System.Globalization;
using BenchmarkDotNet.Attributes;

namespace Benchmark;

[MemoryDiagnoser]
[ReturnValueValidator]
public class StringCreateBenchmark
{
    int a = 1;
    DateTime b = DateTime.UtcNow;

    [Benchmark]
    public string StringCreate()
    {
        return string.Create(CultureInfo.InvariantCulture, $"text {a} test {b}");
    }

    [Benchmark]
    public string FormattableStringInvariant()
    {
        return FormattableString.Invariant($"text {a} test {b}");
    }
}
````

````
BenchmarkDotNet=v0.13.1, OS=Windows 10.0.22622
AMD Ryzen 7 5800X, 1 CPU, 16 logical and 8 physical cores
.NET SDK=7.0.100-preview.7.22377.5
  [Host]     : .NET 7.0.0 (7.0.22.37506), X64 RyuJIT
  DefaultJob : .NET 7.0.0 (7.0.22.37506), X64 RyuJIT
````

|                     Method |     Mean |   Error |  StdDev |  Gen 0 | Allocated |
|--------------------------- |---------:|--------:|--------:|-------:|----------:|
|               StringCreate | 150.9 ns | 2.30 ns | 2.15 ns | 0.0052 |      88 B |
| FormattableStringInvariant | 170.3 ns | 2.32 ns | 2.17 ns | 0.0124 |     208 B |
