# MA0106 - Avoid closure by using an overload with the 'factoryArgument' parameter

````c#
using System.Collections.Concurrent;

var key = 1;
var value = 1;
var dict = new ConcurrentDictionary<int, int>();
dict.GetOrAdd(key, _ => value); // report diagnostic

dict.GetOrAdd(key, (_, v) => v, value); // ok
````

- [ConcurrentDictionary + closure = 💔](https://www.meziantou.net/concurrentdictionary-closure.htm)
