# MA0102 - Make member readonly

A struct member should use the `readonly` modifier when it does not modify state.

> **Note**
> This rule is enabled when using C# 8 or later

````c#
struct Sample
{
    int a;

    public int A => a; // non-compliant
}
````

````c#
struct Sample
{
    int a;

    public readonly int A => a; // compliant
}
````

# Additional resources

- [Readonly Instance Members](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/proposals/csharp-8.0/readonly-instance-members?WT.mc_id=DT-MVP-5003978)
